/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.DeprecatedAttributeWriteHandler;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.PooledConnectionFactoryAdd;
import org.jboss.as.messaging.jms.PooledConnectionFactoryRemove;
import org.jboss.as.messaging.jms.PooledConnectionFactoryWriteAttributeHandler;
import org.jboss.dmr.ModelNode;

public class PooledConnectionFactoryDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"pooled-connection-factory");
    public static final ConnectionFactoryAttribute[] ATTRIBUTES = PooledConnectionFactoryDefinition.define(ConnectionFactoryAttributes.Pooled.ATTRIBUTES, ConnectionFactoryAttributes.Common.ATTRIBUTES);
    private static final DescriptionProvider DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return MessagingDescriptions.getPooledConnectionFactory(locale);
        }
    };
    private final boolean registerRuntimeOnly;

    private static ConnectionFactoryAttribute[] define(ConnectionFactoryAttribute[] common, ConnectionFactoryAttribute ... specific) {
        int size = common.length + specific.length;
        ConnectionFactoryAttribute[] result = new ConnectionFactoryAttribute[size];
        System.arraycopy(common, 0, result, 0, common.length);
        System.arraycopy(specific, 0, result, common.length, specific.length);
        for (int i = 0; i < result.length; ++i) {
            ConnectionFactoryAttribute attribute = result[i];
            if (attribute.getDefinition() != CommonAttributes.RECONNECT_ATTEMPTS) continue;
            result[i] = ConnectionFactoryAttribute.create(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS, "reconnectAttempts", true);
        }
        return result;
    }

    public PooledConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(PATH, DESC);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        EnumSet<AttributeAccess.Flag> flags = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        for (AttributeDefinition attr : ConnectionFactoryAttribute.getDefinitions(ATTRIBUTES)) {
            if (attr == ConnectionFactoryAttributes.Common.DISCOVERY_INITIAL_WAIT_TIMEOUT || attr == ConnectionFactoryAttributes.Common.FAILOVER_ON_SERVER_SHUTDOWN) {
                registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)new DeprecatedAttributeWriteHandler(attr.getName()));
                continue;
            }
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr.getName(), null, (OperationStepHandler)PooledConnectionFactoryWriteAttributeHandler.INSTANCE, flags);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        super.registerAddOperation(registry, (AbstractAddStepHandler)PooledConnectionFactoryAdd.INSTANCE, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_NONE});
        super.registerRemoveOperation(registry, (AbstractRemoveStepHandler)PooledConnectionFactoryRemove.INSTANCE, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }
}

