/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import org.hornetq.jms.bridge.JMSBridge;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.bridge.JMSBridgeService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class JMSBridgeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSBridgeHandler INSTANCE = new JMSBridgeHandler();
    private ParametersValidator readAttributeValidator = new ParametersValidator();

    private JMSBridgeHandler() {
        this.readAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String bridgeName = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        final String operationName = operation.require("operation").asString();
        boolean modify = !"read-attribute".equals(operationName);
        ServiceName bridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName);
        final ServiceController bridgeService = context.getServiceRegistry(modify).getService(bridgeServiceName);
        if (bridgeService == null) {
            throw new OperationFailedException(ControllerMessages.MESSAGES.noHandler("read-attribute", PathAddress.pathAddress((ModelNode)operation.require("address"))));
        }
        final JMSBridge bridge = (JMSBridge)JMSBridge.class.cast(bridgeService.getValue());
        if ("read-attribute".equals(operationName)) {
            this.readAttributeValidator.validate(operation);
            String name = operation.require("name").asString();
            if ("started".equals(name)) {
                context.getResult().set(bridge.isStarted());
            } else {
                if (!CommonAttributes.PAUSED.equals(name)) throw MessagingMessages.MESSAGES.unsupportedAttribute(name);
                context.getResult().set(bridge.isPaused());
            }
        } else if ("start".equals(operationName)) {
            try {
                JMSBridgeService service = (JMSBridgeService)bridgeService.getService();
                service.startBridge();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else if ("stop".equals(operationName)) {
            try {
                bridge.stop();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else if ("pause".equals(operationName)) {
            try {
                bridge.pause();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            if (!"resume".equals(operationName)) throw MessagingMessages.MESSAGES.unsupportedOperation(operationName);
            try {
                bridge.resume();
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                try {
                    if ("start".equals(operationName)) {
                        bridge.stop();
                    } else if ("stop".equals(operationName)) {
                        JMSBridgeService service = (JMSBridgeService)bridgeService.getService();
                        service.startBridge();
                    } else if ("pause".equals(operationName)) {
                        bridge.resume();
                    } else if ("resume".equals(operationName)) {
                        bridge.pause();
                    }
                }
                catch (Exception e) {
                    MessagingLogger.ROOT_LOGGER.revertOperationFailed(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
                }
            }
        });
    }
}

