/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.util.EnumSet;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.descriptions.common.CoreManagementDefinition;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionResourceDefinition;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.InterfaceRemoveHandler;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.ProcessStateAttributeHandler;
import org.jboss.as.controller.operations.common.ResolveExpressionHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupRemoveHandler;
import org.jboss.as.controller.operations.common.ValidateAddressOperationHandler;
import org.jboss.as.controller.operations.common.ValidateOperationHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.resource.InterfaceDefinition;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.WhoAmIOperation;
import org.jboss.as.platform.mbean.PlatformMBeanResourceRegistrar;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentResourceDescription;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.ServerDeploymentResourceDescription;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.controller.resources.VaultResourceDefinition;
import org.jboss.as.server.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.server.deployment.DeploymentReplaceHandler;
import org.jboss.as.server.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.server.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.server.deployment.DeploymentUploadURLHandler;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayDefinition;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayPriority;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.mgmt.NativeRemotingManagementResourceDefinition;
import org.jboss.as.server.operations.DumpServicesHandler;
import org.jboss.as.server.operations.LaunchTypeHandler;
import org.jboss.as.server.operations.ProcessTypeHandler;
import org.jboss.as.server.operations.RootResourceHack;
import org.jboss.as.server.operations.RunningModeReadHandler;
import org.jboss.as.server.operations.ServerProcessReloadHandler;
import org.jboss.as.server.operations.ServerRestartRequiredHandler;
import org.jboss.as.server.operations.ServerShutdownHandler;
import org.jboss.as.server.operations.ServerVersionOperations;
import org.jboss.as.server.services.net.BindingGroupAddHandler;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.NetworkInterfaceRuntimeHandler;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.as.server.services.net.SpecifiedInterfaceAddHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceRemoveHandler;
import org.jboss.as.server.services.net.SpecifiedInterfaceResolveHandler;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelType;

public class ServerRootResourceDefinition
extends SimpleResourceDefinition {
    private static final ParameterValidator NOT_NULL_STRING_LENGTH_ONE_VALIDATOR = new StringLengthValidator(1, false, false);
    public static final AttributeDefinition NAMESPACES = new SimpleMapAttributeDefinition.Builder(new PropertiesAttributeDefinition.Builder("namespaces", false).build()).build();
    public static final AttributeDefinition SCHEMA_LOCATIONS = new SimpleMapAttributeDefinition.Builder(new PropertiesAttributeDefinition.Builder("schema-locations", false).build()).build();
    public static final SimpleAttributeDefinition NAME = SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    public static final SimpleAttributeDefinition RELEASE_VERSION = SimpleAttributeDefinitionBuilder.create((String)"release-version", (ModelType)ModelType.STRING, (boolean)false).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition RELEASE_CODENAME = SimpleAttributeDefinitionBuilder.create((String)"release-codename", (ModelType)ModelType.STRING, (boolean)false).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition PRODUCT_NAME = SimpleAttributeDefinitionBuilder.create((String)"product-name", (ModelType)ModelType.STRING, (boolean)true).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition PRODUCT_VERSION = SimpleAttributeDefinitionBuilder.create((String)"product-version", (ModelType)ModelType.STRING, (boolean)true).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MAJOR_VERSION = SimpleAttributeDefinitionBuilder.create((String)"management-major-version", (ModelType)ModelType.INT, (boolean)false).setValidator((ParameterValidator)new IntRangeValidator(1)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MINOR_VERSION = SimpleAttributeDefinitionBuilder.create((String)"management-minor-version", (ModelType)ModelType.INT, (boolean)false).setValidator((ParameterValidator)new IntRangeValidator(0)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MICRO_VERSION = SimpleAttributeDefinitionBuilder.create((String)"management-micro-version", (ModelType)ModelType.INT, (boolean)false).setValidator((ParameterValidator)new IntRangeValidator(0)).build();
    public static final SimpleAttributeDefinition PROFILE_NAME = SimpleAttributeDefinitionBuilder.create((String)"profile-name", (ModelType)ModelType.STRING, (boolean)false).setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition NULL_PROFILE_NAME = SimpleAttributeDefinitionBuilder.create((String)"profile-name", (ModelType)ModelType.STRING, (boolean)true).build();
    public static final SimpleAttributeDefinition SERVER_STATE = SimpleAttributeDefinitionBuilder.create((String)"server-state", (ModelType)ModelType.STRING).setStorageRuntime().setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition PROCESS_TYPE = SimpleAttributeDefinitionBuilder.create((String)"process-type", (ModelType)ModelType.STRING).setStorageRuntime().setValidator(NOT_NULL_STRING_LENGTH_ONE_VALIDATOR).build();
    public static final SimpleAttributeDefinition LAUNCH_TYPE = SimpleAttributeDefinitionBuilder.create((String)"launch-type", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(ServerEnvironment.LaunchType.class, false, false)).setStorageRuntime().build();
    private static final EnumSet<OperationEntry.Flag> runtimeOnlyFlag = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);
    public static final AttributeDefinition RUNNING_MODE = SimpleAttributeDefinitionBuilder.create((String)"running-mode", (ModelType)ModelType.STRING).setValidator((ParameterValidator)new EnumValidator(RunningMode.class, false, false)).setStorageRuntime().build();
    private final boolean isDomain;
    private final ContentRepository contentRepository;
    private final ExtensibleConfigurationPersister extensibleConfigurationPersister;
    private final ServerEnvironment serverEnvironment;
    private final ControlledProcessState processState;
    private final RunningModeControl runningModeControl;
    private final AbstractVaultReader vaultReader;
    private final ExtensionRegistry extensionRegistry;
    private final boolean parallelBoot;
    private final PathManagerService pathManager;

    public ServerRootResourceDefinition(ContentRepository contentRepository, ExtensibleConfigurationPersister extensibleConfigurationPersister, ServerEnvironment serverEnvironment, ControlledProcessState processState, RunningModeControl runningModeControl, AbstractVaultReader vaultReader, ExtensionRegistry extensionRegistry, boolean parallelBoot, PathManagerService pathManager) {
        super(PathElement.pathElement((String)"this-will-be-ignored-since-we-are-root"), ServerDescriptions.getResourceDescriptionResolver("server", false));
        this.contentRepository = contentRepository;
        this.extensibleConfigurationPersister = extensibleConfigurationPersister;
        this.serverEnvironment = serverEnvironment;
        this.processState = processState;
        this.runningModeControl = runningModeControl;
        this.vaultReader = vaultReader;
        this.extensionRegistry = extensionRegistry;
        this.parallelBoot = parallelBoot;
        this.pathManager = pathManager;
        this.isDomain = serverEnvironment == null || serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.DOMAIN;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        GlobalOperationHandlers.registerGlobalOperations((ManagementResourceRegistration)resourceRegistration, (ProcessType)ProcessType.STANDALONE_SERVER);
        if (this.serverEnvironment != null) {
            resourceRegistration.registerOperationHandler(ValidateOperationHandler.DEFINITION, (OperationStepHandler)ValidateOperationHandler.INSTANCE);
        } else {
            resourceRegistration.registerOperationHandler(ValidateOperationHandler.DEFINITION, (OperationStepHandler)ValidateOperationHandler.INSTANCE);
        }
        resourceRegistration.registerOperationHandler(CompositeOperationHandler.DEFINITION, (OperationStepHandler)CompositeOperationHandler.INSTANCE, false);
        XmlMarshallingHandler xmh = new XmlMarshallingHandler((ConfigurationPersister)this.extensibleConfigurationPersister);
        resourceRegistration.registerOperationHandler((OperationDefinition)XmlMarshallingHandler.DEFINITION, (OperationStepHandler)xmh);
        resourceRegistration.registerOperationHandler(NamespaceAddHandler.DEFINITION, (OperationStepHandler)NamespaceAddHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(NamespaceRemoveHandler.DEFINITION, (OperationStepHandler)NamespaceRemoveHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(SchemaLocationAddHandler.DEFINITION, (OperationStepHandler)SchemaLocationAddHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(SchemaLocationRemoveHandler.DEFINITION, (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(ValidateAddressOperationHandler.DEFINITION, (OperationStepHandler)ValidateAddressOperationHandler.INSTANCE, false);
        DeploymentUploadBytesHandler.register(resourceRegistration, this.contentRepository);
        DeploymentUploadURLHandler.register(resourceRegistration, this.contentRepository);
        DeploymentUploadStreamAttachmentHandler.register(resourceRegistration, this.contentRepository);
        resourceRegistration.registerOperationHandler(DeploymentAttributes.REPLACE_DEPLOYMENT_DEFINITION, (OperationStepHandler)DeploymentReplaceHandler.create(this.contentRepository, this.vaultReader));
        resourceRegistration.registerOperationHandler(DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_DEFINITION, (OperationStepHandler)DeploymentFullReplaceHandler.create(this.contentRepository, this.vaultReader));
        if (!this.isDomain) {
            SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)this.extensibleConfigurationPersister);
            resourceRegistration.registerOperationHandler(SnapshotDeleteHandler.DEFINITION, (OperationStepHandler)snapshotDelete);
            SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)this.extensibleConfigurationPersister);
            resourceRegistration.registerOperationHandler(SnapshotListHandler.DEFINITION, (OperationStepHandler)snapshotList);
            SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)this.extensibleConfigurationPersister);
            resourceRegistration.registerOperationHandler(SnapshotTakeHandler.DEFINITION, (OperationStepHandler)snapshotTake);
        }
        resourceRegistration.registerOperationHandler((OperationDefinition)ServerRestartRequiredHandler.DEFINITION, (OperationStepHandler)ServerRestartRequiredHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(ResolveExpressionHandler.DEFINITION, (OperationStepHandler)ResolveExpressionHandler.INSTANCE, false);
        resourceRegistration.registerOperationHandler((OperationDefinition)SpecifiedInterfaceResolveHandler.DEFINITION, (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)WhoAmIOperation.DEFINITION, (OperationStepHandler)WhoAmIOperation.INSTANCE, true);
        resourceRegistration.registerOperationHandler(RootResourceHack.DEFINITION, (OperationStepHandler)RootResourceHack.INSTANCE);
        if (this.serverEnvironment != null) {
            if (this.serverEnvironment.getLaunchType() != ServerEnvironment.LaunchType.DOMAIN) {
                ServerProcessReloadHandler reloadHandler = new ServerProcessReloadHandler(Services.JBOSS_AS, this.runningModeControl, this.processState);
                resourceRegistration.registerOperationHandler(ServerProcessReloadHandler.DEFINITION, (OperationStepHandler)reloadHandler, false);
            }
            if (this.serverEnvironment.getLaunchType() == ServerEnvironment.LaunchType.STANDALONE) {
                ServerShutdownHandler serverShutdownHandler = new ServerShutdownHandler(this.processState);
                resourceRegistration.registerOperationHandler((OperationDefinition)ServerShutdownHandler.DEFINITION, (OperationStepHandler)serverShutdownHandler);
            }
            resourceRegistration.registerSubModel((ResourceDefinition)ServerEnvironmentResourceDescription.of(this.serverEnvironment));
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.serverEnvironment != null) {
            if (this.isDomain) {
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)NAME, this.serverEnvironment.getProcessNameReadHandler());
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PROFILE_NAME, null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1));
            } else {
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)NAME, this.serverEnvironment.getProcessNameReadHandler(), this.serverEnvironment.getProcessNameWriteHandler());
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)NULL_PROFILE_NAME, null);
            }
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)LAUNCH_TYPE, (OperationStepHandler)new LaunchTypeHandler(this.serverEnvironment.getLaunchType()));
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)SERVER_STATE, (OperationStepHandler)new ProcessStateAttributeHandler(this.processState));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PROCESS_TYPE, (OperationStepHandler)ProcessTypeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(RUNNING_MODE, (OperationStepHandler)new RunningModeReadHandler(this.runningModeControl));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MAJOR_VERSION, ServerVersionOperations.ManagementVersionAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MINOR_VERSION, ServerVersionOperations.ManagementVersionAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)MANAGEMENT_MICRO_VERSION, ServerVersionOperations.ManagementVersionAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RELEASE_VERSION, ServerVersionOperations.ReleaseVersionAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RELEASE_CODENAME, ServerVersionOperations.ReleaseVersionAttributeHandler.INSTANCE);
        ServerVersionOperations.ProductInfoAttributeHandler infoHandler = new ServerVersionOperations.ProductInfoAttributeHandler(this.serverEnvironment != null ? this.serverEnvironment.getProductConfig() : null);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PRODUCT_NAME, (OperationStepHandler)infoHandler);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PRODUCT_VERSION, (OperationStepHandler)infoHandler);
        resourceRegistration.registerReadOnlyAttribute(NAMESPACES, ServerVersionOperations.DefaultEmptyListAttributeHandler.INSTANCE);
        resourceRegistration.registerReadOnlyAttribute(SCHEMA_LOCATIONS, ServerVersionOperations.DefaultEmptyListAttributeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)SystemPropertyResourceDefinition.createForStandaloneServer(this.serverEnvironment));
        resourceRegistration.registerSubModel((ResourceDefinition)new VaultResourceDefinition(this.vaultReader));
        ManagementResourceRegistration management = resourceRegistration.registerSubModel((ResourceDefinition)CoreManagementDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)SecurityRealmResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)LdapConnectionResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)NativeManagementResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)NativeRemotingManagementResourceDefinition.INSTANCE);
        management.registerSubModel((ResourceDefinition)HttpManagementResourceDefinition.INSTANCE);
        ManagementResourceRegistration serviceContainer = resourceRegistration.registerSubModel((ResourceDefinition)new SimpleResourceDefinition(PathElement.pathElement((String)"core-service", (String)"service-container"), ControllerResolver.getResolver((String[])new String[]{"core", "service-container"})));
        serviceContainer.registerOperationHandler((OperationDefinition)DumpServicesHandler.DEFINITION, (OperationStepHandler)DumpServicesHandler.INSTANCE);
        PlatformMBeanResourceRegistrar.registerPlatformMBeanResources((ManagementResourceRegistration)resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)PathResourceDefinition.createSpecified((PathManagerService)this.pathManager));
        ManagementResourceRegistration interfaces = resourceRegistration.registerSubModel((ResourceDefinition)new InterfaceDefinition((InterfaceAddHandler)SpecifiedInterfaceAddHandler.INSTANCE, (InterfaceRemoveHandler)SpecifiedInterfaceRemoveHandler.INSTANCE, true));
        interfaces.registerReadOnlyAttribute((AttributeDefinition)NetworkInterfaceRuntimeHandler.RESOLVED_ADDRESS, NetworkInterfaceRuntimeHandler.INSTANCE);
        interfaces.registerOperationHandler((OperationDefinition)SpecifiedInterfaceResolveHandler.DEFINITION, (OperationStepHandler)SpecifiedInterfaceResolveHandler.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)new SocketBindingGroupResourceDefinition((OperationStepHandler)BindingGroupAddHandler.INSTANCE, (OperationStepHandler)SocketBindingGroupRemoveHandler.INSTANCE, false, new ResourceDefinition[]{SocketBindingResourceDefinition.INSTANCE, RemoteDestinationOutboundSocketBindingResourceDefinition.INSTANCE, LocalDestinationOutboundSocketBindingResourceDefinition.INSTANCE}));
        ManagementResourceRegistration deployments = resourceRegistration.registerSubModel((ResourceDefinition)ServerDeploymentResourceDescription.create(this.contentRepository, this.vaultReader));
        resourceRegistration.registerSubModel((ResourceDefinition)new DeploymentOverlayDefinition(DeploymentOverlayPriority.SERVER, this.contentRepository, null));
        deployments.registerSubModel((ResourceDefinition)new SimpleResourceDefinition(PathElement.pathElement((String)"subdeployment"), DeploymentAttributes.DEPLOYMENT_RESOLVER));
        resourceRegistration.registerSubModel((ResourceDefinition)new ExtensionResourceDefinition(this.extensionRegistry, this.parallelBoot, false));
        if (this.extensionRegistry != null) {
            this.extensionRegistry.setSubsystemParentResourceRegistrations(resourceRegistration, deployments);
            this.extensionRegistry.setPathManager((PathManager)this.pathManager);
        }
        resourceRegistration.registerOperationHandler((OperationDefinition)DeployerChainAddHandler.DEFINITION, (OperationStepHandler)DeployerChainAddHandler.INSTANCE, false);
    }
}

