/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;

public class DeploymentRedeployHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "redeploy";
    private final AbstractVaultReader vaultReader;

    public DeploymentRedeployHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String runtimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, model).asString();
        DeploymentHandlerUtil.ContentItem[] contents = DeploymentHandlerUtils.getContents(DeploymentAttributes.CONTENT_ALL.resolveModelAttribute(context, model));
        DeploymentHandlerUtil.redeploy(context, runtimeName, name, this.vaultReader, contents);
        context.stepCompleted();
    }
}

