/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.as.server.ServerLogger;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.mgmt.domain.HostControllerConnection;
import org.jboss.as.server.mgmt.domain.RemoteFileRepositoryExecutor;
import org.jboss.as.server.mgmt.domain.ServerToHostRemoteFileRequestAndHandler;
import org.jboss.dmr.ModelNode;

public class HostControllerClient
implements Closeable {
    private final String serverName;
    private final HostControllerConnection connection;
    private final ManagementChannelHandler channelHandler;
    private final RemoteFileRepositoryExecutorImpl executor;

    HostControllerClient(String serverName, ManagementChannelHandler channelHandler, HostControllerConnection connection) {
        this.serverName = serverName;
        this.connection = connection;
        this.channelHandler = channelHandler;
        this.executor = new RemoteFileRepositoryExecutorImpl();
    }

    public String getServerName() {
        return this.serverName;
    }

    void resolveBootUpdates(ModelController controller, ActiveOperation.CompletedCallback<ModelNode> callback) throws Exception {
        this.connection.openConnection(controller, callback);
    }

    RemoteFileRepositoryExecutor getRemoteFileRepository() {
        return this.executor;
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void reconnect(String hostName, int port, byte[] authKey) throws IOException, URISyntaxException {
        String host = NetworkUtils.formatPossibleIpv6Address((String)hostName);
        URI uri = new URI("remote://" + host + ":" + port);
        this.connection.reConnect(uri, authKey);
    }

    private class RemoteFileRepositoryExecutorImpl
    implements RemoteFileRepositoryExecutor {
        private RemoteFileRepositoryExecutorImpl() {
        }

        @Override
        public File getFile(String relativePath, byte repoId, File localDeploymentFolder) {
            try {
                return (File)HostControllerClient.this.channelHandler.executeRequest((ManagementRequest)new GetFileRequest(relativePath, localDeploymentFolder), null).getResult().get();
            }
            catch (Exception e) {
                throw ServerMessages.MESSAGES.failedToGetFileFromRemoteRepository(e);
            }
        }
    }

    private static class GetFileRequest
    extends AbstractManagementRequest<File, Void> {
        private final String hash;
        private final File localDeploymentFolder;

        private GetFileRequest(String hash, File localDeploymentFolder) {
            this.hash = hash;
            this.localDeploymentFolder = localDeploymentFolder;
        }

        public byte getOperationType() {
            return 36;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            ServerToHostRemoteFileRequestAndHandler.INSTANCE.sendRequest(output, (byte)0, this.hash);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            try {
                File first = new File(this.localDeploymentFolder, this.hash.substring(0, 2));
                File localPath = new File(first, this.hash.substring(2));
                ServerToHostRemoteFileRequestAndHandler.INSTANCE.handleResponse(input, localPath, ServerLogger.ROOT_LOGGER, resultHandler, context);
                resultHandler.done(null);
            }
            catch (RemoteFileRequestAndHandler.CannotCreateLocalDirectoryException e) {
                resultHandler.failed((Exception)ServerMessages.MESSAGES.cannotCreateLocalDirectory(e.getDir()));
            }
            catch (RemoteFileRequestAndHandler.DidNotReadEntireFileException e) {
                resultHandler.failed((Exception)ServerMessages.MESSAGES.didNotReadEntireFile(e.getMissing()));
            }
        }
    }
}

