/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.operations.SecurityActions;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleClassLoader;

public class ServerVersionOperations {

    public static class DefaultEmptyListAttributeHandler
    implements OperationStepHandler {
        public static final OperationStepHandler INSTANCE = new DefaultEmptyListAttributeHandler();

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attr = operation.get("name").asString();
            if (attr.equals("namespaces")) {
                this.getAttributeValueOrDefault(ServerRootResourceDefinition.NAMESPACES, context);
            } else if (attr.equals("schema-locations")) {
                this.getAttributeValueOrDefault(ServerRootResourceDefinition.SCHEMA_LOCATIONS, context);
            }
            context.stepCompleted();
        }

        private void getAttributeValueOrDefault(AttributeDefinition def, OperationContext context) throws OperationFailedException {
            ModelNode result = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel().get(def.getName());
            context.getResult().set(result.isDefined() ? result : new ModelNode().setEmptyList());
        }
    }

    public static class ProductInfoAttributeHandler
    implements OperationStepHandler {
        final ProductConfig cfg;

        public ProductInfoAttributeHandler(ProductConfig cfg) {
            this.cfg = cfg;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attr = operation.get("name").asString();
            if (this.cfg != null) {
                String productName;
                if (attr.equals("product-version")) {
                    String productVersion = this.cfg.getProductVersion();
                    if (productVersion != null) {
                        context.getResult().set(productVersion);
                    }
                    context.getResult();
                } else if (attr.equals("product-name") && (productName = this.cfg.getProductName()) != null) {
                    context.getResult().set(productName);
                }
            }
            context.stepCompleted();
        }
    }

    public static class ReleaseVersionAttributeHandler
    implements OperationStepHandler {
        public static final OperationStepHandler INSTANCE = new ReleaseVersionAttributeHandler();

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attr = operation.get("name").asString();
            try {
                if (attr.equals("release-version")) {
                    context.getResult().set(Version.AS_VERSION);
                } else if (attr.equals("release-codename")) {
                    context.getResult().set(Version.AS_RELEASE_CODENAME);
                }
            }
            catch (RuntimeException e) {
                if (SecurityActions.getClassLoader(this.getClass()) instanceof ModuleClassLoader) {
                    throw new OperationFailedException(e.getMessage());
                }
                context.getResult().set("-");
            }
            context.stepCompleted();
        }
    }

    public static class ManagementVersionAttributeHandler
    implements OperationStepHandler {
        public static final OperationStepHandler INSTANCE = new ManagementVersionAttributeHandler();

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attr = operation.get("name").asString();
            if (attr.equals("management-major-version")) {
                context.getResult().set(1);
            } else if (attr.equals("management-minor-version")) {
                context.getResult().set(4);
            } else if (attr.equals("management-micro-version")) {
                context.getResult().set(0);
            }
            context.stepCompleted();
        }
    }
}

