/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.operations.SecurityActions;
import org.jboss.dmr.ModelNode;

public class SystemPropertyAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;
    private final boolean useBoottime;
    private final AttributeDefinition[] attributes;

    public static ModelNode getOperation(ModelNode address, String value) {
        return SystemPropertyAddHandler.getOperation(address, value, null);
    }

    public static ModelNode getOperation(ModelNode address, String value, Boolean boottime) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (value == null) {
            op.get(SystemPropertyResourceDefinition.VALUE.getName()).set(new ModelNode());
        } else {
            op.get(SystemPropertyResourceDefinition.VALUE.getName()).set(value);
        }
        if (boottime != null) {
            op.get(SystemPropertyResourceDefinition.BOOT_TIME.getName()).set(boottime.booleanValue());
        }
        return op;
    }

    public SystemPropertyAddHandler(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater, boolean useBoottime, AttributeDefinition[] attributes) {
        this.systemPropertyUpdater = systemPropertyUpdater;
        this.useBoottime = useBoottime;
        this.attributes = attributes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean reload;
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
        final String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        String value = operation.hasDefined(SystemPropertyResourceDefinition.VALUE.getName()) ? operation.get(SystemPropertyResourceDefinition.VALUE.getName()).asString() : null;
        boolean applyToRuntime = this.systemPropertyUpdater != null && this.systemPropertyUpdater.isRuntimeSystemPropertyUpdateAllowed(name, value, context.isBooting());
        boolean bl = reload = !applyToRuntime && context.getProcessType().isServer();
        if (applyToRuntime) {
            String setValue;
            String string = setValue = value != null ? SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(context, operation).asString() : null;
            if (setValue != null) {
                SecurityActions.setSystemProperty(name, setValue);
            } else {
                SecurityActions.clearSystemProperty(name);
            }
            if (this.systemPropertyUpdater != null) {
                this.systemPropertyUpdater.systemPropertyUpdated(name, setValue);
            }
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
                if (SystemPropertyAddHandler.this.systemPropertyUpdater != null) {
                    SecurityActions.clearSystemProperty(name);
                    if (SystemPropertyAddHandler.this.systemPropertyUpdater != null) {
                        SystemPropertyAddHandler.this.systemPropertyUpdater.systemPropertyUpdated(name, null);
                    }
                }
            }
        });
    }
}

