/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.server.operations.SecurityActions;
import org.jboss.dmr.ModelNode;

public class SystemPropertyValueWriteAttributeHandler
extends WriteAttributeHandlers.AttributeDefinitionValidatingHandler {
    private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;

    public SystemPropertyValueWriteAttributeHandler(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater, AttributeDefinition valueAttribute) {
        super(valueAttribute);
        this.systemPropertyUpdater = systemPropertyUpdater;
    }

    protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, final ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        boolean reload;
        final String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        final String value = newValue.isDefined() ? newValue.asString() : null;
        boolean applyToRuntime = this.systemPropertyUpdater != null && this.systemPropertyUpdater.isRuntimeSystemPropertyUpdateAllowed(name, value, context.isBooting());
        boolean bl = reload = !applyToRuntime && context.getProcessType().isServer();
        if (applyToRuntime) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String setValue = value == null ? null : context.resolveExpressions(newValue).asString();
                    final String oldValue = SecurityActions.getSystemProperty(name);
                    if (value != null) {
                        SecurityActions.setSystemProperty(name, setValue);
                    } else {
                        SecurityActions.clearSystemProperty(name);
                    }
                    if (SystemPropertyValueWriteAttributeHandler.this.systemPropertyUpdater != null) {
                        SystemPropertyValueWriteAttributeHandler.this.systemPropertyUpdater.systemPropertyUpdated(name, setValue);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            if (oldValue != null) {
                                SecurityActions.setSystemProperty(name, oldValue);
                            } else {
                                SecurityActions.clearSystemProperty(name);
                            }
                            if (SystemPropertyValueWriteAttributeHandler.this.systemPropertyUpdater != null) {
                                SystemPropertyValueWriteAttributeHandler.this.systemPropertyUpdater.systemPropertyUpdated(name, oldValue);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
            }
        });
    }
}

