/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.UnknownHostException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingAddHandler;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

class OutboundSocketBindingWriteHandler
extends WriteAttributeHandlers.AttributeDefinitionValidatingHandler {
    private final ParameterValidator resolvedValueValidator;
    private final boolean remoteDestination;

    OutboundSocketBindingWriteHandler(AttributeDefinition attribute, boolean remoteDestination) {
        super(attribute);
        this.resolvedValueValidator = attribute.getValidator() == null ? new ModelTypeValidator(attribute.getType()) : attribute.getValidator();
        this.remoteDestination = remoteDestination;
    }

    protected boolean requiresRestart() {
        return false;
    }

    protected void modelChanged(OperationContext context, ModelNode operation, final String attributeName, final ModelNode newValue, final ModelNode currentValue) throws OperationFailedException {
        boolean restartRequired = this.requiresRestart();
        boolean setReload = false;
        if (context.isNormalServer()) {
            if (restartRequired) {
                context.reloadRequired();
                setReload = true;
            } else {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        boolean bound;
                        ModelNode resolvedValue;
                        ModelNode modelNode = resolvedValue = newValue.isDefined() ? newValue.resolve() : newValue;
                        if (OutboundSocketBindingWriteHandler.this.resolvedValueValidator != null) {
                            OutboundSocketBindingWriteHandler.this.resolvedValueValidator.validateResolvedParameter("value", resolvedValue);
                        }
                        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
                        PathElement element = address.getLastElement();
                        final String bindingName = element.getValue();
                        final ModelNode bindingModel = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                        ServiceController controller = context.getServiceRegistry(true).getRequiredService(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{bindingName}));
                        final OutboundSocketBinding binding = controller.getState() == ServiceController.State.UP ? (OutboundSocketBinding)OutboundSocketBinding.class.cast(controller.getValue()) : null;
                        boolean bl = bound = binding != null && binding.isConnected();
                        if (binding == null) {
                            OutboundSocketBindingWriteHandler.this.handleBindingReinstall(context, bindingName, bindingModel);
                        } else {
                            context.reloadRequired();
                        }
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                if (binding == null) {
                                    OutboundSocketBindingWriteHandler.this.revertBindingReinstall(context, bindingName, bindingModel, attributeName, currentValue);
                                } else {
                                    context.revertReloadRequired();
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
        OperationContext.RollbackHandler rollbackHandler = setReload ? OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER : OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER;
        context.completeStep(rollbackHandler);
    }

    private void handleBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel) throws OperationFailedException {
        context.removeService(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{bindingName}));
        try {
            if (this.remoteDestination) {
                RemoteDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, bindingModel, bindingName);
            } else {
                LocalDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, bindingModel, bindingName);
            }
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    private void revertBindingReinstall(OperationContext context, String bindingName, ModelNode bindingModel, String attributeName, ModelNode previousValue) {
        context.removeService(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{bindingName}));
        ModelNode unresolvedConfig = bindingModel.clone();
        unresolvedConfig.get(attributeName).set(previousValue);
        try {
            if (this.remoteDestination) {
                RemoteDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, unresolvedConfig, bindingName);
            } else {
                LocalDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, unresolvedConfig, bindingName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

