/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.security;

import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.controller.resources.VaultResourceDefinition;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;

public class VaultAddHandler
extends AbstractAddStepHandler {
    private final AbstractVaultReader vaultReader;

    public VaultAddHandler(AbstractVaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : VaultResourceDefinition.ALL_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String vaultClass;
        ModelNode codeNode = VaultResourceDefinition.CODE.resolveModelAttribute(context, model);
        String string = vaultClass = codeNode.isDefined() ? codeNode.asString() : null;
        if (this.vaultReader != null) {
            HashMap<String, Object> vaultOptions = new HashMap<String, Object>();
            ModelNode optionsNode = VaultResourceDefinition.VAULT_OPTIONS.resolveModelAttribute(context, model);
            if (optionsNode.isDefined()) {
                for (Property prop : optionsNode.asPropertyList()) {
                    vaultOptions.put(prop.getName(), prop.getValue().asString());
                }
            }
            try {
                this.vaultReader.createVault(vaultClass, vaultOptions);
            }
            catch (VaultReaderException e) {
                throw ServerMessages.MESSAGES.cannotCreateVault(e, e);
            }
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        this.vaultReader.destroyVault();
    }
}

