/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.module.ExtendedModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.VersionedPutKeyValueCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.topology.CacheTopologyControlCommand;

@Scope(value=Scopes.GLOBAL)
public class RemoteCommandsFactory {
    EmbeddedCacheManager cacheManager;
    GlobalComponentRegistry registry;
    Map<Byte, ModuleCommandFactory> commandFactories;

    @Inject
    public void inject(EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, @ComponentName(value="org.infinispan.modules.command.factories") Map<Byte, ModuleCommandFactory> commandFactories) {
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.commandFactories = commandFactories;
    }

    public ReplicableCommand fromStream(byte id, Object[] parameters, byte type) {
        ReplicableCommand command;
        block16: {
            block15: {
                if (type != 0) break block15;
                switch (id) {
                    case 8: {
                        command = new PutKeyValueCommand();
                        break block16;
                    }
                    case 28: {
                        command = new VersionedPutKeyValueCommand();
                        break block16;
                    }
                    case 9: {
                        command = new PutMapCommand();
                        break block16;
                    }
                    case 10: {
                        command = new RemoveCommand();
                        break block16;
                    }
                    case 11: {
                        command = new ReplaceCommand();
                        break block16;
                    }
                    case 4: {
                        command = new GetKeyValueCommand();
                        break block16;
                    }
                    case 5: {
                        command = new ClearCommand();
                        break block16;
                    }
                    case 6: {
                        command = new InvalidateCommand();
                        break block16;
                    }
                    case 7: {
                        command = new InvalidateL1Command();
                        break block16;
                    }
                    case 19: {
                        command = new DistributedExecuteCommand();
                        break block16;
                    }
                    case 25: {
                        command = new ApplyDeltaCommand();
                        break block16;
                    }
                    case 17: {
                        command = new CacheTopologyControlCommand();
                        break block16;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ModuleCommandFactory mcf = this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }

    public CacheRpcCommand fromStream(byte id, Object[] parameters, byte type, String cacheName) {
        CacheRpcCommand command;
        block23: {
            block22: {
                if (type != 0) break block22;
                switch (id) {
                    case 3: {
                        command = new LockControlCommand(cacheName);
                        break block23;
                    }
                    case 12: {
                        command = new PrepareCommand(cacheName);
                        break block23;
                    }
                    case 26: {
                        command = new VersionedPrepareCommand(cacheName);
                        break block23;
                    }
                    case 14: {
                        command = new CommitCommand(cacheName);
                        break block23;
                    }
                    case 27: {
                        command = new VersionedCommitCommand(cacheName);
                        break block23;
                    }
                    case 13: {
                        command = new RollbackCommand(cacheName);
                        break block23;
                    }
                    case 2: {
                        command = new MultipleRpcCommand(cacheName);
                        break block23;
                    }
                    case 1: {
                        command = new SingleRpcCommand(cacheName);
                        break block23;
                    }
                    case 16: {
                        command = new ClusteredGetCommand(cacheName);
                        break block23;
                    }
                    case 15: {
                        command = new StateRequestCommand(cacheName);
                        break block23;
                    }
                    case 20: {
                        command = new StateResponseCommand(cacheName);
                        break block23;
                    }
                    case 18: {
                        command = new RemoveCacheCommand(cacheName, this.cacheManager, this.registry, this.registry.getNamedComponentRegistry(cacheName).getComponent(CacheLoaderManager.class));
                        break block23;
                    }
                    case 22: {
                        command = new TxCompletionNotificationCommand(cacheName);
                        break block23;
                    }
                    case 21: {
                        command = new GetInDoubtTransactionsCommand(cacheName);
                        break block23;
                    }
                    case 30: {
                        command = new MapCombineCommand(cacheName);
                        break block23;
                    }
                    case 31: {
                        command = new ReduceCommand(cacheName);
                        break block23;
                    }
                    case 23: {
                        command = new GetInDoubtTxInfoCommand(cacheName);
                        break block23;
                    }
                    case 24: {
                        command = new CompleteTransactionCommand(cacheName);
                        break block23;
                    }
                    case 29: {
                        command = new CreateCacheCommand(cacheName);
                        break block23;
                    }
                    default: {
                        throw new CacheException("Unknown command id " + id + "!");
                    }
                }
            }
            ExtendedModuleCommandFactory mcf = (ExtendedModuleCommandFactory)this.commandFactories.get(id);
            if (mcf != null) {
                return mcf.fromStream(id, parameters, cacheName);
            }
            throw new CacheException("Unknown command id " + id + "!");
        }
        command.setParameters(id, parameters);
        return command;
    }
}

