/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.spi.DistributedTaskLifecycleService;
import org.infinispan.lifecycle.ComponentStatus;

public class DistributedExecuteCommand<V>
implements VisitableCommand {
    public static final int COMMAND_ID = 19;
    private static final long serialVersionUID = -7828117401763700385L;
    private Cache<Object, Object> cache;
    private Set<Object> keys;
    private Callable<V> callable;

    public DistributedExecuteCommand(Collection<Object> inputKeys, Callable<V> callable) {
        this.keys = inputKeys == null || inputKeys.isEmpty() ? Collections.emptySet() : new HashSet<Object>(inputKeys);
        this.callable = callable;
    }

    public DistributedExecuteCommand() {
        this(null, null);
    }

    public void init(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitDistributedExecuteCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext context) throws Throwable {
        DistributedTaskLifecycleService taskLifecycleService = DistributedTaskLifecycleService.getInstance();
        Callable<V> callable = this.getCallable();
        Object result = null;
        try {
            taskLifecycleService.onPreExecute(callable, this.cache);
            if (callable instanceof DistributedCallable) {
                DistributedCallable dc = (DistributedCallable)callable;
                dc.setEnvironment(this.cache, this.keys);
            }
            result = callable.call();
        }
        finally {
            taskLifecycleService.onPostExecute(callable);
        }
        return result;
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public Set<Object> getKeys() {
        return this.keys;
    }

    public boolean hasKeys() {
        return this.keys.isEmpty();
    }

    @Override
    public byte getCommandId() {
        return 19;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.callable};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 19) {
            throw new IllegalStateException("Invalid method id");
        }
        int i = 0;
        this.keys = (Set)args[i++];
        this.callable = (Callable)args[i++];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : ((Object)this.keys).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributedExecuteCommand)) {
            return false;
        }
        DistributedExecuteCommand other = (DistributedExecuteCommand)obj;
        return !(this.keys == null ? other.keys != null : !((Object)this.keys).equals(other.keys));
    }

    public String toString() {
        return "DistributedExecuteCommand{cache=" + this.cache + ", keys=" + this.keys + ", callable=" + this.callable + '}';
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

