/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class ReplaceCommand
extends AbstractDataWriteCommand {
    public static final byte COMMAND_ID = 11;
    Object oldValue;
    Object newValue;
    long lifespanMillis = -1L;
    long maxIdleTimeMillis = -1L;
    CacheNotifier notifier;
    boolean successful = true;

    public ReplaceCommand() {
    }

    public ReplaceCommand(Object key, Object oldValue, Object newValue, CacheNotifier notifier, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        super(key, flags);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.notifier = notifier;
        this.lifespanMillis = lifespanMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReplaceCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e != null) {
            if (ctx.isOriginLocal()) {
                if (e.isNull() || e.getValue() == null) {
                    return this.returnValue(null, false, ctx);
                }
                if (this.oldValue == null || this.oldValue.equals(e.getValue())) {
                    Object old = e.setValue(this.newValue);
                    e.setLifespan(this.lifespanMillis);
                    e.setMaxIdle(this.maxIdleTimeMillis);
                    return this.returnValue(old, true, ctx);
                }
                return this.returnValue(null, false, ctx);
            }
            Object old = e.setValue(this.newValue);
            e.setLifespan(this.lifespanMillis);
            e.setMaxIdle(this.maxIdleTimeMillis);
            return this.returnValue(old, true, ctx);
        }
        return this.returnValue(null, false, ctx);
    }

    private Object returnValue(Object beingReplaced, boolean successful, InvocationContext ctx) {
        Object previousValue;
        this.successful = successful;
        Object object = previousValue = this.oldValue == null ? beingReplaced : this.oldValue;
        if (successful) {
            this.notifier.notifyCacheEntryModified(this.key, previousValue, true, ctx);
            this.notifier.notifyCacheEntryModified(this.key, this.newValue, false, ctx);
        }
        if (this.oldValue == null) {
            return beingReplaced;
        }
        return successful;
    }

    @Override
    public byte getCommandId() {
        return 11;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.oldValue, this.newValue, this.lifespanMillis, this.maxIdleTimeMillis, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 11) {
            throw new IllegalArgumentException("Invalid method name");
        }
        this.key = parameters[0];
        this.oldValue = parameters[1];
        this.newValue = parameters[2];
        this.lifespanMillis = (Long)parameters[3];
        this.maxIdleTimeMillis = (Long)parameters[4];
        this.flags = (Set)parameters[5];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplaceCommand that = (ReplaceCommand)o;
        if (this.lifespanMillis != that.lifespanMillis) {
            return false;
        }
        if (this.maxIdleTimeMillis != that.maxIdleTimeMillis) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (int)(this.lifespanMillis ^ this.lifespanMillis >>> 32);
        result = 31 * result + (int)(this.maxIdleTimeMillis ^ this.maxIdleTimeMillis >>> 32);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    public long getLifespanMillis() {
        return this.lifespanMillis;
    }

    public long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public String toString() {
        return "ReplaceCommand{oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", flags=" + this.flags + ", successful=" + this.successful + '}';
    }
}

