/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;

public class SitesConfiguration {
    private final List<BackupConfiguration> allBackups;
    private final List<BackupConfiguration> inUseBackups;
    private final BackupForConfiguration backupFor;
    private final boolean disableBackups;
    private final Set<String> inUseBackupSites;

    public SitesConfiguration(List<BackupConfiguration> backups, BackupForConfiguration backupFor, boolean disableBackups, Set<String> backupSites) {
        this.allBackups = Collections.unmodifiableList(new ArrayList<BackupConfiguration>(backups));
        this.backupFor = backupFor;
        this.disableBackups = disableBackups;
        this.inUseBackupSites = Collections.unmodifiableSet(new HashSet<String>(backupSites));
        ArrayList<BackupConfiguration> filtered = new ArrayList<BackupConfiguration>(backupSites.size());
        for (BackupConfiguration backupConfiguration : backups) {
            if (!backupSites.contains(backupConfiguration.site())) continue;
            filtered.add(backupConfiguration);
        }
        this.inUseBackups = Collections.unmodifiableList(filtered);
    }

    public boolean disableBackups() {
        return this.disableBackups;
    }

    public List<BackupConfiguration> allBackups() {
        return this.allBackups;
    }

    public List<BackupConfiguration> inUseBackups() {
        return this.inUseBackups;
    }

    public Set<String> inUseBackupSites() {
        return this.inUseBackupSites;
    }

    public BackupForConfiguration backupFor() {
        return this.backupFor;
    }

    public BackupFailurePolicy getFailurePolicy(String siteName) {
        for (BackupConfiguration bc : this.allBackups) {
            if (!bc.site().equals(siteName)) continue;
            return bc.backupFailurePolicy();
        }
        throw new IllegalStateException("There must be a site configured for " + siteName);
    }

    public boolean hasInUseBackup(String siteName) {
        for (BackupConfiguration bc : this.inUseBackups) {
            if (!bc.site().equals(siteName)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SitesConfiguration)) {
            return false;
        }
        SitesConfiguration that = (SitesConfiguration)o;
        if (this.disableBackups != that.disableBackups) {
            return false;
        }
        if (this.backupFor != null ? !this.backupFor.equals(that.backupFor) : that.backupFor != null) {
            return false;
        }
        if (this.inUseBackupSites != null ? !((Object)this.inUseBackupSites).equals(that.inUseBackupSites) : that.inUseBackupSites != null) {
            return false;
        }
        return !(this.allBackups != null ? !((Object)this.allBackups).equals(that.allBackups) : that.allBackups != null);
    }

    public int hashCode() {
        int result = this.allBackups != null ? ((Object)this.allBackups).hashCode() : 0;
        result = 31 * result + (this.backupFor != null ? this.backupFor.hashCode() : 0);
        result = 31 * result + (this.disableBackups ? 1 : 0);
        result = 31 * result + (this.inUseBackupSites != null ? ((Object)this.inUseBackupSites).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SitesConfiguration{allBackups=" + this.allBackups + ", backupFor=" + this.backupFor + ", disableBackups=" + this.disableBackups + ", inUseBackupSites=" + this.inUseBackupSites + '}';
    }
}

