/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.context.AbstractInvocationContextContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;

public class TransactionalInvocationContextContainer
extends AbstractInvocationContextContainer {
    private TransactionManager tm;
    private TransactionTable transactionTable;

    @Inject
    public void init(TransactionManager tm, TransactionTable transactionTable) {
        this.tm = tm;
        this.transactionTable = transactionTable;
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        return this.newNonTxInvocationContext(true);
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        SingleKeyNonTxInvocationContext ctx = new SingleKeyNonTxInvocationContext(true);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        Transaction runningTx = this.getRunningTx();
        if (runningTx == null && !isWrite) {
            if (keyCount == 1) {
                return this.createSingleKeyNonTxInvocationContext();
            }
            return this.newNonTxInvocationContext(true);
        }
        return this.createInvocationContext(runningTx);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx) {
        if (tx == null) {
            throw new IllegalStateException("This is a tx cache!");
        }
        LocalTxInvocationContext localContext = new LocalTxInvocationContext();
        LocalTransaction localTransaction = this.transactionTable.getLocalTransaction(tx);
        localContext.setLocalTransaction(localTransaction);
        localContext.setTransaction(tx);
        this.ctxHolder.set(localContext);
        return localContext;
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext() {
        LocalTxInvocationContext ctx = new LocalTxInvocationContext();
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        RemoteTxInvocationContext ctx = new RemoteTxInvocationContext();
        ctx.setOrigin(origin);
        ctx.setRemoteTransaction(tx);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        NonTxInvocationContext nonTxInvocationContext = this.newNonTxInvocationContext(false);
        nonTxInvocationContext.setOrigin(origin);
        return nonTxInvocationContext;
    }

    private Transaction getRunningTx() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
    }

    protected final NonTxInvocationContext newNonTxInvocationContext(boolean local) {
        NonTxInvocationContext ctx = new NonTxInvocationContext();
        ctx.setOriginLocal(local);
        this.ctxHolder.set(ctx);
        return ctx;
    }
}

