/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.AbstractInProcessFuture;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceTask<KIn, VIn, KOut, VOut> {
    private static final Log log = LogFactory.getLog(MapReduceTask.class);
    public static final String DEFAULT_TMP_CACHE_CONFIGURATION_NAME = "__tmpMapReduce";
    protected Mapper<KIn, VIn, KOut, VOut> mapper;
    protected Reducer<KOut, VOut> reducer;
    protected Reducer<KOut, VOut> combiner;
    protected final boolean distributeReducePhase;
    protected final boolean useIntermediateSharedCache;
    protected final Collection<KIn> keys;
    protected final AdvancedCache<KIn, VIn> cache;
    protected final Marshaller marshaller;
    protected final MapReduceManager mapReduceManager;
    protected final UUID taskId;

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode) {
        this(masterCacheNode, false, false);
    }

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode, boolean distributeReducePhase) {
        this(masterCacheNode, distributeReducePhase, true);
    }

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode, boolean distributeReducePhase, boolean useIntermediateSharedCache) {
        if (masterCacheNode == null) {
            throw new IllegalArgumentException("Can not use null cache for MapReduceTask");
        }
        this.ensureProperCacheState(masterCacheNode.getAdvancedCache());
        this.cache = masterCacheNode.getAdvancedCache();
        this.keys = new LinkedList<KIn>();
        this.marshaller = this.cache.getComponentRegistry().getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.mapReduceManager = this.cache.getComponentRegistry().getComponent(MapReduceManager.class);
        this.taskId = UUID.randomUUID();
        this.distributeReducePhase = distributeReducePhase;
        this.useIntermediateSharedCache = useIntermediateSharedCache;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> onKeys(KIn ... input) {
        Collections.addAll(this.keys, input);
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> mappedWith(Mapper<KIn, VIn, KOut, VOut> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("A valid reference of Mapper is needed");
        }
        this.mapper = mapper;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> reducedWith(Reducer<KOut, VOut> reducer) {
        if (reducer == null) {
            throw new IllegalArgumentException("A valid reference of Reducer is needed");
        }
        this.reducer = reducer;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> combinedWith(Reducer<KOut, VOut> combiner) {
        if (combiner == null) {
            throw new IllegalArgumentException("A valid reference of Reducer/Combiner is needed");
        }
        this.combiner = combiner;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<KOut, VOut> execute() throws CacheException {
        if (this.mapper == null) {
            throw new NullPointerException("A valid reference of Mapper is not set " + this.mapper);
        }
        if (this.reducer == null) {
            throw new NullPointerException("A valid reference of Reducer is not set " + this.reducer);
        }
        if (this.distributeReducePhase()) {
            boolean useCompositeKeys = this.useIntermediateSharedCache();
            String intermediateCacheName = DEFAULT_TMP_CACHE_CONFIGURATION_NAME;
            if (this.useIntermediatePerTaskCache()) {
                intermediateCacheName = this.taskId.toString();
            }
            try {
                this.executeTaskInit(intermediateCacheName);
                Set<KOut> allMapPhasesResponses = this.executeMapPhase(useCompositeKeys);
                Map<KOut, VOut> map = this.executeReducePhase(allMapPhasesResponses, useCompositeKeys);
                return map;
            }
            finally {
                if (this.useIntermediatePerTaskCache()) {
                    EmbeddedCacheManager cm = this.cache.getCacheManager();
                    cm.getCache(intermediateCacheName).clear();
                    cm.removeCache(intermediateCacheName);
                }
            }
        }
        return this.executeMapPhaseWithLocalReduction();
    }

    protected boolean distributeReducePhase() {
        return this.distributeReducePhase;
    }

    protected boolean useIntermediateSharedCache() {
        return this.useIntermediateSharedCache;
    }

    protected boolean useIntermediatePerTaskCache() {
        return !this.useIntermediateSharedCache();
    }

    protected void executeTaskInit(String tmpCacheName) {
        RpcManager rpc = this.cache.getRpcManager();
        CommandsFactory factory = this.cache.getComponentRegistry().getComponent(CommandsFactory.class);
        CreateCacheCommand ccc = factory.buildCreateCacheCommand(tmpCacheName, DEFAULT_TMP_CACHE_CONFIGURATION_NAME);
        try {
            log.debugf("Invoking %s across entire cluster ", ccc);
            Map<Address, Response> map = rpc.invokeRemotely(null, (ReplicableCommand)ccc, true, false);
            ccc.init(this.cache.getCacheManager());
            ccc.perform(null);
            log.debugf("Invoked %s across entire cluster, results are %s", ccc, map);
        }
        catch (Throwable e) {
            throw new CacheException("Could not initialize temporary caches for MapReduce task on remote nodes ", e);
        }
    }

    protected Set<KOut> executeMapPhase(boolean useCompositeKeys) {
        RpcManager rpc = this.cache.getRpcManager();
        MapCombineCommand<KIn, VIn, KOut, VOut> cmd = null;
        HashMap<Address, Response> mapPhaseResponses = new HashMap<Address, Response>();
        HashSet<Object> mapPhasesResult = new HashSet<Object>();
        ArrayList<MapReduceFuture> futures = new ArrayList<MapReduceFuture>();
        if (this.inputTaskKeysEmpty()) {
            cmd = this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, null, true, useCompositeKeys);
            Map<Address, Response> map = this.invokeEverywhere(cmd);
            mapPhaseResponses.putAll(map);
            Set<KOut> localResult = this.invokeMapCombineLocally(cmd);
            mapPhasesResult.addAll(localResult);
        } else {
            Map<Address, List<KIn>> keysToNodes = this.mapKeysToNodes(this.keys);
            for (Map.Entry<Address, List<KIn>> e : keysToNodes.entrySet()) {
                Address address = e.getKey();
                List<KIn> keys = e.getValue();
                if (address.equals(rpc.getAddress())) {
                    cmd = this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), keys, true, useCompositeKeys);
                    Set<KOut> localResult = this.invokeMapCombineLocally(cmd);
                    mapPhasesResult.addAll(localResult);
                    continue;
                }
                cmd = this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, keys, true, useCompositeKeys);
                MapReduceFuture future = this.invokeRemotely(cmd, address);
                futures.add(future);
            }
            Map<Address, Response> resultsFromFutures = this.extractResultsFromFutures(futures);
            mapPhaseResponses.putAll(resultsFromFutures);
        }
        Set responses = this.extractSetFromResponses(mapPhaseResponses);
        mapPhasesResult.addAll(responses);
        return mapPhasesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KOut, VOut> executeMapPhaseWithLocalReduction() {
        RpcManager rpc = this.cache.getRpcManager();
        MapCombineCommand<KIn, VIn, KOut, VOut> cmd = null;
        HashMap<Address, Response> mapPhaseResponses = new HashMap<Address, Response>();
        HashMap<KOut, List<VOut>> mapPhasesResult = new HashMap<KOut, List<VOut>>();
        ArrayList<MapReduceFuture> futures = new ArrayList<MapReduceFuture>();
        if (this.inputTaskKeysEmpty()) {
            cmd = this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, null, false, false);
            Map<Address, Response> map = this.invokeEverywhere(cmd);
            mapPhaseResponses.putAll(map);
            Map<KOut, List<VOut>> localResult = this.invokeMapCombineLocallyForLocalReduction(cmd);
            mapPhasesResult.putAll(localResult);
        } else {
            Map<Address, List<KIn>> keysToNodes = this.mapKeysToNodes(this.keys);
            for (Map.Entry<Address, List<KIn>> entry : keysToNodes.entrySet()) {
                Address address = entry.getKey();
                List<KIn> keys = entry.getValue();
                if (address.equals(rpc.getAddress())) {
                    cmd = this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), keys, false, false);
                    Map<KOut, List<VOut>> localResult = this.invokeMapCombineLocallyForLocalReduction(cmd);
                    mapPhasesResult.putAll(localResult);
                    continue;
                }
                cmd = this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, keys, false, false);
                MapReduceFuture future = this.invokeRemotely(cmd, address);
                futures.add(future);
            }
            Map<Address, Response> resultsFromFutures = this.extractResultsFromFutures(futures);
            mapPhaseResponses.putAll(resultsFromFutures);
        }
        HashMap reducedResult = new HashMap();
        for (Map.Entry<Address, List<Object>> entry : mapPhaseResponses.entrySet()) {
            this.mergeResponse(mapPhasesResult, entry);
        }
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        log.tracef("For m/r task %s invoking %s locally", this.taskId, this.reducer);
        try {
            taskLifecycleService.onPreExecute(this.reducer, this.cache);
            for (Map.Entry e : mapPhasesResult.entrySet()) {
                reducedResult.put(e.getKey(), this.reducer.reduce(e.getKey(), ((List)e.getValue()).iterator()));
            }
        }
        finally {
            taskLifecycleService.onPostExecute(this.reducer);
        }
        return reducedResult;
    }

    protected Map<KOut, VOut> executeReducePhase(Set<KOut> allMapPhasesResponses, boolean emitCompositeIntermediateKeys) {
        RpcManager rpc = this.cache.getRpcManager();
        String destinationCache = null;
        destinationCache = emitCompositeIntermediateKeys ? DEFAULT_TMP_CACHE_CONFIGURATION_NAME : this.taskId.toString();
        Cache<Object, Object> dstCache = this.cache.getCacheManager().getCache(destinationCache);
        Map<Address, List<KOut>> keysToNodes = this.mapKeysToNodes(dstCache.getAdvancedCache().getDistributionManager(), allMapPhasesResponses, emitCompositeIntermediateKeys);
        HashMap<Object, Object> reduceResult = new HashMap<Object, Object>();
        ArrayList<MapReduceFuture> reduceFutures = new ArrayList<MapReduceFuture>();
        ReduceCommand<KOut, VOut> reduceCommand = null;
        for (Map.Entry<Address, List<KOut>> e : keysToNodes.entrySet()) {
            Address address = e.getKey();
            List<KOut> keys = e.getValue();
            if (address.equals(rpc.getAddress())) {
                reduceCommand = this.buildReduceCommand(this.taskId.toString(), destinationCache, this.clone(this.reducer), keys, emitCompositeIntermediateKeys);
                Map<KOut, VOut> reduceLocally = this.invokeReduceLocally(reduceCommand, dstCache);
                reduceResult.putAll(reduceLocally);
                continue;
            }
            reduceCommand = this.buildReduceCommand(this.taskId.toString(), destinationCache, this.reducer, keys, emitCompositeIntermediateKeys);
            MapReduceFuture future = this.invokeRemotely(reduceCommand, address);
            reduceFutures.add(future);
        }
        Map<Address, Response> reducePhaseResults = this.extractResultsFromFutures(reduceFutures);
        Map responses = this.extractMapFromResponses(reducePhaseResults);
        reduceResult.putAll(responses);
        return reduceResult;
    }

    private <T> Set<T> extractSetFromResponses(Map<Address, Response> responses) {
        HashSet result = new HashSet();
        for (Map.Entry<Address, Response> e : responses.entrySet()) {
            Response rsp = e.getValue();
            if (rsp.isSuccessful() && rsp.isValid()) {
                Set mapResponse = (Set)((SuccessfulResponse)rsp).getResponseValue();
                result.addAll(mapResponse);
                continue;
            }
            if (rsp instanceof ExceptionResponse) {
                throw new CacheException("Map phase of MapReduce task on remote node " + e.getKey() + " threw Exception", ((ExceptionResponse)rsp).getException());
            }
            throw new CacheException("Map phase of MapReduce task on remote node " + e.getKey() + " failed ");
        }
        return result;
    }

    private <K, V> Map<K, V> extractMapFromResponses(Map<Address, Response> responses) {
        HashMap result = new HashMap();
        for (Map.Entry<Address, Response> e : responses.entrySet()) {
            Response rsp = e.getValue();
            if (rsp.isSuccessful() && rsp.isValid()) {
                Map r = (Map)((SuccessfulResponse)rsp).getResponseValue();
                result.putAll(r);
                continue;
            }
            if (rsp instanceof ExceptionResponse) {
                throw new CacheException("Reduce phase of MapReduce task on remote node " + e.getKey() + " threw Exception", ((ExceptionResponse)rsp).getException());
            }
            throw new CacheException("Reduce phase of MapReduce task on remote node " + e.getKey() + " failed ");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> void mergeResponse(Map<K, List<V>> result, Map.Entry<Address, Response> response) {
        Response rsp = response.getValue();
        if (rsp.isSuccessful() && rsp.isValid()) {
            Map r = (Map)((SuccessfulResponse)rsp).getResponseValue();
            for (Map.Entry entry : r.entrySet()) {
                Map map = result;
                synchronized (map) {
                    List<V> list = result.get(entry.getKey());
                    if (list != null) {
                        list.addAll((Collection)entry.getValue());
                    } else {
                        list = new ArrayList<V>();
                        list.addAll((Collection)entry.getValue());
                    }
                    result.put(entry.getKey(), list);
                }
            }
        } else {
            if (rsp instanceof ExceptionResponse) {
                throw new CacheException("Reduce phase of MapReduce task on remote node " + response.getKey() + " threw Exception", ((ExceptionResponse)rsp).getException());
            }
            throw new CacheException("Reduce phase of MapReduce task on remote node " + response.getKey() + " failed ");
        }
    }

    private Map<Address, Response> invokeEverywhere(MapCombineCommand<KIn, VIn, KOut, VOut> cmd) {
        RpcManager rpc = this.cache.getRpcManager();
        Map<Address, Response> map = null;
        try {
            log.debugf("Invoking %s across entire cluster ", cmd);
            map = rpc.invokeRemotely(null, cmd, true, false);
            log.debugf("Invoked %s across entire cluster, results are %s", cmd, map);
        }
        catch (Throwable e) {
            throw new CacheException("Could not invoke map phase of MapReduce task on remote nodes ", e);
        }
        return map;
    }

    private Map<Address, Response> extractResultsFromFutures(List<MapReduceFuture> futures) {
        HashMap<Address, Response> results = new HashMap<Address, Response>();
        for (MapReduceFuture future : futures) {
            try {
                Map resultReduced = (Map)future.get();
                results.putAll(resultReduced);
                log.debugf("Received result from future %s", resultReduced);
            }
            catch (Exception e1) {
                throw new CacheException("Could not retrieve MapReduceTask result from remote node ", e1);
            }
        }
        return results;
    }

    private MapReduceFuture invokeRemotely(CacheRpcCommand cmd, Address address) {
        RpcManager rpc = this.cache.getRpcManager();
        MapReduceFuture future = null;
        try {
            log.debugf("Invoking %s on %s", cmd, address);
            future = new MapReduceFuture();
            rpc.invokeRemotelyInFuture(Collections.singleton(address), cmd, future);
            log.debugf("Invoked %s on %s ", cmd, address);
        }
        catch (Exception ex) {
            throw new CacheException("Could not invoke map phase of MapReduceTask on remote node " + address, ex);
        }
        return future;
    }

    private MapCombineCommand<KIn, VIn, KOut, VOut> buildMapCombineCommand(String taskId, Mapper<KIn, VIn, KOut, VOut> m, Reducer<KOut, VOut> r, Collection<KIn> keys, boolean reducePhaseDistributed, boolean emitCompositeIntermediateKeys) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        MapCombineCommand<KIn, VIn, KOut, VOut> c = factory.buildMapCombineCommand(taskId, m, r, keys);
        c.setReducePhaseDistributed(reducePhaseDistributed);
        c.setEmitCompositeIntermediateKeys(emitCompositeIntermediateKeys);
        return c;
    }

    private ReduceCommand<KOut, VOut> buildReduceCommand(String taskId, String destinationCache, Reducer<KOut, VOut> r, Collection<KOut> keys, boolean emitCompositeIntermediateKeys) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        ReduceCommand<KOut, VOut> reduceCommand = factory.buildReduceCommand(taskId, destinationCache, r, keys);
        reduceCommand.setEmitCompositeIntermediateKeys(emitCompositeIntermediateKeys);
        return reduceCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KOut, List<VOut>> invokeMapCombineLocallyForLocalReduction(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) {
        MapReduceManager mapReduceManager = this.cache.getComponentRegistry().getComponent(MapReduceManager.class);
        log.debugf("Invoking %s locally", mcc);
        try {
            mcc.init(mapReduceManager);
            Map<KOut, List<VOut>> map = mapReduceManager.mapAndCombineForLocalReduction(mcc);
            return map;
        }
        finally {
            log.debugf("Invoked %s locally", mcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<KOut> invokeMapCombineLocally(MapCombineCommand<KIn, VIn, KOut, VOut> mcc) {
        MapReduceManager mapReduceManager = this.cache.getComponentRegistry().getComponent(MapReduceManager.class);
        log.debugf("Invoking %s locally", mcc);
        try {
            mcc.init(mapReduceManager);
            Set<KOut> set = mapReduceManager.mapAndCombineForDistributedReduction(mcc);
            return set;
        }
        finally {
            log.debugf("Invoked %s locally", mcc);
        }
    }

    private Map<KOut, VOut> invokeReduceLocally(ReduceCommand<KOut, VOut> reduceCommand, Cache<Object, Object> dstCache) {
        MapReduceManager mrManager = dstCache.getAdvancedCache().getComponentRegistry().getComponent(MapReduceManager.class);
        reduceCommand.init(mrManager);
        Map<KOut, VOut> localReduceResult = null;
        try {
            log.debugf("Invoking %s locally ", reduceCommand);
            localReduceResult = mrManager.reduce(reduceCommand);
            log.debugf("Invoked %s locally", reduceCommand);
        }
        catch (Throwable e1) {
            throw new CacheException("Could not invoke MapReduce task locally ", e1);
        }
        return localReduceResult;
    }

    public Future<Map<KOut, VOut>> executeAsynchronously() {
        final Callable call = new Callable<Map<KOut, VOut>>(){

            @Override
            public Map<KOut, VOut> call() throws Exception {
                return MapReduceTask.this.execute();
            }
        };
        return new AbstractInProcessFuture<Map<KOut, VOut>>(){

            @Override
            public Map<KOut, VOut> get() throws InterruptedException, ExecutionException {
                try {
                    return (Map)call.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    public <R> R execute(Collator<KOut, VOut, R> collator) {
        Map<KOut, VOut> execute = this.execute();
        return collator.collate(execute);
    }

    public <R> Future<R> executeAsynchronously(final Collator<KOut, VOut, R> collator) {
        final Callable call = new Callable<R>(){

            @Override
            public R call() throws Exception {
                return MapReduceTask.this.execute(collator);
            }
        };
        return new AbstractInProcessFuture<R>(){

            @Override
            public R get() throws InterruptedException, ExecutionException {
                try {
                    return call.call();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }
        };
    }

    protected void aggregateReducedResult(Map<KOut, List<VOut>> finalReduced, Map<KOut, VOut> mapReceived) {
        for (Map.Entry<KOut, VOut> entry : mapReceived.entrySet()) {
            List<Object> l;
            if (!finalReduced.containsKey(entry.getKey())) {
                l = new LinkedList();
                finalReduced.put(entry.getKey(), l);
            } else {
                l = finalReduced.get(entry.getKey());
            }
            l.add(entry.getValue());
        }
    }

    protected <T> Map<Address, List<T>> mapKeysToNodes(DistributionManager dm, Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        return this.mapReduceManager.mapKeysToNodes(dm, this.taskId.toString(), keysToMap, useIntermediateCompositeKey);
    }

    protected <T> Map<Address, List<T>> mapKeysToNodes(Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        return this.mapReduceManager.mapKeysToNodes(this.cache.getDistributionManager(), this.taskId.toString(), keysToMap, useIntermediateCompositeKey);
    }

    protected <T> Map<Address, List<T>> mapKeysToNodes(Collection<T> keysToMap) {
        return this.mapKeysToNodes(keysToMap, false);
    }

    protected Mapper<KIn, VIn, KOut, VOut> clone(Mapper<KIn, VIn, KOut, VOut> mapper) {
        return Util.cloneWithMarshaller(this.marshaller, mapper);
    }

    protected Reducer<KOut, VOut> clone(Reducer<KOut, VOut> reducer) {
        return Util.cloneWithMarshaller(this.marshaller, reducer);
    }

    private void ensureProperCacheState(AdvancedCache<KIn, VIn> cache) throws NullPointerException, IllegalStateException {
        if (cache.getRpcManager() == null) {
            throw new IllegalStateException("Can not use non-clustered cache for MapReduceTask");
        }
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            throw new IllegalStateException("Invalid cache state " + (Object)((Object)cache.getStatus()));
        }
        if (cache.getDistributionManager() == null) {
            throw new IllegalStateException("Cache mode should be DIST, rather than " + cache.getCacheConfiguration().clustering().cacheModeString());
        }
    }

    protected boolean inputTaskKeysEmpty() {
        return this.keys == null || this.keys.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapReduceTask)) {
            return false;
        }
        MapReduceTask other = (MapReduceTask)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    public String toString() {
        return "MapReduceTask [mapper=" + this.mapper + ", reducer=" + this.reducer + ", combiner=" + this.combiner + ", keys=" + this.keys + ", taskId=" + this.taskId + "]";
    }

    private static class MapReduceFuture
    implements NotifyingNotifiableFuture<Object> {
        private Future<Object> futureResult;

        private MapReduceFuture() {
        }

        @Override
        public NotifyingFuture<Object> attachListener(FutureListener<Object> listener) {
            return this;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return this.futureResult.get();
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.futureResult.get(timeout, unit);
        }

        @Override
        public void notifyDone() {
        }

        @Override
        public void setNetworkFuture(Future<Object> future) {
            this.futureResult = future;
        }
    }
}

