/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;

public class ReplicatedConsistentHash
implements ConsistentHash {
    private final List<Address> members;
    private final Set<Integer> theSegment = Collections.singleton(0);

    public ReplicatedConsistentHash(List<Address> members) {
        this.members = new ArrayList<Address>(members);
    }

    @Override
    public int getNumSegments() {
        return 1;
    }

    @Override
    public int getNumOwners() {
        return this.members.size();
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public Hash getHashFunction() {
        return null;
    }

    @Override
    public int getSegment(Object key) {
        return 0;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        return this.members;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(0);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        return this.theSegment;
    }

    @Override
    public Address locatePrimaryOwner(Object key) {
        return this.members.get(0);
    }

    @Override
    public List<Address> locateOwners(Object key) {
        return this.members;
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        return new HashSet<Address>(this.members);
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        return true;
    }

    public String toString() {
        return "ReplicatedConsistentHash{members=" + this.members + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<ReplicatedConsistentHash> {
        @Override
        public void writeObject(ObjectOutput output, ReplicatedConsistentHash ch) throws IOException {
            output.writeObject(ch.members);
        }

        @Override
        public ReplicatedConsistentHash readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            List members = (List)unmarshaller.readObject();
            return new ReplicatedConsistentHash(members);
        }

        @Override
        public Integer getId() {
            return 52;
        }

        @Override
        public Set<Class<? extends ReplicatedConsistentHash>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHash.class);
        }
    }
}

