/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.ReplicatedConsistentHash;
import org.infinispan.remoting.transport.Address;

public class ReplicatedConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash>,
Serializable {
    @Override
    public ReplicatedConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        return new ReplicatedConsistentHash(members);
    }

    @Override
    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers) {
        if (((Object)newMembers).equals(baseCH.getMembers())) {
            return baseCH;
        }
        return new ReplicatedConsistentHash(newMembers);
    }

    @Override
    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        return baseCH;
    }

    @Override
    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        HashSet<Address> membersUnion = new HashSet<Address>(ch1.getMembers().size() + ch2.getMembers().size());
        membersUnion.addAll(ch1.getMembers());
        membersUnion.addAll(ch2.getMembers());
        return new ReplicatedConsistentHash(new ArrayList<Address>(membersUnion));
    }
}

