/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;

public class SyncConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash> {
    /*
     * WARNING - void declaration
     */
    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        int segment;
        int i;
        int initSegment;
        int numMembers = members.size();
        int actualNumOwners = Math.min(numOwners, numMembers);
        List<Address> sortedMembers = this.sort(members);
        int segmentSize = (int)Math.ceil(2.147483647E9 / (double)numSegments);
        TreeMap<Integer, Address> primarySegments = new TreeMap<Integer, Address>();
        int numVirtualNodes = (int)Math.sqrt(numSegments);
        for (int virtualNode = 0; virtualNode < numVirtualNodes; ++virtualNode) {
            block1: for (Address address : sortedMembers) {
                int virtualNodeHash = 31 * address.hashCode() + virtualNode;
                int normalizedHash = hashFunction.hash(virtualNodeHash) & Integer.MAX_VALUE;
                initSegment = normalizedHash / segmentSize;
                for (i = 0; i < numSegments; ++i) {
                    segment = (initSegment + i) % numSegments;
                    if (primarySegments.containsKey(segment)) continue;
                    primarySegments.put(segment, address);
                    continue block1;
                }
            }
        }
        List[] segmentOwners = new List[numSegments];
        if (numSegments >= numMembers) {
            for (int i2 = 0; i2 < numSegments; ++i2) {
                ArrayList<Address> arrayList = new ArrayList<Address>(actualNumOwners);
                for (Address a : primarySegments.tailMap(i2).values()) {
                    if (arrayList.size() >= actualNumOwners) break;
                    if (arrayList.contains(a)) continue;
                    arrayList.add(a);
                }
                for (Address a : primarySegments.headMap(i2).values()) {
                    if (arrayList.size() >= actualNumOwners) break;
                    if (arrayList.contains(a)) continue;
                    arrayList.add(a);
                }
                segmentOwners[i2] = arrayList;
            }
        } else {
            for (Map.Entry entry : primarySegments.entrySet()) {
                Integer segment2 = (Integer)entry.getKey();
                Address primaryOwner = (Address)entry.getValue();
                segmentOwners[segment2.intValue()] = new ArrayList(actualNumOwners);
                segmentOwners[segment2].add(primaryOwner);
            }
            boolean haveEnoughOwners = false;
            block7: while (!haveEnoughOwners) {
                void var13_23;
                block8: for (Address member : sortedMembers) {
                    int normalizedHash = hashFunction.hash(member.hashCode()) & Integer.MAX_VALUE;
                    initSegment = normalizedHash / segmentSize;
                    for (i = 0; i < numSegments; ++i) {
                        segment = (numSegments + initSegment - i) % numSegments;
                        List owners = segmentOwners[segment];
                        if (owners.size() >= actualNumOwners || owners.contains(member)) continue;
                        owners.add(member);
                        continue block8;
                    }
                }
                haveEnoughOwners = true;
                boolean bl = false;
                while (var13_23 < numSegments) {
                    if (segmentOwners[var13_23].size() < actualNumOwners) {
                        haveEnoughOwners = false;
                        continue block7;
                    }
                    ++var13_23;
                }
            }
        }
        return new DefaultConsistentHash(hashFunction, numSegments, numOwners, members, segmentOwners);
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> newMembers) {
        if (((Object)newMembers).equals(baseCH.getMembers())) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int numOwners = baseCH.getNumOwners();
        ArrayList<Address> leavers = new ArrayList<Address>(baseCH.getMembers());
        leavers.removeAll(newMembers);
        ConsistentHash rebalancedCH = this.create(baseCH.getHashFunction(), numOwners, numSegments, (List)newMembers);
        List[] newSegmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            ArrayList<Address> owners = new ArrayList<Address>(baseCH.locateOwnersForSegment(i));
            owners.removeAll(leavers);
            newSegmentOwners[i] = !owners.isEmpty() ? owners : ((DefaultConsistentHash)rebalancedCH).locateOwnersForSegment(i);
        }
        return new DefaultConsistentHash(baseCH.getHashFunction(), numSegments, numOwners, newMembers, newSegmentOwners);
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        ConsistentHash rebalancedCH = this.create(baseCH.getHashFunction(), baseCH.getNumOwners(), baseCH.getNumSegments(), (List)baseCH.getMembers());
        if (((DefaultConsistentHash)rebalancedCH).equals(baseCH)) {
            return baseCH;
        }
        return rebalancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash ch1, DefaultConsistentHash ch2) {
        return ch1.union(ch2);
    }

    private List<Address> sort(List<Address> members) {
        ArrayList<Address> result = new ArrayList<Address>(members);
        Collections.sort(result);
        return result;
    }
}

