/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="Activation", description="Component that handles activating entries that have been passivated to a CacheStore by loading them into memory.")
public class ActivationInterceptor
extends CacheLoaderInterceptor {
    private final AtomicLong activations = new AtomicLong(0L);
    private CacheStore store;
    private static final Log log = LogFactory.getLog(ActivationInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Start(priority=15)
    public void setCacheStore() {
        CacheStore cacheStore = this.store = this.clm == null ? null : this.clm.getCacheStore();
        if (this.store == null) {
            throw new ConfigurationException("Passivation can only be used with a CacheLoader that implements CacheStore!");
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object retval = super.visitPutKeyValueCommand(ctx, command);
        if (this.enabled) {
            this.removeFromStore(command.getKey());
        }
        return retval;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = super.visitRemoveCommand(ctx, command);
        if (this.enabled) {
            this.removeFromStore(command.getKey());
        }
        return retval;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object retval = super.visitReplaceCommand(ctx, command);
        if (this.enabled) {
            this.removeFromStore(command.getKey());
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object retval = super.visitPutMapCommand(ctx, command);
        if (this.enabled) {
            this.removeFromStore(command.getMap().keySet().toArray());
        }
        return retval;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Object retval = super.visitGetKeyValueCommand(ctx, command);
        if (this.enabled) {
            this.removeFromStore(command.getKey());
        }
        return retval;
    }

    private void removeFromStore(Object ... keys) throws CacheLoaderException {
        if (!this.clm.isShared()) {
            for (Object k : keys) {
                if (!this.store.remove(k) || !this.getStatisticsEnabled()) continue;
                this.activations.incrementAndGet();
            }
        } else if (trace) {
            log.trace("CacheStore is shared; will not remove from store when passivating!");
        }
    }

    @Override
    protected void sendNotification(Object key, Object value, boolean pre, InvocationContext ctx) {
        super.sendNotification(key, value, pre, ctx);
        this.notifier.notifyCacheEntryActivated(key, value, pre, ctx);
    }

    @ManagedAttribute(description="Number of activation events")
    @Metric(displayName="Number of cache entries activated", measurementType=MeasurementType.TRENDSUP)
    public String getActivations() {
        if (!this.getStatisticsEnabled()) {
            return "N/A";
        }
        return String.valueOf(this.activations.get());
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        super.resetStatistics();
        this.activations.set(0L);
    }
}

