/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.jmx.AbstractJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
public class CacheManagerJmxRegistration
extends AbstractJmxRegistration {
    private static final Log log = LogFactory.getLog(CacheManagerJmxRegistration.class);
    public static final String CACHE_MANAGER_JMX_GROUP = "type=CacheManager";
    private GlobalComponentRegistry globalReg;
    private boolean needToUnregister = false;

    @Inject
    public void init(GlobalComponentRegistry registry, GlobalConfiguration configuration) {
        this.globalReg = registry;
        this.globalConfig = configuration;
    }

    public void start() {
        if (this.registerMBeans(this.globalReg.getRegisteredComponents(), this.globalConfig)) {
            this.needToUnregister = true;
        } else {
            log.unableToRegisterCacheManagerMBeans();
        }
    }

    public void stop() {
        if (this.globalReg == null) {
            return;
        }
        if (this.needToUnregister) {
            try {
                this.unregisterMBeans(this.globalReg.getRegisteredComponents());
                this.needToUnregister = false;
            }
            catch (Exception e) {
                log.problemsUnregisteringMBeans(e);
            }
        }
        this.globalReg = null;
    }

    @Override
    protected ComponentsJmxRegistration buildRegistrar(Set<AbstractComponentRegistry.Component> components) {
        String groupName = "type=CacheManager," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(this.globalConfig.globalJmxStatistics().cacheManagerName());
        ComponentsJmxRegistration registrar = new ComponentsJmxRegistration(this.mBeanServer, components, groupName);
        this.updateDomain(registrar, this.mBeanServer, groupName);
        return registrar;
    }

    protected void updateDomain(ComponentsJmxRegistration registrar, MBeanServer mBeanServer, String groupName) {
        if (this.jmxDomain == null) {
            this.jmxDomain = JmxUtil.buildJmxDomain(this.globalConfig, mBeanServer, groupName);
            String configJmxDomain = this.globalConfig.globalJmxStatistics().domain();
            if (!this.jmxDomain.equals(configJmxDomain) && !this.globalConfig.globalJmxStatistics().allowDuplicateDomains()) {
                log.cacheManagerAlreadyRegistered(configJmxDomain);
                throw new JmxDomainConflictException(String.format("Domain already registered %s", configJmxDomain));
            }
        }
        registrar.setJmxDomain(this.jmxDomain);
    }
}

