/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.remoting.InboundInvocationHandler;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class InboundInvocationHandlerImpl
implements InboundInvocationHandler {
    private GlobalComponentRegistry gcr;
    private static final Log log = LogFactory.getLog(InboundInvocationHandlerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private GlobalConfiguration globalConfiguration;
    private Transport transport;

    @Inject
    public void inject(GlobalComponentRegistry gcr, Transport transport, GlobalConfiguration globalConfiguration) {
        this.gcr = gcr;
        this.transport = transport;
        this.globalConfiguration = globalConfiguration;
    }

    @Override
    public Response handle(CacheRpcCommand cmd, Address origin) throws Throwable {
        cmd.setOrigin(origin);
        String cacheName = cmd.getCacheName();
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        if (cr == null) {
            if (!this.globalConfiguration.transport().strictPeerToPeer()) {
                if (trace) {
                    log.tracef("Strict peer to peer off, so silently ignoring that %s cache is not defined", cacheName);
                }
                return null;
            }
            log.namedCacheDoesNotExist(cacheName);
            return new ExceptionResponse(new NamedCacheNotFoundException(cacheName, "Cache has not been started on node " + this.transport.getAddress()));
        }
        return this.handleWithWaitForBlocks(cmd, cr);
    }

    private Response handleInternal(CacheRpcCommand cmd, ComponentRegistry cr) throws Throwable {
        CommandsFactory commandsFactory = cr.getCommandsFactory();
        commandsFactory.initializeReplicableCommand(cmd, true);
        try {
            if (trace) {
                log.tracef("Calling perform() on %s", cmd);
            }
            ResponseGenerator respGen = cr.getResponseGenerator();
            Object retval = cmd.perform(null);
            return respGen.getResponse(cmd, retval);
        }
        catch (Exception e) {
            log.trace("Exception executing command", e);
            return new ExceptionResponse(e);
        }
    }

    private Response handleWithWaitForBlocks(CacheRpcCommand cmd, ComponentRegistry cr) throws Throwable {
        StateTransferManager stm = cr.getStateTransferManager();
        if (!stm.isJoinComplete()) {
            return null;
        }
        Response resp = this.handleInternal(cmd, cr);
        if (trace && resp != null && !resp.isValid()) {
            log.tracef("Unable to execute command, got invalid response %s", resp);
        }
        return resp;
    }
}

