/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.InboundTransferTask;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateConsumerImpl
implements StateConsumer {
    private static final Log log = LogFactory.getLog(StateConsumerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private LocalTopologyManager localTopologyManager;
    private String cacheName;
    private Configuration configuration;
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private TransactionTable transactionTable;
    private DataContainer dataContainer;
    private CacheLoaderManager cacheLoaderManager;
    private InterceptorChain interceptorChain;
    private InvocationContextContainer icc;
    private StateTransferLock stateTransferLock;
    private long timeout;
    private boolean useVersionedPut;
    private boolean fetchEnabled;
    private volatile CacheTopology cacheTopology;
    private AtomicInteger activeTopologyUpdates = new AtomicInteger(0);
    private AtomicBoolean rebalanceInProgress = new AtomicBoolean(false);
    private Map<Address, List<InboundTransferTask>> transfersBySource = new HashMap<Address, List<InboundTransferTask>>();
    private Map<Integer, InboundTransferTask> transfersBySegment = new HashMap<Integer, InboundTransferTask>();

    @Inject
    public void init(Cache cache, LocalTopologyManager localTopologyManager, InterceptorChain interceptorChain, InvocationContextContainer icc, Configuration configuration, RpcManager rpcManager, CommandsFactory commandsFactory, CacheLoaderManager cacheLoaderManager, DataContainer dataContainer, TransactionTable transactionTable, StateTransferLock stateTransferLock) {
        this.cacheName = cache.getName();
        this.localTopologyManager = localTopologyManager;
        this.interceptorChain = interceptorChain;
        this.icc = icc;
        this.configuration = configuration;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.cacheLoaderManager = cacheLoaderManager;
        this.dataContainer = dataContainer;
        this.transactionTable = transactionTable;
        this.stateTransferLock = stateTransferLock;
        this.useVersionedPut = configuration.transaction().transactionMode().isTransactional() && configuration.versioning().enabled() && configuration.locking().writeSkewCheck() && configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC && configuration.clustering().cacheMode().isClustered();
        this.timeout = configuration.clustering().stateTransfer().timeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStateTransferInProgress() {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            return !this.transfersBySource.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStateTransferInProgressForKey(Object key) {
        if (this.configuration.clustering().cacheMode().isInvalidation()) {
            return false;
        }
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            return this.cacheTopology != null && this.transfersBySegment.containsKey(this.getSegment(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTopologyUpdate(CacheTopology cacheTopology, boolean isRebalance) {
        if (trace) {
            log.tracef("Received new CH: %s", cacheTopology.getWriteConsistentHash());
        }
        this.activeTopologyUpdates.incrementAndGet();
        if (isRebalance) {
            this.rebalanceInProgress.set(true);
        }
        ConsistentHash previousCh = this.cacheTopology != null ? this.cacheTopology.getWriteConsistentHash() : null;
        this.stateTransferLock.acquireExclusiveTopologyLock();
        this.cacheTopology = cacheTopology;
        this.stateTransferLock.releaseExclusiveTopologyLock();
        this.stateTransferLock.topologyInstalled(cacheTopology.getTopologyId());
        try {
            Set<Integer> addedSegments;
            if (previousCh == null) {
                addedSegments = this.getOwnedSegments(cacheTopology.getWriteConsistentHash());
            } else {
                Set<Integer> previousSegments = this.getOwnedSegments(previousCh);
                Set<Integer> newSegments = this.getOwnedSegments(cacheTopology.getWriteConsistentHash());
                HashSet<Integer> removedSegments = new HashSet<Integer>(previousSegments);
                removedSegments.removeAll(newSegments);
                if (trace) {
                    log.tracef("Discarding removed segments: %s; new segments: %s; old segments: %s", removedSegments, newSegments, previousSegments);
                }
                this.discardSegments(removedSegments);
                Set<Integer> currentSegments = this.getOwnedSegments(cacheTopology.getReadConsistentHash());
                addedSegments = new HashSet<Integer>(newSegments);
                addedSegments.removeAll(currentSegments);
                HashSet<Address> members = new HashSet<Address>(cacheTopology.getReadConsistentHash().getMembers());
                StateConsumerImpl stateConsumerImpl = this;
                synchronized (stateConsumerImpl) {
                    for (Address source : this.transfersBySource.keySet()) {
                        List<InboundTransferTask> inboundTransfers;
                        if (members.contains(source) || (inboundTransfers = this.transfersBySource.remove(source)) == null) continue;
                        for (InboundTransferTask inboundTransfer : inboundTransfers) {
                            this.transfersBySegment.keySet().removeAll(inboundTransfer.getSegments());
                        }
                    }
                }
            }
            if (addedSegments != null && !addedSegments.isEmpty()) {
                this.addTransfers(addedSegments);
            }
        }
        finally {
            this.stateTransferLock.transactionDataReceived(cacheTopology.getTopologyId());
            if (this.activeTopologyUpdates.decrementAndGet() == 0 && !this.isStateTransferInProgress()) {
                this.notifyEndOfTopologyUpdate(cacheTopology.getTopologyId());
            }
        }
    }

    private void notifyEndOfTopologyUpdate(int topologyId) {
        if (this.rebalanceInProgress.compareAndSet(true, false)) {
            this.localTopologyManager.confirmRebalance(this.cacheName, topologyId, null);
        }
    }

    private Set<Integer> getOwnedSegments(ConsistentHash consistentHash) {
        Address address = this.rpcManager.getAddress();
        return consistentHash.getMembers().contains(address) ? consistentHash.getSegmentsForOwner(address) : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyState(Address sender, int topologyId, int segmentId, Collection<InternalCacheEntry> cacheEntries, boolean isLastChunk) {
        InboundTransferTask inboundTransfer;
        if (!this.cacheTopology.getWriteConsistentHash().getSegmentsForOwner(this.rpcManager.getAddress()).contains(segmentId)) {
            if (trace) {
                log.warnf("Discarding received cache entries for segment %d because they do not belong to this node.", segmentId);
            }
            return;
        }
        if (cacheEntries != null) {
            this.doApplyState(sender, segmentId, cacheEntries);
        }
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            inboundTransfer = this.transfersBySegment.get(segmentId);
        }
        if (inboundTransfer == null) {
            log.debugf("Received unsolicited state for segment %d from node %s", segmentId, sender);
            return;
        }
        inboundTransfer.onStateReceived(segmentId, isLastChunk);
        if (trace) {
            log.tracef("After applying the received state the data container has %d keys", this.dataContainer.size());
            stateConsumerImpl = this;
            synchronized (stateConsumerImpl) {
                log.tracef("Segments not received yet: %s", this.transfersBySource);
            }
        }
    }

    private void doApplyState(Address sender, int segmentId, Collection<InternalCacheEntry> cacheEntries) {
        log.debugf("Applying new state for segment %d from %s: received %d cache entries", segmentId, sender, cacheEntries.size());
        if (trace) {
            ArrayList<Object> keys = new ArrayList<Object>(cacheEntries.size());
            for (InternalCacheEntry e : cacheEntries) {
                keys.add(e.getKey());
            }
            log.tracef("Received keys: %s", keys);
        }
        EnumSet<Flag> flags = EnumSet.of(Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_SHARED_CACHE_STORE, Flag.SKIP_OWNERSHIP_CHECK, Flag.SKIP_XSITE_BACKUP);
        for (InternalCacheEntry e : cacheEntries) {
            InvocationContext ctx = this.icc.createRemoteInvocationContext(sender);
            try {
                PutKeyValueCommand put = this.useVersionedPut ? this.commandsFactory.buildVersionedPutKeyValueCommand(e.getKey(), e.getValue(), e.getLifespan(), e.getMaxIdle(), e.getVersion(), flags) : this.commandsFactory.buildPutKeyValueCommand(e.getKey(), e.getValue(), e.getLifespan(), e.getMaxIdle(), flags);
                put.setPutIfAbsent(true);
                this.interceptorChain.invoke(ctx, put);
            }
            catch (Exception ex) {
                log.problemApplyingStateForKey(ex.getMessage(), e.getKey());
            }
        }
    }

    @Override
    public void applyTransactions(Address sender, int topologyId, Collection<TransactionInfo> transactions) {
        log.debugf("Applying %d transactions transferred from %s", transactions.size(), sender);
        if (this.configuration.transaction().transactionMode().isTransactional()) {
            for (TransactionInfo transactionInfo : transactions) {
                AbstractCacheTransaction tx = this.transactionTable.getLocalTransaction(transactionInfo.getGlobalTransaction());
                if (tx == null && (tx = this.transactionTable.getRemoteTransaction(transactionInfo.getGlobalTransaction())) == null) {
                    tx = this.transactionTable.createRemoteTransaction(transactionInfo.getGlobalTransaction(), transactionInfo.getModifications());
                    ((RemoteTransaction)tx).setMissingLookedUpEntries(true);
                }
                for (Object key : transactionInfo.getLockedKeys()) {
                    tx.addBackupLockForKey(key);
                }
            }
        }
    }

    @Start(priority=20)
    public void start() {
        this.fetchEnabled = this.configuration.clustering().stateTransfer().fetchInMemoryState() || this.cacheLoaderManager.isFetchPersistentState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Stop(priority=20)
    public void stop() {
        if (trace) {
            log.tracef("Shutting down StateConsumer of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        try {
            StateConsumerImpl stateConsumerImpl = this;
            synchronized (stateConsumerImpl) {
                Iterator<List<InboundTransferTask>> it = this.transfersBySource.values().iterator();
                while (it.hasNext()) {
                    List<InboundTransferTask> inboundTransfers = it.next();
                    it.remove();
                    for (InboundTransferTask inboundTransfer : inboundTransfers) {
                        inboundTransfer.cancel();
                    }
                }
                this.transfersBySource.clear();
                this.transfersBySegment.clear();
            }
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to stop StateConsumer of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
    }

    @Override
    public CacheTopology getCacheTopology() {
        return this.cacheTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransfers(Set<Integer> segments) {
        log.debugf("Adding state transfer for segments: %s", segments);
        HashSet<Integer> segmentsToProcess = new HashSet<Integer>(segments);
        HashSet<Address> blacklistedSources = new HashSet<Address>();
        Object it = segmentsToProcess.iterator();
        while (it.hasNext()) {
            Integer segmentId = (Integer)it.next();
            Address source = this.pickSourceOwner(segmentId, blacklistedSources);
            if (source != null) continue;
            it.remove();
        }
        it = this;
        synchronized (it) {
            segmentsToProcess.removeAll(this.transfersBySegment.keySet());
        }
        while (!segmentsToProcess.isEmpty()) {
            HashSet<Integer> segmentsFromSource;
            HashMap<Address, HashSet<Integer>> segmentsBySource = new HashMap<Address, HashSet<Integer>>();
            Iterator i$ = segmentsToProcess.iterator();
            while (i$.hasNext()) {
                int segmentId = (Integer)i$.next();
                Address source = this.pickSourceOwner(segmentId, blacklistedSources);
                if (source == null) continue;
                segmentsFromSource = (HashSet<Integer>)segmentsBySource.get(source);
                if (segmentsFromSource == null) {
                    segmentsFromSource = new HashSet<Integer>();
                    segmentsBySource.put(source, segmentsFromSource);
                }
                segmentsFromSource.add(segmentId);
            }
            HashSet<Integer> failedSegments = new HashSet<Integer>();
            for (Address source : segmentsBySource.keySet()) {
                segmentsFromSource = (Set)segmentsBySource.get(source);
                InboundTransferTask inboundTransfer = new InboundTransferTask(segmentsFromSource, source, this.cacheTopology.getTopologyId(), this, this.rpcManager, this.commandsFactory, this.timeout);
                StateConsumerImpl stateConsumerImpl = this;
                synchronized (stateConsumerImpl) {
                    Iterator i$2 = segmentsFromSource.iterator();
                    while (i$2.hasNext()) {
                        int segmentId = (Integer)i$2.next();
                        this.transfersBySegment.put(segmentId, inboundTransfer);
                    }
                    List<InboundTransferTask> inboundTransfers = this.transfersBySource.get(inboundTransfer.getSource());
                    if (inboundTransfers == null) {
                        inboundTransfers = new ArrayList<InboundTransferTask>();
                        this.transfersBySource.put(inboundTransfer.getSource(), inboundTransfers);
                    }
                    inboundTransfers.add(inboundTransfer);
                }
                if (this.configuration.transaction().transactionMode().isTransactional() && !inboundTransfer.requestTransactions()) {
                    log.errorf("Failed to retrieve transactions for segments %s from node %s (node will be blacklisted)", segmentsFromSource, source);
                    failedSegments.addAll(segmentsFromSource);
                    blacklistedSources.add(source);
                    this.removeTransfer(inboundTransfer);
                    continue;
                }
                if (this.fetchEnabled) {
                    if (inboundTransfer.requestSegments()) continue;
                    log.errorf("Failed to request segments %s from node %s (node will be blacklisted)", segmentsFromSource, source);
                    failedSegments.addAll(segmentsFromSource);
                    blacklistedSources.add(source);
                    this.removeTransfer(inboundTransfer);
                    continue;
                }
                this.removeTransfer(inboundTransfer);
            }
            segmentsToProcess = failedSegments;
        }
    }

    private Address pickSourceOwner(int segmentId, Set<Address> blacklistedSources) {
        List<Address> owners = this.cacheTopology.getReadConsistentHash().locateOwnersForSegment(segmentId);
        if (owners.size() == 1 && owners.get(0).equals(this.rpcManager.getAddress())) {
            return null;
        }
        for (int i = owners.size() - 1; i >= 0; --i) {
            Address o = owners.get(i);
            if (o.equals(this.rpcManager.getAddress()) || blacklistedSources.contains(o)) continue;
            return o;
        }
        log.errorf("No live owners found for segment %d. Current owners are:  %s. Blacklisted owners: %s", segmentId, owners, blacklistedSources);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardSegments(Set<Integer> segments) {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            ArrayList<Integer> segmentsToCancel = new ArrayList<Integer>(segments);
            while (!segmentsToCancel.isEmpty()) {
                int segmentId = (Integer)segmentsToCancel.remove(0);
                log.debugf("Removing state transfer for segment %d", segmentId);
                InboundTransferTask inboundTransfer = this.transfersBySegment.remove(segmentId);
                if (inboundTransfer == null) continue;
                HashSet<Integer> cancelledSegments = new HashSet<Integer>(segmentsToCancel);
                cancelledSegments.retainAll(inboundTransfer.getSegments());
                segmentsToCancel.removeAll(cancelledSegments);
                inboundTransfer.cancelSegments(cancelledSegments);
            }
        }
        HashSet<Object> keysToRemove = new HashSet<Object>();
        for (InternalCacheEntry ice : this.dataContainer) {
            Object key = ice.getKey();
            if (!segments.contains(this.getSegment(key))) continue;
            keysToRemove.add(key);
        }
        CacheStore cacheStore = this.getCacheStore();
        if (cacheStore != null) {
            try {
                Set<Object> storedKeys = cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer));
                for (Object key : storedKeys) {
                    if (!segments.contains(this.getSegment(key))) continue;
                    keysToRemove.add(key);
                }
            }
            catch (CacheLoaderException e) {
                log.failedLoadingKeysFromCacheStore(e);
            }
        }
        if (!keysToRemove.isEmpty()) {
            try {
                InvalidateCommand invalidateCmd = this.commandsFactory.buildInvalidateFromL1Command(true, EnumSet.of(Flag.CACHE_MODE_LOCAL, Flag.SKIP_LOCKING), keysToRemove);
                NonTxInvocationContext ctx = this.icc.createNonTxInvocationContext();
                this.interceptorChain.invoke(ctx, invalidateCmd);
                log.debugf("Invalidated %d keys, data container now has %d keys", keysToRemove.size(), this.dataContainer.size());
                if (trace) {
                    log.tracef("Invalidated keys: %s", keysToRemove);
                }
            }
            catch (CacheException e) {
                log.failedToInvalidateKeys(e);
            }
        }
    }

    private int getSegment(Object key) {
        return this.cacheTopology.getReadConsistentHash().getSegment(key);
    }

    private CacheStore getCacheStore() {
        if (this.cacheLoaderManager != null && this.cacheLoaderManager.isEnabled() && !this.cacheLoaderManager.isShared()) {
            return this.cacheLoaderManager.getCacheStore();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransfer(InboundTransferTask inboundTransfer) {
        StateConsumerImpl stateConsumerImpl = this;
        synchronized (stateConsumerImpl) {
            List<InboundTransferTask> transfers = this.transfersBySource.get(inboundTransfer.getSource());
            if (transfers != null && transfers.remove(inboundTransfer)) {
                if (transfers.isEmpty()) {
                    this.transfersBySource.remove(inboundTransfer.getSource());
                }
                for (int segmentId : inboundTransfer.getSegments()) {
                    this.transfersBySegment.remove(segmentId);
                }
            }
        }
    }

    void onTaskCompletion(InboundTransferTask inboundTransfer) {
        this.removeTransfer(inboundTransfer);
        if (this.activeTopologyUpdates.get() == 0 && !this.isStateTransferInProgress()) {
            this.notifyEndOfTopologyUpdate(this.cacheTopology.getTopologyId());
        }
    }
}

