/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.util.Immutables;

class ClusterCacheStatus {
    private final String cacheName;
    private final CacheJoinInfo joinInfo;
    private volatile List<Address> members;
    private volatile List<Address> joiners;
    private volatile CacheTopology cacheTopology;
    private volatile RebalanceConfirmationCollector rebalanceStatus;

    public ClusterCacheStatus(String cacheName, CacheJoinInfo joinInfo) {
        this.cacheName = cacheName;
        this.joinInfo = joinInfo;
        this.cacheTopology = new CacheTopology(-1, null, null);
        this.members = Collections.emptyList();
        this.joiners = Collections.emptyList();
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public List<Address> getMembers() {
        return this.members;
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    public List<Address> getJoiners() {
        return this.joiners;
    }

    public boolean hasJoiners() {
        return !this.joiners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembers(List<Address> newMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.members = Immutables.immutableListCopy(newMembers);
            ConsistentHash currentCH = this.cacheTopology.getCurrentCH();
            this.joiners = currentCH != null ? this.immutableRemoveAll(this.members, currentCH.getMembers()) : this.members;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(Address joiner) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.members.contains(joiner)) {
                return false;
            }
            this.members = this.immutableAdd(this.members, joiner);
            this.joiners = this.immutableAdd(this.joiners, joiner);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(Address leaver) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (!this.members.contains(leaver)) {
                return false;
            }
            this.members = this.immutableRemove(this.members, leaver);
            this.joiners = this.immutableRemove(this.joiners, leaver);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateClusterMembers(List<Address> newClusterMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newClusterMembers.containsAll(this.members)) {
                return false;
            }
            this.members = this.immutableRetainAll(this.members, newClusterMembers);
            this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
            return true;
        }
    }

    public CacheTopology getCacheTopology() {
        return this.cacheTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.cacheTopology = newTopology;
            if (newTopology.getCurrentCH() != null) {
                this.joiners = this.immutableRemoveAll(this.joiners, newTopology.getCurrentCH().getMembers());
            }
        }
    }

    public boolean needConsistentHashUpdate() {
        return !this.members.containsAll(this.cacheTopology.getMembers());
    }

    public List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.members);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceStatus != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRebalance(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus != null) {
                return false;
            }
            this.rebalanceStatus = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers());
            this.cacheTopology = newTopology;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmRebalanceOnNode(Address member, int receivedTopologyId) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                return false;
            }
            return this.rebalanceStatus.confirmRebalance(member, receivedTopologyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRebalanceMembersList() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                return false;
            }
            return this.rebalanceStatus.updateMembers(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRebalance(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceStatus == null) {
                throw new IllegalStateException("Can't end rebalance, there is no rebalance in progress");
            }
            this.updateCacheTopology(newTopology);
            this.rebalanceStatus = null;
        }
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }
}

