/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction
implements Cloneable {
    private static final Log log = LogFactory.getLog(RemoteTransaction.class);
    private volatile boolean valid = true;
    private volatile boolean missingLookedUpEntries = false;

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
        super(tx, topologyId);
        this.modifications = modifications == null || modifications.length == 0 ? Collections.emptyList() : Arrays.asList(modifications);
        this.lookedUpEntries = new HashMap(this.modifications.size());
    }

    public RemoteTransaction(GlobalTransaction tx, int topologyId) {
        super(tx, topologyId);
        this.modifications = new LinkedList();
        this.lookedUpEntries = new HashMap(2);
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (!this.valid) {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is invalid");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Adding key %s to tx %s", key, this.getGlobalTransaction());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        if (!this.valid) {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is invalid");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Adding keys %s to tx %s", entries.keySet(), this.getGlobalTransaction());
        }
        this.lookedUpEntries.putAll(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList(this.modifications);
            dolly.lookedUpEntries = new HashMap(this.lookedUpEntries);
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", lockedKeys= " + this.lockedKeys + ", backupKeyLocks " + this.backupKeyLocks + ", missingLookedUpEntries " + this.missingLookedUpEntries + ", tx=" + this.tx + '}';
    }

    public void setMissingLookedUpEntries(boolean missingLookedUpEntries) {
        this.missingLookedUpEntries = missingLookedUpEntries;
    }

    public boolean isMissingLookedUpEntries() {
        return this.missingLookedUpEntries;
    }
}

