/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.context.Flag;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class StaleTransactionCleanupService {
    private static Log log = LogFactory.getLog(StaleTransactionCleanupService.class);
    private TransactionTable transactionTable;
    private InterceptorChain invoker;
    private String cacheName;
    private boolean isDistributed;
    private ExecutorService lockBreakingService;

    public StaleTransactionCleanupService(TransactionTable transactionTable) {
        this.transactionTable = transactionTable;
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
        if (tce.isPre()) {
            List<Address> leavers;
            ConsistentHash consistentHashAtStart = tce.getConsistentHashAtStart();
            if (consistentHashAtStart != null && !(leavers = MembershipArithmetic.getMembersLeft(consistentHashAtStart.getMembers(), tce.getConsistentHashAtEnd().getMembers())).isEmpty()) {
                log.tracef("Saw %d leavers - kicking off a lock breaking task", leavers.size());
                this.cleanTxForWhichTheOwnerLeft(leavers);
            }
            return;
        }
        if (!this.isDistributed) {
            return;
        }
        Address self = this.transactionTable.rpcManager.getAddress();
        ConsistentHash chOld = tce.getConsistentHashAtStart();
        ConsistentHash chNew = tce.getConsistentHashAtEnd();
        log.tracef("Unlocking keys for which we are no longer an owner", new Object[0]);
        for (RemoteTransaction remoteTx : this.transactionTable.getRemoteTransactions()) {
            GlobalTransaction gtx = remoteTx.getGlobalTransaction();
            ArrayList<Object> keys = new ArrayList<Object>();
            boolean txHasLocalKeys = false;
            for (Object key : remoteTx.getLockedKeys()) {
                boolean wasLocal = chOld.isKeyLocalToNode(self, key);
                boolean isLocal = chNew.isKeyLocalToNode(self, key);
                if (wasLocal && !isLocal) {
                    keys.add(key);
                }
                txHasLocalKeys |= isLocal;
            }
            for (Object key : remoteTx.getBackupLockedKeys()) {
                boolean isLocal = chNew.isKeyLocalToNode(self, key);
                txHasLocalKeys |= isLocal;
            }
            if (keys.size() <= 0) continue;
            log.tracef("Unlocking keys %s for remote transaction %s as we are no longer an owner", keys, gtx);
            EnumSet<Flag> flags = EnumSet.of(Flag.CACHE_MODE_LOCAL);
            LockControlCommand unlockCmd = new LockControlCommand(keys, this.cacheName, flags, gtx);
            unlockCmd.init(this.invoker, this.transactionTable.icc, this.transactionTable);
            unlockCmd.setUnlock(true);
            try {
                unlockCmd.perform(null);
                log.tracef("Unlocking moved keys for %s complete.", gtx);
            }
            catch (Throwable t) {
                log.unableToUnlockRebalancedKeys(gtx, keys, self, t);
            }
        }
        log.trace("Finished cleaning locks for keys that are no longer local");
    }

    private void cleanTxForWhichTheOwnerLeft(final Collection<Address> leavers) {
        try {
            this.lockBreakingService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        StaleTransactionCleanupService.this.transactionTable.updateStateOnNodesLeaving(leavers);
                    }
                    catch (Exception e) {
                        log.error("Exception whilst updating state", e);
                    }
                }
            });
        }
        catch (RejectedExecutionException ree) {
            log.error("Unable to submit task to executor", ree);
        }
    }

    public void start(final String cacheName, final RpcManager rpcManager, InterceptorChain interceptorChain, boolean isDistributed) {
        this.invoker = interceptorChain;
        ThreadFactory tf = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String address = rpcManager != null ? rpcManager.getTransport().getAddress().toString() : "local";
                Thread th = new Thread(r, "LockBreakingService," + cacheName + "," + address);
                th.setDaemon(true);
                return th;
            }
        };
        this.cacheName = cacheName;
        this.isDistributed = isDistributed;
        this.lockBreakingService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), tf, new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void stop() {
        if (this.lockBreakingService != null) {
            this.lockBreakingService.shutdownNow();
        }
    }
}

