/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.StaleTransactionCleanupService;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Listener
public class TransactionTable {
    public static final int CACHE_STOPPED_TOPOLOGY_ID = -1;
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private ConcurrentMap<Transaction, LocalTransaction> localTransactions;
    private ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions;
    private final StaleTransactionCleanupService cleanupService = new StaleTransactionCleanupService(this);
    protected Configuration configuration;
    protected InvocationContextContainer icc;
    protected TransactionCoordinator txCoordinator;
    protected TransactionFactory txFactory;
    protected RpcManager rpcManager;
    protected CommandsFactory commandsFactory;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    protected ClusteringDependentLogic clusteringLogic;
    protected boolean clustered = false;
    private Lock minTopologyRecalculationLock;
    private volatile int minTxTopologyId = -1;
    private volatile int currentTopologyId = -1;
    private volatile boolean useStrictTopologyIdComparison = true;
    private String cacheName;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, TransactionCoordinator txCoordinator, TransactionSynchronizationRegistry transactionSynchronizationRegistry, CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic, Cache cache) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.txCoordinator = txCoordinator;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.commandsFactory = commandsFactory;
        this.clusteringLogic = clusteringDependentLogic;
        this.cacheName = cache.getName();
    }

    @Start(priority=9)
    private void start() {
        int concurrencyLevel = this.configuration.locking().concurrencyLevel();
        this.localTransactions = ConcurrentMapFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel);
        if (this.configuration.clustering().cacheMode().isClustered()) {
            this.minTopologyRecalculationLock = new ReentrantLock();
            this.remoteTransactions = ConcurrentMapFactory.makeConcurrentMap(concurrencyLevel, 0.75f, concurrencyLevel);
            this.cleanupService.start(this.cacheName, this.rpcManager, this.invoker, this.configuration.clustering().cacheMode().isDistributed());
            this.notifier.addListener(this.cleanupService);
            this.notifier.addListener(this);
            this.clustered = true;
        }
    }

    @Stop
    private void stop() {
        if (this.clustered) {
            this.notifier.removeListener(this.cleanupService);
            this.cleanupService.stop();
            this.notifier.removeListener(this);
            this.currentTopologyId = -1;
        }
        this.shutDownGracefully();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return Collections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator, this.commandsFactory, this.rpcManager, this, this.clusteringLogic, this.configuration);
            if (this.transactionSynchronizationRegistry != null) {
                try {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException(e);
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException(e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        LocalTransaction localTransaction = (LocalTransaction)this.localTransactions.get(tx);
        if (localTransaction != null) {
            this.removeLocalTransaction(localTransaction);
        }
    }

    public boolean containsLocalTx(Transaction tx) {
        return tx != null && this.localTransactions.containsKey(tx);
    }

    public int getMinTopologyId() {
        return this.minTxTopologyId;
    }

    public boolean useStrictTopologyIdComparison() {
        return this.useStrictTopologyIdComparison;
    }

    protected void updateStateOnNodesLeaving(Collection<Address> leavers) {
        HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
        for (GlobalTransaction gt : this.remoteTransactions.keySet()) {
            if (!leavers.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (toKill.isEmpty()) {
            log.tracef("No global transactions pertain to originator(s) %s who have left the cluster.", leavers);
        } else {
            log.tracef("%s global transactions pertain to leavers list %s and need to be killed", toKill.size(), leavers);
        }
        for (GlobalTransaction gtx : toKill) {
            log.tracef("Killing remote transaction originating on leaver %s", gtx);
            RollbackCommand rc = new RollbackCommand(this.cacheName, gtx);
            rc.init(this.invoker, this.icc, this);
            try {
                rc.perform(null);
                log.tracef("Rollback of transaction %s complete.", gtx);
            }
            catch (Throwable e) {
                log.unableToRollbackGlobalTx(gtx, e);
            }
        }
        log.trace("Completed cleaning transactions originating on leavers");
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public void remoteTransactionRollback(GlobalTransaction gtx) {
        RemoteTransaction remove = this.removeRemoteTransaction(gtx);
        log.tracef("Removed local transaction %s? %b", gtx, remove);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        return this.createRemoteTransaction(globalTx, modifications, this.currentTopologyId);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications, int topologyId) {
        RemoteTransaction remoteTransaction = modifications == null ? this.txFactory.newRemoteTransaction(globalTx, topologyId) : this.txFactory.newRemoteTransaction(modifications, globalTx, topologyId);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            log.remoteTxAlreadyRegistered();
            throw new IllegalStateException("A remote transaction with the given id was already registered!!!");
        }
        log.tracef("Created and registered remote transaction %s", rtx);
        if (rtx.getTopologyId() < this.minTxTopologyId) {
            log.tracef("Changing minimum topology ID from %d to %d", this.minTxTopologyId, rtx.getTopologyId());
            this.minTxTopologyId = rtx.getTopologyId();
        }
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, TxInvocationContext ctx) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress;
            Address address = localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            if (this.rpcManager != null && this.currentTopologyId < 0) {
                throw new IllegalStateException("Cannot create transactions if topology id is not known yet!");
            }
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            current = this.txFactory.newLocalTransaction(transaction, tx, ctx.isImplicitTransaction(), this.currentTopologyId);
            log.tracef("Created a new local transaction: %s", current);
            this.localTransactions.put(transaction, current);
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.removeLocalTransactionInternal(localTransaction.getTransaction()) != null;
    }

    protected final LocalTransaction removeLocalTransactionInternal(Transaction tx) {
        LocalTransaction removed = (LocalTransaction)this.localTransactions.remove(tx);
        this.releaseResources(removed);
        return removed;
    }

    private void releaseResources(CacheTransaction cacheTransaction) {
        if (cacheTransaction != null) {
            if (this.clustered) {
                this.recalculateMinTopologyIdIfNeeded(cacheTransaction);
            }
            log.tracef("Removed %s from transaction table.", cacheTransaction);
            cacheTransaction.notifyOnTransactionFinished();
        }
    }

    public void remoteTransactionCommitted(GlobalTransaction gtx) {
        if (Configurations.isSecondPhaseAsync(this.configuration)) {
            this.removeRemoteTransaction(gtx);
        }
    }

    public final RemoteTransaction removeRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction removed = (RemoteTransaction)this.remoteTransactions.remove(txId);
        this.releaseResources(removed);
        return removed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(GlobalTransaction txId) {
        for (LocalTransaction localTx : this.localTransactions.values()) {
            if (!txId.equals(localTx.getGlobalTransaction())) continue;
            return localTx;
        }
        return null;
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    public Collection<LocalTransaction> getLocalTransactions() {
        return this.localTransactions.values();
    }

    protected final void recalculateMinTopologyIdIfNeeded(CacheTransaction removedTransaction) {
        if (removedTransaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null!");
        }
        if (this.currentTopologyId != -1) {
            int removedTransactionTopologyId = removedTransaction.getTopologyId();
            if (removedTransactionTopologyId < this.minTxTopologyId) {
                log.tracef("A transaction has a topology ID (%s) that is smaller than the smallest transaction topology ID (%s) this node knows about!  This can happen if a concurrent thread recalculates the minimum topology ID after the current transaction has been removed from the transaction table.", removedTransactionTopologyId, this.minTxTopologyId);
            } else if (removedTransactionTopologyId == this.minTxTopologyId && removedTransactionTopologyId < this.currentTopologyId) {
                this.calculateMinTopologyId(removedTransactionTopologyId);
            }
        }
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent<?, ?> tce) {
        if (this.clustered) {
            if (tce.isPre()) {
                this.useStrictTopologyIdComparison = tce.getNewTopologyId() != this.currentTopologyId;
                this.currentTopologyId = tce.getNewTopologyId();
            } else {
                log.debugf("Topology changed, recalculating minTopologyId", new Object[0]);
                this.calculateMinTopologyId(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="minTopologyRecalculationLock")
    private void calculateMinTopologyId(int idOfRemovedTransaction) {
        this.minTopologyRecalculationLock.lock();
        try {
            if (idOfRemovedTransaction == -1 || idOfRemovedTransaction == this.minTxTopologyId && idOfRemovedTransaction < this.currentTopologyId) {
                int topologyId;
                int minTopologyIdFound = this.currentTopologyId;
                for (AbstractCacheTransaction ct : this.localTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                for (AbstractCacheTransaction ct : this.remoteTransactions.values()) {
                    topologyId = ct.getTopologyId();
                    if (topologyId >= minTopologyIdFound) continue;
                    minTopologyIdFound = topologyId;
                }
                if (minTopologyIdFound != this.minTxTopologyId) {
                    log.tracef("Changing minimum topology ID from %s to %s", this.minTxTopologyId, minTopologyIdFound);
                    this.minTxTopologyId = minTopologyIdFound;
                } else {
                    log.tracef("Minimum topology ID still is %s; nothing to change", minTopologyIdFound);
                }
            }
        }
        finally {
            this.minTopologyRecalculationLock.unlock();
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || this.remoteTransactions != null && !this.remoteTransactions.isEmpty();
    }

    private void shutDownGracefully() {
        if (log.isDebugEnabled()) {
            log.debugf("Wait for on-going transactions to finish for %s.", Util.prettyPrintTime(this.configuration.transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS));
        }
        long failTime = Util.currentMillisFromNanotime() + this.configuration.transaction().cacheStopTimeout();
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && Util.currentMillisFromNanotime() < failTime) {
            try {
                Thread.sleep(30L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.clustered) {
                    log.debugf("Interrupted waiting for on-going transactions to finish. %s local transactions and %s remote transactions", this.localTransactions.size(), this.remoteTransactions.size());
                    continue;
                }
                log.debugf("Interrupted waiting for %s on-going transactions to finish.", this.localTransactions.size());
            }
        }
        if (txsOnGoing) {
            log.unfinishedTransactionsRemain(this.localTransactions == null ? 0 : this.localTransactions.size(), this.remoteTransactions == null ? 0 : this.remoteTransactions.size());
        } else {
            log.debug("All transactions terminated");
        }
    }
}

