/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.Collection;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RecoveryAwareRemoteTransaction
extends RemoteTransaction
implements RecoveryAwareTransaction {
    private static final Log log = LogFactory.getLog(RecoveryAwareRemoteTransaction.class);
    private boolean prepared;
    private boolean isOrphan;
    private Integer status;

    public RecoveryAwareRemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId) {
        super(modifications, tx, topologyId);
    }

    public RecoveryAwareRemoteTransaction(GlobalTransaction tx, int topologyId) {
        super(tx, topologyId);
    }

    public boolean isInDoubt() {
        return this.isPrepared() && this.isOrphan();
    }

    public boolean isOrphan() {
        return this.isOrphan;
    }

    public void computeOrphan(Collection<Address> leavers) {
        if (leavers.contains(this.getGlobalTransaction().getAddress())) {
            if (log.isTraceEnabled()) {
                log.tracef("This transaction's originator has left the cluster: %s", this.getGlobalTransaction());
            }
            this.isOrphan = true;
        }
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
        if (prepared) {
            this.status = 2;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{prepared=" + this.prepared + ", isOrphan=" + this.isOrphan + ", modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", tx=" + this.tx + "} ";
    }

    public void markCompleted(boolean committed) {
        this.status = committed ? 3 : 4;
    }

    public Integer getStatus() {
        return this.status;
    }
}

