/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class OfflineStatus {
    private static Log log = LogFactory.getLog(OfflineStatus.class);
    private final TakeOfflineConfiguration takeOffline;
    private boolean recordingOfflineStatus = false;
    private long firstFailureTime;
    private int failureCount;

    public OfflineStatus(TakeOfflineConfiguration takeOfflineConfiguration) {
        this.takeOffline = takeOfflineConfiguration;
    }

    public synchronized void updateOnCommunicationFailure(long sendTimeMillis) {
        if (!this.recordingOfflineStatus) {
            this.recordingOfflineStatus = true;
            this.firstFailureTime = sendTimeMillis;
        }
        ++this.failureCount;
    }

    public synchronized boolean isOffline() {
        if (!this.recordingOfflineStatus) {
            return false;
        }
        if (this.takeOffline.minTimeToWait() > 0L && !this.minTimeHasElapsed()) {
            return false;
        }
        if (this.takeOffline.afterFailures() > 0) {
            return this.takeOffline.afterFailures() <= this.failureCount;
        }
        log.trace("Site is failed: minTimeToWait elapsed and we don't have a min failure number to wait for.");
        return true;
    }

    public synchronized boolean minTimeHasElapsed() {
        if (this.takeOffline.minTimeToWait() <= 0L) {
            throw new IllegalStateException("Cannot invoke this method if minTimeToWait is not enabled");
        }
        long millis = this.millisSinceFirstFailure();
        if (millis >= this.takeOffline.minTimeToWait()) {
            log.tracef("The minTimeToWait has passed: minTime=%s, timeSinceFirstFailure=%s", this.takeOffline.minTimeToWait(), millis);
            return true;
        }
        return false;
    }

    public synchronized long millisSinceFirstFailure() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - this.firstFailureTime;
    }

    public synchronized boolean bringOnline() {
        if (!this.isOffline()) {
            return false;
        }
        this.updateOnCommunicationSuccess();
        return true;
    }

    public synchronized void updateOnCommunicationSuccess() {
        this.recordingOfflineStatus = false;
        this.failureCount = 0;
    }

    public synchronized int getFailureCount() {
        return this.failureCount;
    }

    public String toString() {
        return "OfflineStatus{takeOffline=" + this.takeOffline + ", recordingOfflineStatus=" + this.recordingOfflineStatus + ", firstFailureTime=" + this.firstFailureTime + ", failureCount=" + this.failureCount + '}';
    }
}

