/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ModClusterRemoveMetric
implements OperationStepHandler {
    static final ModClusterRemoveMetric INSTANCE = new ModClusterRemoveMetric();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress parent = PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.SUBSYSTEM_PATH, ModClusterExtension.CONFIGURATION_PATH, ModClusterExtension.DYNAMIC_LOAD_PROVIDER});
        String type = LoadMetricDefinition.TYPE.resolveModelAttribute(context, operation).asString();
        String name = this.getMetricName(context, type);
        if (name == null) {
            context.setRollbackOnly();
            return;
        }
        ModelNode targetOperation = Util.createRemoveOperation((PathAddress)parent.append(new PathElement[]{PathElement.pathElement((String)ModClusterExtension.LOAD_METRIC.getKey(), (String)name)}));
        context.addStep(targetOperation, (OperationStepHandler)new ReloadRequiredRemoveStepHandler(), OperationContext.Stage.IMMEDIATE);
        context.stepCompleted();
    }

    private String getMetricName(OperationContext context, String type) {
        ModelNode loadProvider = context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.DYNAMIC_LOAD_PROVIDER})).getModel();
        ModelNode loadMetrics = loadProvider.get("load-metric");
        for (Property p : loadMetrics.asPropertyList()) {
            String metricType = p.getValue().get("type").asString();
            if (!metricType.equals(type)) continue;
            return p.getName();
        }
        return null;
    }
}

