/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Engine;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.jboss.as.modcluster.ModCluster;
import org.jboss.as.modcluster.ModClusterLogger;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.web.WebServer;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.CatalinaEventHandlerAdapter;
import org.jboss.modcluster.container.catalina.CatalinaFactory;
import org.jboss.modcluster.container.catalina.ProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.ServerProvider;
import org.jboss.modcluster.container.catalina.ServiceLoaderCatalinaFactory;
import org.jboss.modcluster.container.catalina.SimpleProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.SimpleServerProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class ModClusterService
implements Service<ModCluster>,
ModCluster {
    static final ServiceName NAME = ServiceName.JBOSS.append(new String[]{"mod-cluster"});
    private CatalinaEventHandlerAdapter adapter;
    private LoadBalanceFactorProvider load;
    private ModClusterConfig config;
    private final InjectedValue<WebServer> webServer = new InjectedValue();
    private final InjectedValue<SocketBindingManager> bindingManager = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<Connector> connector = new InjectedValue();
    private org.jboss.modcluster.ModClusterService service;

    ModClusterService(ModClusterConfig config, LoadBalanceFactorProvider load) {
        this.config = config;
        this.load = load;
    }

    public void start(StartContext context) {
        SocketBinding binding;
        ModClusterLogger.ROOT_LOGGER.debugf("Starting Mod_cluster Extension", new Object[0]);
        boolean isMulticast = this.isMulticastEnabled(((SocketBindingManager)this.bindingManager.getValue()).getDefaultInterfaceBinding().getNetworkInterfaces());
        if (this.config.getProxies().isEmpty()) {
            this.config.setAdvertise(Boolean.valueOf(isMulticast));
        }
        if (this.config.getAdvertise().booleanValue() && (binding = (SocketBinding)this.binding.getValue()) != null) {
            this.config.setAdvertiseSocketAddress(binding.getMulticastSocketAddress());
            this.config.setAdvertiseInterface(binding.getSocketAddress().getAddress());
            if (!isMulticast) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
        }
        this.service = new org.jboss.modcluster.ModClusterService(this.config, this.load);
        WebServer webServer = (WebServer)this.webServer.getValue();
        SimpleServerProvider serverProvider = new SimpleServerProvider((Server)webServer.getServer());
        SimpleProxyConnectorProvider connectorProvider = new SimpleProxyConnectorProvider((Connector)this.connector.getValue());
        ServiceLoaderCatalinaFactory factory = new ServiceLoaderCatalinaFactory((ProxyConnectorProvider)connectorProvider);
        this.adapter = new CatalinaEventHandlerAdapter((ContainerEventHandler)this.service, (ServerProvider)serverProvider, (CatalinaFactory)factory);
        this.adapter.start();
        Engine engine = (Engine)webServer.getService().getContainer();
        this.service.status(factory.createEngine(engine));
    }

    private boolean isMulticastEnabled(Collection<NetworkInterface> ifaces) {
        for (NetworkInterface iface : ifaces) {
            try {
                if (!iface.isUp() || !iface.supportsMulticast() && !iface.isLoopback()) continue;
                return true;
            }
            catch (SocketException e) {
            }
        }
        return false;
    }

    public void stop(StopContext context) {
        if (this.adapter != null) {
            this.adapter.stop();
            this.adapter = null;
        }
    }

    public synchronized ModCluster getValue() {
        return this;
    }

    public Injector<WebServer> getWebServer() {
        return this.webServer;
    }

    public Injector<SocketBinding> getBinding() {
        return this.binding;
    }

    public Injector<SocketBindingManager> getBindingManager() {
        return this.bindingManager;
    }

    public Injector<Connector> getConnectorInjector() {
        return this.connector;
    }

    @Override
    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.service.getProxyInfo();
    }

    @Override
    public void refresh() {
        this.service.refresh();
    }

    @Override
    public void reset() {
        this.service.reset();
    }

    @Override
    public void enable() {
        this.service.enable();
    }

    @Override
    public void disable() {
        this.service.disable();
    }

    @Override
    public void stop(int waittime) {
        this.service.stop((long)waittime, TimeUnit.SECONDS);
    }

    @Override
    public boolean enableContext(String host, String context) {
        return this.service.enableContext(host, context);
    }

    @Override
    public boolean disableContext(String host, String context) {
        return this.service.disableContext(host, context);
    }

    @Override
    public boolean stopContext(String host, String context, int waittime) {
        return this.service.stopContext(host, context, (long)waittime, TimeUnit.SECONDS);
    }

    @Override
    public void addProxy(String host, int port) {
        this.service.addProxy(host, port);
    }

    @Override
    public void removeProxy(String host, int port) {
        this.service.removeProxy(host, port);
    }

    @Override
    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.service.getProxyConfiguration();
    }
}

