/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.modcluster.Attribute;
import org.jboss.as.modcluster.CustomLoadMetricDefinition;
import org.jboss.as.modcluster.DynamicLoadProviderDefinition;
import org.jboss.as.modcluster.Element;
import org.jboss.as.modcluster.LoadMetricDefinition;
import org.jboss.as.modcluster.ModClusterConfigResourceDefinition;
import org.jboss.as.modcluster.ModClusterExtension;
import org.jboss.as.modcluster.ModClusterSSLResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ModClusterSubsystemXMLReader_1_0
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{ModClusterExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address.toModelNode());
        list.add(subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MOD_CLUSTER_CONFIG: {
                    this.parseModClusterConfig(reader, list, address);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseModClusterConfig(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        PathAddress address = parent.append(new PathElement[]{ModClusterExtension.CONFIGURATION_PATH});
        ModelNode config = Util.createAddOperation((PathAddress)address);
        list.add(config);
        this.parsePropConf(reader, config);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SIMPLE_LOAD_PROVIDER: {
                    this.parseSimpleLoadProvider(reader, config);
                    continue block5;
                }
                case DYNAMIC_LOAD_PROVIDER: {
                    this.parseDynamicLoadProvider(reader, list, address);
                    continue block5;
                }
                case SSL: {
                    this.parseSSL(reader, list, address);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parsePropConf(XMLExtendedStreamReader reader, ModelNode conf) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ADVERTISE_SOCKET: 
                case PROXY_LIST: 
                case PROXY_URL: 
                case ADVERTISE: 
                case ADVERTISE_SECURITY_KEY: 
                case EXCLUDED_CONTEXTS: 
                case AUTO_ENABLE_CONTEXTS: 
                case STOP_CONTEXT_TIMEOUT: 
                case SOCKET_TIMEOUT: 
                case STICKY_SESSION: 
                case STICKY_SESSION_REMOVE: 
                case STICKY_SESSION_FORCE: 
                case WORKER_TIMEOUT: 
                case MAX_ATTEMPTS: 
                case FLUSH_PACKETS: 
                case FLUSH_WAIT: 
                case PING: 
                case SMAX: 
                case TTL: 
                case NODE_TIMEOUT: 
                case BALANCER: {
                    ModClusterConfigResourceDefinition.ATTRIBUTES_BY_NAME.get(attribute.getLocalName()).parseAndSetParameter(value, conf, (XMLStreamReader)reader);
                    continue block4;
                }
                case DOMAIN: {
                    ModClusterConfigResourceDefinition.LOAD_BALANCING_GROUP.parseAndSetParameter(value, conf, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModClusterConfigResourceDefinition.CONNECTOR.parseAndSetParameter("ajp", conf, (XMLStreamReader)reader);
    }

    void parseSSL(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        PathAddress address = parent.append(new PathElement[]{ModClusterExtension.SSL_CONFIGURATION_PATH});
        ModelNode ssl = Util.createAddOperation((PathAddress)address);
        list.add(ssl);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_ALIAS: 
                case PASSWORD: 
                case CERTIFICATE_KEY_FILE: 
                case CIPHER_SUITE: 
                case PROTOCOL: 
                case CA_CERTIFICATE_FILE: 
                case CA_REVOCATION_URL: {
                    ModClusterSSLResourceDefinition.ATTRIBUTES_BY_NAME.get(attribute.getLocalName()).parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void parseSimpleLoadProvider(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTOR: {
                    ModClusterConfigResourceDefinition.SIMPLE_LOAD_PROVIDER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void parseDynamicLoadProvider(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress parent) throws XMLStreamException {
        PathAddress address = parent.append(new PathElement[]{ModClusterExtension.DYNAMIC_LOAD_PROVIDER});
        ModelNode load = Util.createAddOperation((PathAddress)address);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HISTORY: {
                    DynamicLoadProviderDefinition.HISTORY.parseAndSetParameter(value, load, (XMLStreamReader)reader);
                    continue block8;
                }
                case DECAY: {
                    DynamicLoadProviderDefinition.DECAY.parseAndSetParameter(value, load, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(load);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOAD_METRIC: {
                    this.parseLoadMetric(reader, list, address);
                    continue block9;
                }
                case CUSTOM_LOAD_METRIC: {
                    this.parseCustomLoadMetric(reader, list, address);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseLoadMetric(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress address) throws XMLStreamException {
        ModelNode metric = new ModelNode();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    LoadMetricDefinition.TYPE.parseAndSetParameter(value, metric, (XMLStreamReader)reader);
                    continue block5;
                }
                case CAPACITY: {
                    LoadMetricDefinition.CAPACITY.parseAndSetParameter(value, metric, (XMLStreamReader)reader);
                    continue block5;
                }
                case WEIGHT: {
                    LoadMetricDefinition.WEIGHT.parseAndSetParameter(value, metric, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathElement pe = PathElement.pathElement((String)ModClusterExtension.LOAD_METRIC.getKey(), (String)metric.get("type").asString());
        metric.get("operation").set("add");
        metric.get("address").set(address.append(new PathElement[]{pe}).toModelNode());
        ModClusterSubsystemXMLReader_1_0.readProperties(reader, metric);
        list.add(metric);
    }

    static void readProperties(XMLExtendedStreamReader reader, ModelNode metric) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Property property = ParseUtils.readProperty((XMLExtendedStreamReader)reader);
                    metric.get("property").get(property.getName()).set(property.getValue());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseCustomLoadMetric(XMLExtendedStreamReader reader, List<ModelNode> list, PathAddress address) throws XMLStreamException {
        ModelNode customMetric = new ModelNode();
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CAPACITY: {
                    LoadMetricDefinition.CAPACITY.parseAndSetParameter(value, customMetric, (XMLStreamReader)reader);
                    continue block5;
                }
                case WEIGHT: {
                    LoadMetricDefinition.WEIGHT.parseAndSetParameter(value, customMetric, (XMLStreamReader)reader);
                    continue block5;
                }
                case CLASS: {
                    CustomLoadMetricDefinition.CLASS.parseAndSetParameter(value, customMetric, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        PathElement pe = PathElement.pathElement((String)ModClusterExtension.CUSTOM_LOAD_METRIC.getKey(), (String)customMetric.get("class").asString());
        customMetric.get("operation").set("add");
        customMetric.get("address").set(address.append(new PathElement[]{pe}).toModelNode());
        ModClusterSubsystemXMLReader_1_0.readProperties(reader, customMetric);
        list.add(customMetric);
    }
}

