/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.hornetq.core.server.HornetQLogger;

final class ClientSessionPacketHandler
implements ChannelHandler {
    private final ClientSessionInternal clientSession;
    private final Channel channel;

    ClientSessionPacketHandler(ClientSessionInternal clientSesssion, Channel channel) {
        this.clientSession = clientSesssion;
        this.channel = channel;
    }

    @Override
    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        try {
            switch (type) {
                case 77: {
                    SessionReceiveContinuationMessage continuation = (SessionReceiveContinuationMessage)packet;
                    this.clientSession.handleReceiveContinuation(continuation.getConsumerID(), continuation);
                    break;
                }
                case 75: {
                    SessionReceiveMessage message = (SessionReceiveMessage)packet;
                    this.clientSession.handleReceiveMessage(message.getConsumerID(), message);
                    break;
                }
                case 76: {
                    SessionReceiveLargeMessage message = (SessionReceiveLargeMessage)packet;
                    this.clientSession.handleReceiveLargeMessage(message.getConsumerID(), message);
                    break;
                }
                case 80: {
                    SessionProducerCreditsMessage message = (SessionProducerCreditsMessage)packet;
                    this.clientSession.handleReceiveProducerCredits(message.getAddress(), message.getCredits());
                    break;
                }
                case 82: {
                    SessionProducerCreditsFailMessage message = (SessionProducerCreditsFailMessage)packet;
                    this.clientSession.handleReceiveProducerFailCredits(message.getAddress(), message.getCredits());
                    break;
                }
                case 20: {
                    HornetQExceptionMessage mem = (HornetQExceptionMessage)packet;
                    HornetQLogger.LOGGER.receivedExceptionAsynchronously((Exception)((Object)mem.getException()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid packet: " + type);
                }
            }
        }
        catch (Exception e) {
            HornetQLogger.LOGGER.failedToHandlePacket(e);
        }
        this.channel.confirm(packet);
    }
}

