/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.FileConfigurationParser;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;

public class QueueDeployer
extends XmlDeployer {
    private final HornetQServer server;
    private final FileConfigurationParser parser = new FileConfigurationParser();

    public QueueDeployer(DeploymentManager deploymentManager, HornetQServer server) {
        super(deploymentManager);
        this.server = server;
    }

    @Override
    public String[] getElementTagName() {
        return new String[]{"queue"};
    }

    @Override
    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-configuration.xsd");
    }

    @Override
    public void deploy(Node node) throws Exception {
        CoreQueueConfiguration queueConfig = this.parser.parseQueueConfiguration(node);
        this.server.deployQueue(SimpleString.toSimpleString((String)queueConfig.getAddress()), SimpleString.toSimpleString((String)queueConfig.getName()), SimpleString.toSimpleString((String)queueConfig.getFilterString()), queueConfig.isDurable(), false);
    }

    @Override
    public void undeploy(Node node) throws Exception {
    }

    @Override
    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-configuration.xml", "hornetq-queues.xml"};
    }
}

