/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.deployers.impl;

import java.util.Set;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.FileConfigurationParser;
import org.hornetq.core.deployers.impl.XmlDeployer;
import org.hornetq.core.security.Role;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.utils.Pair;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Node;

public class SecurityDeployer
extends XmlDeployer {
    private static final String QUEUES_XML = "hornetq-queues.xml";
    private static final String MATCH = "match";
    private final FileConfigurationParser parser = new FileConfigurationParser();
    private final HierarchicalRepository<Set<Role>> securityRepository;

    public SecurityDeployer(DeploymentManager deploymentManager, HierarchicalRepository<Set<Role>> securityRepository) {
        super(deploymentManager);
        this.securityRepository = securityRepository;
    }

    @Override
    public String[] getElementTagName() {
        return new String[]{"security-setting"};
    }

    @Override
    public void validate(Node rootNode) throws Exception {
        XMLUtil.validate(rootNode, "schema/hornetq-configuration.xsd");
    }

    @Override
    public String getKeyAttribute() {
        return MATCH;
    }

    @Override
    public void deploy(Node node) throws Exception {
        Pair<String, Set<Role>> securityMatch = this.parser.parseSecurityRoles(node);
        this.securityRepository.addMatch((String)securityMatch.getA(), (Set<Role>)securityMatch.getB());
    }

    @Override
    public void undeploy(Node node) throws Exception {
        String match = node.getAttributes().getNamedItem(this.getKeyAttribute()).getNodeValue();
        this.securityRepository.removeMatch(match);
    }

    @Override
    public String[] getDefaultConfigFileNames() {
        return new String[]{"hornetq-configuration.xml", QUEUES_XML};
    }
}

