/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.Message;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PagedReference;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.transaction.Transaction;

public class PagedReferenceImpl
implements PagedReference {
    private static final boolean isTrace = HornetQLogger.LOGGER.isTraceEnabled();
    private final PagePosition position;
    private WeakReference<PagedMessage> message;
    private Long deliveryTime = null;
    private int persistedCount;
    private int messageEstimate;
    private final AtomicInteger deliveryCount = new AtomicInteger(0);
    private final PageSubscription subscription;

    @Override
    public ServerMessage getMessage() {
        return this.getPagedMessage().getMessage();
    }

    @Override
    public synchronized PagedMessage getPagedMessage() {
        PagedMessage returnMessage;
        PagedMessage pagedMessage = returnMessage = this.message != null ? (PagedMessage)this.message.get() : null;
        if (returnMessage == null) {
            returnMessage = this.subscription.queryMessage(this.position);
            this.message = new WeakReference<PagedMessage>(returnMessage);
        }
        return returnMessage;
    }

    @Override
    public PagePosition getPosition() {
        return this.position;
    }

    public PagedReferenceImpl(PagePosition position, PagedMessage message, PageSubscription subscription) {
        this.position = position;
        this.messageEstimate = message == null ? -1 : message.getMessage().getMemoryEstimate();
        this.message = new WeakReference<PagedMessage>(message);
        this.subscription = subscription;
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public void setPersistedCount(int count) {
        this.persistedCount = count;
    }

    @Override
    public int getPersistedCount() {
        return this.persistedCount;
    }

    @Override
    public int getMessageMemoryEstimate() {
        if (this.messageEstimate < 0) {
            this.messageEstimate = this.getMessage().getMemoryEstimate();
        }
        return this.messageEstimate;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return new PagedReferenceImpl(this.position, this.getPagedMessage(), this.subscription);
    }

    @Override
    public long getScheduledDeliveryTime() {
        if (this.deliveryTime == null) {
            ServerMessage msg = this.getMessage();
            this.deliveryTime = msg.containsProperty(Message.HDR_SCHEDULED_DELIVERY_TIME) ? this.getMessage().getLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME) : Long.valueOf(0L);
        }
        return this.deliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.deliveryTime = scheduledDeliveryTime;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount.get();
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount.set(deliveryCount);
    }

    @Override
    public void incrementDeliveryCount() {
        this.deliveryCount.incrementAndGet();
        if (isTrace) {
            HornetQLogger.LOGGER.trace("++deliveryCount = " + this.deliveryCount + " for " + this, new Exception("trace"));
        }
    }

    @Override
    public void decrementDeliveryCount() {
        this.deliveryCount.decrementAndGet();
        if (isTrace) {
            HornetQLogger.LOGGER.trace("--deliveryCount = " + this.deliveryCount + " for " + this, new Exception("trace"));
        }
    }

    @Override
    public Queue getQueue() {
        return this.subscription.getQueue();
    }

    @Override
    public void handled() {
        this.getQueue().referenceHandled();
    }

    @Override
    public void acknowledge() throws Exception {
        this.subscription.ack(this);
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.subscription.ackTx(tx, this);
    }

    public String toString() {
        return "PagedReferenceImpl [position=" + this.position + ", message=" + this.getPagedMessage() + ", deliveryTime=" + this.deliveryTime + ", persistedCount=" + this.persistedCount + ", deliveryCount=" + this.deliveryCount + ", subscription=" + this.subscription + "]";
    }
}

