/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PageCache;
import org.hornetq.core.paging.cursor.PageCursorProvider;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PagedReference;
import org.hornetq.core.paging.cursor.PagedReferenceImpl;
import org.hornetq.core.paging.cursor.impl.PageCacheImpl;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.cursor.impl.PageSubscriptionImpl;
import org.hornetq.core.paging.impl.Page;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.utils.FutureLatch;
import org.hornetq.utils.SoftValueHashMap;

public class PageCursorProviderImpl
implements PageCursorProvider {
    boolean isTrace = HornetQLogger.LOGGER.isTraceEnabled();
    private final PagingStore pagingStore;
    private final StorageManager storageManager;
    private final Executor executor;
    private final SoftValueHashMap<Long, PageCache> softCache;
    private final ConcurrentMap<Long, PageSubscription> activeCursors = new ConcurrentHashMap<Long, PageSubscription>();

    public PageCursorProviderImpl(PagingStore pagingStore, StorageManager storageManager, Executor executor, int maxCacheSize) {
        this.pagingStore = pagingStore;
        this.storageManager = storageManager;
        this.executor = executor;
        this.softCache = new SoftValueHashMap(maxCacheSize);
    }

    @Override
    public PagingStore getAssociatedStore() {
        return this.pagingStore;
    }

    @Override
    public synchronized PageSubscription createSubscription(long cursorID, Filter filter, boolean persistent) {
        if (HornetQLogger.LOGGER.isDebugEnabled()) {
            HornetQLogger.LOGGER.debug(this.pagingStore.getAddress() + " creating subscription " + cursorID + " with filter " + filter, new Exception("trace"));
        }
        if (this.activeCursors.containsKey(cursorID)) {
            throw new IllegalStateException("Cursor " + cursorID + " had already been created");
        }
        PageSubscriptionImpl activeCursor = new PageSubscriptionImpl(this, this.pagingStore, this.storageManager, this.executor, filter, cursorID, persistent);
        this.activeCursors.put(cursorID, activeCursor);
        return activeCursor;
    }

    @Override
    public synchronized PageSubscription getSubscription(long cursorID) {
        return (PageSubscription)this.activeCursors.get(cursorID);
    }

    @Override
    public PagedMessage getMessage(PagePosition pos) throws Exception {
        PageCache cache = this.getPageCache(pos);
        if (pos.getMessageNr() >= cache.getNumberOfMessages()) {
            throw new IllegalStateException("Invalid messageNumber passed = " + pos + " on " + cache);
        }
        return cache.getMessage(pos.getMessageNr());
    }

    @Override
    public PagedReference newReference(PagePosition pos, PagedMessage msg, PageSubscription subscription) {
        return new PagedReferenceImpl(pos, msg, subscription);
    }

    @Override
    public PageCache getPageCache(PagePosition pos) {
        return this.getPageCache(pos.getPageNr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageCache getPageCache(long pageId) {
        try {
            boolean needToRead = false;
            PageCache cache = null;
            SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
            synchronized (softValueHashMap) {
                if (pageId > (long)this.pagingStore.getCurrentWritingPage()) {
                    return null;
                }
                cache = (PageCache)this.softCache.get(pageId);
                if (cache == null) {
                    if (!this.pagingStore.checkPageFileExists((int)pageId)) {
                        return null;
                    }
                    cache = this.createPageCache(pageId);
                    needToRead = true;
                    cache.lock();
                    if (this.isTrace) {
                        HornetQLogger.LOGGER.trace("adding " + pageId + " into cursor = " + this.pagingStore.getAddress());
                    }
                    this.softCache.put(pageId, cache);
                }
            }
            if (needToRead) {
                Page page = null;
                try {
                    page = this.pagingStore.createPage((int)pageId);
                    this.storageManager.beforePageRead();
                    page.open();
                    List<PagedMessage> pgdMessages = page.read(this.storageManager);
                    cache.setMessages(pgdMessages.toArray(new PagedMessage[pgdMessages.size()]));
                }
                finally {
                    try {
                        if (page != null) {
                            page.close();
                        }
                    }
                    catch (Throwable ignored) {}
                    this.storageManager.afterPageRead();
                    cache.unlock();
                }
            }
            return cache;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't complete paging due to an IO Exception on Paging - " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPageCache(PageCache cache) {
        SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
        synchronized (softValueHashMap) {
            this.softCache.put(cache.getPageId(), cache);
        }
    }

    @Override
    public int getCacheMaxSize() {
        return this.softCache.getMaxEelements();
    }

    @Override
    public void setCacheMaxSize(int size) {
        this.softCache.setMaxElements(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSize() {
        SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
        synchronized (softValueHashMap) {
            return this.softCache.size();
        }
    }

    @Override
    public void processReload() throws Exception {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.processReload();
        }
        this.cleanup();
    }

    @Override
    public void stop() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.stop();
        }
        this.waitForFuture();
    }

    private void waitForFuture() {
        FutureLatch future = new FutureLatch();
        this.executor.execute(future);
        while (!future.await(10000L)) {
            HornetQLogger.LOGGER.timedOutStoppingPagingCursor(future, this.executor);
        }
    }

    @Override
    public void flushExecutors() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.flushExecutors();
        }
        this.waitForFuture();
    }

    @Override
    public void close(PageSubscription cursor) {
        this.activeCursors.remove(cursor.getId());
        this.scheduleCleanup();
    }

    @Override
    public void scheduleCleanup() {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PageCursorProviderImpl.this.storageManager.setContext(PageCursorProviderImpl.this.storageManager.newSingleThreadContext());
                try {
                    PageCursorProviderImpl.this.cleanup();
                }
                finally {
                    PageCursorProviderImpl.this.storageManager.clearContext();
                }
            }

            public String toString() {
                return "PageCursorProvider:scheduleCleanup()";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanup() {
        block42: {
            depagedPages = new ArrayList<Page>();
            do {
                if (!this.pagingStore.lock(100L)) continue;
                var2_2 = this;
                synchronized (var2_2) {
                    try {
                        if (!this.pagingStore.isStarted()) {
                            return;
                        }
                        if (this.pagingStore.getNumberOfPages() == 0) {
                            return;
                        }
                        if (HornetQLogger.LOGGER.isDebugEnabled()) {
                            HornetQLogger.LOGGER.debug("Asserting cleanup for address " + this.pagingStore.getAddress());
                        }
                        if ((minPage = this.checkMinPage(cursorList = this.cloneSubscriptions())) == (long)this.pagingStore.getCurrentWritingPage() && this.pagingStore.getCurrentPage().getNumberOfMessages() > 0) {
                            complete = true;
                            for (PageSubscription cursor : cursorList) {
                                if (!cursor.isComplete(minPage)) {
                                    if (HornetQLogger.LOGGER.isDebugEnabled()) {
                                        HornetQLogger.LOGGER.debug("Cursor " + cursor + " was considered incomplete at page " + minPage);
                                    }
                                    complete = false;
                                    break;
                                }
                                if (!HornetQLogger.LOGGER.isDebugEnabled()) continue;
                                HornetQLogger.LOGGER.debug("Cursor " + cursor + "was considered **complete** at page " + minPage);
                            }
                            if (!this.pagingStore.isStarted()) {
                                return;
                            }
                            if (complete) {
                                if (HornetQLogger.LOGGER.isDebugEnabled()) {
                                    HornetQLogger.LOGGER.debug("Address " + this.pagingStore.getAddress() + " is leaving page mode as all messages are consumed and acknowledged from the page store");
                                }
                                this.pagingStore.forceAnotherPage();
                                currentPage = this.pagingStore.getCurrentPage();
                                this.storeBookmark(cursorList, currentPage);
                                this.pagingStore.stopPaging();
                                for (PageSubscription cursor : cursorList) {
                                    cursor.scheduleCleanupCheck();
                                }
                            }
                        }
                        for (i = this.pagingStore.getFirstPage(); i < minPage && (page = this.pagingStore.depage()) != null; ++i) {
                            depagedPages.add(page);
                        }
                        if (this.pagingStore.getNumberOfPages() == 0 || this.pagingStore.getNumberOfPages() == 1 && this.pagingStore.getCurrentPage().getNumberOfMessages() == 0) {
                            this.pagingStore.stopPaging();
                            break block42;
                        }
                        if (HornetQLogger.LOGGER.isTraceEnabled()) {
                            HornetQLogger.LOGGER.trace("Couldn't cleanup page on address " + this.pagingStore.getAddress() + " as numberOfPages == " + this.pagingStore.getNumberOfPages() + " and currentPage.numberOfMessages = " + this.pagingStore.getCurrentPage().getNumberOfMessages());
                        }
                        break block42;
                    }
                    catch (Exception ex) {
                        HornetQLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
                        return;
                    }
                }
            } while (this.pagingStore.isStarted());
            return;
            {
                finally {
                    this.pagingStore.unlock();
                }
            }
        }
        try {
            for (Page depagedPage : depagedPages) {
                i = this.softCache;
                synchronized (i) {
                    cache = (PageCache)this.softCache.get(depagedPage.getPageId());
                    ** if (!this.isTrace) goto lbl62
                }
lbl-1000:
                // 1 sources

                {
                    HornetQLogger.LOGGER.trace("Removing page " + depagedPage.getPageId() + " from page-cache");
                }
lbl62:
                // 2 sources

                if (cache == null) {
                    this.storageManager.beforePageRead();
                    pgdMessagesList = null;
                    try {
                        depagedPage.open();
                        pgdMessagesList = depagedPage.read(this.storageManager);
                    }
                    finally {
                        try {
                            depagedPage.close();
                        }
                        catch (Exception e) {}
                        this.storageManager.afterPageRead();
                    }
                    depagedPage.close();
                    pgdMessages = pgdMessagesList.toArray(new PagedMessage[pgdMessagesList.size()]);
                } else {
                    pgdMessages = cache.getMessages();
                }
                depagedPage.delete(pgdMessages);
                this.onDeletePage(depagedPage);
                var6_10 = this.softCache;
                synchronized (var6_10) {
                    this.softCache.remove(depagedPage.getPageId());
                }
            }
            return;
        }
        catch (Exception ex) {
            HornetQLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
            return;
        }
    }

    private synchronized ArrayList<PageSubscription> cloneSubscriptions() {
        ArrayList<PageSubscription> cursorList = new ArrayList<PageSubscription>();
        cursorList.addAll(this.activeCursors.values());
        return cursorList;
    }

    protected void onDeletePage(Page deletedPage) throws Exception {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        for (PageSubscription subs : subscriptions) {
            subs.onDeletePage(deletedPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBookmark(ArrayList<PageSubscription> cursorList, Page currentPage) throws Exception {
        try {
            for (PageSubscription cursor : cursorList) {
                cursor.confirmPosition(new PagePositionImpl(currentPage.getPageId(), -1));
            }
            while (!this.storageManager.waitOnOperations(5000L)) {
                HornetQLogger.LOGGER.problemCompletingOperations(this.storageManager.getContext());
            }
        }
        finally {
            for (PageSubscription cursor : cursorList) {
                cursor.enableAutoCleanup();
            }
        }
    }

    @Override
    public void printDebug() {
        System.out.println("Debug information for PageCursorProviderImpl:");
        for (PageCache cache : this.softCache.values()) {
            System.out.println("Cache " + cache);
        }
    }

    protected PageCacheImpl createPageCache(long pageId) throws Exception {
        return new PageCacheImpl(this.pagingStore.createPage((int)pageId));
    }

    private long checkMinPage(List<PageSubscription> cursorList) {
        long minPage = Long.MAX_VALUE;
        for (PageSubscription cursor : cursorList) {
            long firstPage = cursor.getFirstPage();
            if (HornetQLogger.LOGGER.isDebugEnabled()) {
                HornetQLogger.LOGGER.debug(this.pagingStore.getAddress() + " has a cursor " + cursor + " with first page=" + firstPage);
            }
            if (firstPage >= minPage) continue;
            minPage = firstPage;
        }
        if (HornetQLogger.LOGGER.isDebugEnabled()) {
            HornetQLogger.LOGGER.debug(this.pagingStore.getAddress() + " has minPage=" + minPage);
        }
        return minPage;
    }
}

