/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperationAbstract;
import org.hornetq.utils.Pair;

public class PageTransactionInfoImpl
implements PageTransactionInfo {
    private long transactionID;
    private volatile long recordID = -1L;
    private volatile boolean committed = false;
    private volatile boolean useRedelivery = false;
    private volatile boolean rolledback = false;
    private final AtomicInteger numberOfMessages = new AtomicInteger(0);
    private final AtomicInteger numberOfPersistentMessages = new AtomicInteger(0);
    private List<Pair<PageSubscription, PagePosition>> lateDeliveries;

    public PageTransactionInfoImpl(long transactionID) {
        this();
        this.transactionID = transactionID;
    }

    public PageTransactionInfoImpl() {
    }

    @Override
    public long getRecordID() {
        return this.recordID;
    }

    @Override
    public void setRecordID(long recordID) {
        this.recordID = recordID;
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public void onUpdate(int update, StorageManager storageManager, PagingManager pagingManager) {
        int sizeAfterUpdate = this.numberOfMessages.addAndGet(-update);
        if (sizeAfterUpdate == 0 && storageManager != null) {
            try {
                storageManager.deletePageTransactional(this.recordID);
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.pageTxDeleteError(e, this.recordID);
            }
            pagingManager.removeTransaction(this.transactionID);
        }
    }

    @Override
    public void increment(boolean persistent) {
        if (persistent) {
            this.numberOfPersistentMessages.incrementAndGet();
        }
        this.numberOfMessages.incrementAndGet();
    }

    @Override
    public void increment(int durableSize, int nonDurableSize) {
        this.numberOfPersistentMessages.addAndGet(durableSize);
        this.numberOfMessages.addAndGet(durableSize + nonDurableSize);
    }

    @Override
    public int getNumberOfMessages() {
        return this.numberOfMessages.get();
    }

    public synchronized void decode(HornetQBuffer buffer) {
        this.transactionID = buffer.readLong();
        this.numberOfMessages.set(buffer.readInt());
        this.numberOfPersistentMessages.set(this.numberOfMessages.get());
        this.committed = true;
    }

    public synchronized void encode(HornetQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        buffer.writeInt(this.numberOfPersistentMessages.get());
    }

    public synchronized int getEncodeSize() {
        return 12;
    }

    @Override
    public synchronized void commit() {
        if (this.lateDeliveries != null) {
            for (Pair<PageSubscription, PagePosition> pos : this.lateDeliveries) {
                ((PageSubscription)pos.getA()).redeliver((PagePosition)pos.getB());
            }
            this.lateDeliveries.clear();
        }
        this.committed = true;
        this.lateDeliveries = null;
    }

    @Override
    public void store(StorageManager storageManager, PagingManager pagingManager, Transaction tx) throws Exception {
        storageManager.storePageTransaction(tx.getID(), this);
    }

    @Override
    public void storeUpdate(StorageManager storageManager, PagingManager pagingManager, Transaction tx) throws Exception {
        this.internalUpdatePageManager(storageManager, pagingManager, tx, 1);
    }

    @Override
    public void reloadUpdate(StorageManager storageManager, PagingManager pagingManager, Transaction tx, int increment) throws Exception {
        UpdatePageTXOperation updt = this.internalUpdatePageManager(storageManager, pagingManager, tx, increment);
        updt.setStored();
    }

    protected UpdatePageTXOperation internalUpdatePageManager(StorageManager storageManager, PagingManager pagingManager, Transaction tx, int increment) {
        UpdatePageTXOperation pgtxUpdate = (UpdatePageTXOperation)tx.getProperty(4);
        if (pgtxUpdate == null) {
            pgtxUpdate = new UpdatePageTXOperation(storageManager, pagingManager);
            tx.putProperty(4, pgtxUpdate);
            tx.addOperation(pgtxUpdate);
        }
        tx.setContainsPersistent();
        pgtxUpdate.addUpdate(this, increment);
        return pgtxUpdate;
    }

    @Override
    public void storeUpdate(final StorageManager storageManager, final PagingManager pagingManager) throws Exception {
        storageManager.updatePageTransaction(this, 1);
        storageManager.afterCompleteOperations(new IOAsyncTask(){

            public void onError(int errorCode, String errorMessage) {
            }

            public void done() {
                PageTransactionInfoImpl.this.onUpdate(1, storageManager, pagingManager);
            }
        });
    }

    @Override
    public boolean isCommit() {
        return this.committed;
    }

    @Override
    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public boolean isRollback() {
        return this.rolledback;
    }

    @Override
    public synchronized void rollback() {
        this.rolledback = true;
        this.committed = false;
        if (this.lateDeliveries != null) {
            for (Pair<PageSubscription, PagePosition> pos : this.lateDeliveries) {
                ((PageSubscription)pos.getA()).lateDeliveryRollback((PagePosition)pos.getB());
            }
            this.lateDeliveries = null;
        }
    }

    public String toString() {
        return "PageTransactionInfoImpl(transactionID=" + this.transactionID + ",id=" + this.recordID + ",numberOfMessages=" + this.numberOfMessages + ")";
    }

    @Override
    public synchronized boolean deliverAfterCommit(PageSubscription cursor, PagePosition cursorPos) {
        if (this.committed && this.useRedelivery) {
            cursor.addPendingDelivery(cursorPos);
            cursor.redeliver(cursorPos);
            return true;
        }
        if (this.committed) {
            return false;
        }
        if (this.rolledback) {
            cursor.positionIgnored(cursorPos);
            return true;
        }
        this.useRedelivery = true;
        if (this.lateDeliveries == null) {
            this.lateDeliveries = new LinkedList<Pair<PageSubscription, PagePosition>>();
        }
        cursor.addPendingDelivery(cursorPos);
        this.lateDeliveries.add((Pair<PageSubscription, PagePosition>)new Pair((Object)cursor, (Object)cursorPos));
        return true;
    }

    private static class UpdatePageTXOperation
    extends TransactionOperationAbstract {
        private final HashMap<PageTransactionInfo, AtomicInteger> countsToUpdate = new HashMap();
        private boolean stored = false;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;

        public UpdatePageTXOperation(StorageManager storageManager, PagingManager pagingManager) {
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        public void setStored() {
            this.stored = true;
        }

        public void addUpdate(PageTransactionInfo info, int increment) {
            AtomicInteger counter = this.countsToUpdate.get(info);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.countsToUpdate.put(info, counter);
            }
            counter.addAndGet(increment);
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.storeUpdates(tx);
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.storeUpdates(tx);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageTransactionInfo, AtomicInteger> entry : this.countsToUpdate.entrySet()) {
                entry.getKey().onUpdate(entry.getValue().intValue(), this.storageManager, this.pagingManager);
            }
        }

        private void storeUpdates(Transaction tx) throws Exception {
            if (!this.stored) {
                this.stored = true;
                for (Map.Entry<PageTransactionInfo, AtomicInteger> entry : this.countsToUpdate.entrySet()) {
                    this.storageManager.updatePageTransaction(tx.getID(), entry.getKey(), entry.getValue().get());
                }
            }
        }
    }
}

