/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.IOCompletion;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalReaderCallback;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PagedReferenceImpl;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.journal.BatchingIDGenerator;
import org.hornetq.core.persistence.impl.journal.LargeServerMessageImpl;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.replication.ReplicatedJournal;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RouteContextList;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.Base64;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.Pair;
import org.hornetq.utils.XidCodecSupport;

public class JournalStorageManager
implements StorageManager {
    private static final long CHECKPOINT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final byte GROUP_RECORD = 20;
    public static final byte QUEUE_BINDING_RECORD = 21;
    public static final byte ID_COUNTER_RECORD = 24;
    private static final byte ADDRESS_SETTING_RECORD = 25;
    private static final byte SECURITY_RECORD = 26;
    static final byte ADD_LARGE_MESSAGE_PENDING = 29;
    public static final byte ADD_LARGE_MESSAGE = 30;
    public static final byte ADD_MESSAGE = 31;
    public static final byte ADD_REF = 32;
    public static final byte ACKNOWLEDGE_REF = 33;
    public static final byte UPDATE_DELIVERY_COUNT = 34;
    public static final byte PAGE_TRANSACTION = 35;
    private static final byte SET_SCHEDULED_DELIVERY_TIME = 36;
    private static final byte DUPLICATE_ID = 37;
    private static final byte HEURISTIC_COMPLETION = 38;
    public static final byte ACKNOWLEDGE_CURSOR = 39;
    private static final byte PAGE_CURSOR_COUNTER_VALUE = 40;
    private static final byte PAGE_CURSOR_COUNTER_INC = 41;
    public static final byte PAGE_CURSOR_COMPLETE = 42;
    private final Semaphore pageMaxConcurrentIO;
    private final BatchingIDGenerator idGenerator;
    private final ReentrantReadWriteLock storageManagerLock = new ReentrantReadWriteLock(true);
    private ReplicationManager replicator;
    private final SequentialFileFactory journalFF;
    private Journal messageJournal;
    private Journal bindingsJournal;
    private final Journal originalMessageJournal;
    private final Journal originalBindingsJournal;
    private final SequentialFileFactory largeMessagesFactory;
    private volatile boolean started;
    private final ExecutorFactory executorFactory;
    private final Executor executor;
    private ExecutorService singleThreadExecutor;
    private final boolean syncTransactional;
    private final boolean syncNonTransactional;
    private final int perfBlastPages;
    private final boolean createBindingsDir;
    private final String bindingsDir;
    private final boolean createJournalDir;
    private final String journalDir;
    private final String largeMessagesDirectory;
    private boolean journalLoaded = false;
    private final Map<SimpleString, PersistedRoles> mapPersistedRoles = new ConcurrentHashMap<SimpleString, PersistedRoles>();
    private final Map<SimpleString, PersistedAddressSetting> mapPersistedAddressSettings = new ConcurrentHashMap<SimpleString, PersistedAddressSetting>();

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory, IOCriticalErrorListener criticalErrorListener) {
        this.executorFactory = executorFactory;
        this.executor = executorFactory.getExecutor();
        if (config.getJournalType() != JournalType.NIO && config.getJournalType() != JournalType.ASYNCIO) {
            throw HornetQMessageBundle.BUNDLE.invalidJournal();
        }
        this.bindingsDir = config.getBindingsDirectory();
        if (this.bindingsDir == null) {
            throw new NullPointerException("bindings-dir is null");
        }
        this.createBindingsDir = config.isCreateBindingsDir();
        this.journalDir = config.getJournalDirectory();
        NIOSequentialFileFactory bindingsFF = new NIOSequentialFileFactory(this.bindingsDir, criticalErrorListener);
        JournalImpl localBindings = new JournalImpl(0x100000, 2, config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), (SequentialFileFactory)bindingsFF, "hornetq-bindings", "bindings", 1);
        this.bindingsJournal = localBindings;
        this.originalBindingsJournal = localBindings;
        if (this.journalDir == null) {
            throw new NullPointerException("journal-dir is null");
        }
        this.createJournalDir = config.isCreateJournalDir();
        this.syncNonTransactional = config.isJournalSyncNonTransactional();
        this.syncTransactional = config.isJournalSyncTransactional();
        if (config.getJournalType() == JournalType.ASYNCIO) {
            HornetQLogger.LOGGER.journalUseAIO();
            this.journalFF = new AIOSequentialFileFactory(this.journalDir, config.getJournalBufferSize_AIO(), config.getJournalBufferTimeout_AIO(), config.isLogJournalWriteRate(), criticalErrorListener);
        } else if (config.getJournalType() == JournalType.NIO) {
            HornetQLogger.LOGGER.journalUseNIO();
            this.journalFF = new NIOSequentialFileFactory(this.journalDir, true, config.getJournalBufferSize_NIO(), config.getJournalBufferTimeout_NIO(), config.isLogJournalWriteRate(), criticalErrorListener);
        } else {
            throw HornetQMessageBundle.BUNDLE.invalidJournalType2(config.getJournalType());
        }
        this.idGenerator = new BatchingIDGenerator(0L, Integer.MAX_VALUE, this);
        JournalImpl localMessage = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), this.journalFF, "hornetq-data", "hq", config.getJournalType() == JournalType.ASYNCIO ? config.getJournalMaxIO_AIO() : config.getJournalMaxIO_NIO());
        this.messageJournal = localMessage;
        this.originalMessageJournal = localMessage;
        this.largeMessagesDirectory = config.getLargeMessagesDirectory();
        this.largeMessagesFactory = new NIOSequentialFileFactory(this.largeMessagesDirectory, false, criticalErrorListener);
        this.perfBlastPages = config.getJournalPerfBlastPages();
        this.pageMaxConcurrentIO = config.getPageMaxConcurrentIO() != 1 ? new Semaphore(config.getPageMaxConcurrentIO()) : null;
    }

    @Override
    public void clearContext() {
        OperationContextImpl.clearContext();
    }

    public boolean isReplicated() {
        return this.replicator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplication(ReplicationManager replicationManager, PagingManager pagingManager, String nodeID, boolean autoFailBack) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("JournalStorageManager must be started...");
        }
        assert (replicationManager != null);
        if (!(this.messageJournal instanceof JournalImpl) || !(this.bindingsJournal instanceof JournalImpl)) {
            throw HornetQMessageBundle.BUNDLE.notJournalImpl();
        }
        JournalFile[] messageFiles = null;
        JournalFile[] bindingsFiles = null;
        try {
            Map<String, Long> largeMessageFilesToSync;
            Map<SimpleString, Collection<Integer>> pageFilesToSync;
            this.storageManagerLock.writeLock().lock();
            try {
                if (this.isReplicated()) {
                    throw new HornetQIllegalStateException("already replicating");
                }
                this.replicator = replicationManager;
                this.originalMessageJournal.synchronizationLock();
                this.originalBindingsJournal.synchronizationLock();
                try {
                    pagingManager.lock();
                    try {
                        messageFiles = this.prepareJournalForCopy(this.originalMessageJournal, JournalContent.MESSAGES, nodeID, autoFailBack);
                        bindingsFiles = this.prepareJournalForCopy(this.originalBindingsJournal, JournalContent.BINDINGS, nodeID, autoFailBack);
                        pageFilesToSync = this.getPageInformationForSync(pagingManager);
                        largeMessageFilesToSync = this.getLargeMessageInformation();
                    }
                    finally {
                        pagingManager.unlock();
                    }
                }
                finally {
                    this.originalMessageJournal.synchronizationUnlock();
                    this.originalBindingsJournal.synchronizationUnlock();
                }
                this.bindingsJournal = new ReplicatedJournal(0, this.originalBindingsJournal, this.replicator);
                this.messageJournal = new ReplicatedJournal(1, this.originalMessageJournal, this.replicator);
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
            }
            this.sendJournalFile(messageFiles, JournalContent.MESSAGES);
            this.sendJournalFile(bindingsFiles, JournalContent.BINDINGS);
            this.sendLargeMessageFiles(largeMessageFilesToSync);
            this.sendPagesToBackup(pageFilesToSync, pagingManager);
            this.storageManagerLock.writeLock().lock();
            try {
                this.replicator.sendSynchronizationDone(nodeID);
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            this.stopReplication();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReplication() {
        this.storageManagerLock.writeLock().lock();
        try {
            if (this.replicator == null) {
                return;
            }
            this.bindingsJournal = this.originalBindingsJournal;
            this.messageJournal = this.originalMessageJournal;
            try {
                this.replicator.stop();
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.errorStoppingReplicationManager(e);
            }
            this.replicator = null;
        }
        finally {
            this.storageManagerLock.writeLock().unlock();
        }
    }

    private void sendPagesToBackup(Map<SimpleString, Collection<Integer>> pageFilesToSync, PagingManager manager) throws Exception {
        for (Map.Entry<SimpleString, Collection<Integer>> entry : pageFilesToSync.entrySet()) {
            if (!this.started) {
                return;
            }
            PagingStore store = manager.getPageStore(entry.getKey());
            store.sendPages(this.replicator, entry.getValue());
        }
    }

    private Map<SimpleString, Collection<Integer>> getPageInformationForSync(PagingManager pagingManager) throws Exception {
        HashMap<SimpleString, Collection<Integer>> info = new HashMap<SimpleString, Collection<Integer>>();
        for (SimpleString storeName : pagingManager.getStoreNames()) {
            PagingStore store = pagingManager.getPageStore(storeName);
            info.put(storeName, store.getCurrentIds());
            store.forceAnotherPage();
        }
        return info;
    }

    private void sendLargeMessageFiles(Map<String, Long> largeMessageFilesToSync) throws Exception {
        for (Map.Entry<String, Long> entry : largeMessageFilesToSync.entrySet()) {
            String fileName = entry.getKey();
            long size = entry.getValue();
            SequentialFile seqFile = this.largeMessagesFactory.createSequentialFile(fileName, 1);
            if (!seqFile.exists()) continue;
            if (!this.started) {
                return;
            }
            this.replicator.syncLargeMessageFile(seqFile, size, this.getLargeMessageIdFromFilename(fileName));
        }
    }

    private long getLargeMessageIdFromFilename(String filename) {
        return Long.parseLong(filename.split("\\.")[0]);
    }

    private Map<String, Long> getLargeMessageInformation() throws Exception {
        String prefix = "msg";
        HashMap<String, Long> largeMessages = new HashMap<String, Long>();
        List filenames = this.largeMessagesFactory.listFiles("msg");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String filename : filenames) {
            idList.add(Long.valueOf(filename.substring(0, filename.length() - ("msg".length() + 1))));
            SequentialFile seqFile = this.largeMessagesFactory.createSequentialFile(filename, 1);
            long size = seqFile.size();
            largeMessages.put(filename, size);
        }
        this.replicator.sendLargeMessageIdListMessage(idList);
        return largeMessages;
    }

    private void sendJournalFile(JournalFile[] journalFiles, JournalContent type) throws Exception {
        for (JournalFile jf : journalFiles) {
            if (!this.started) {
                return;
            }
            this.replicator.syncJournalFile(jf, type);
        }
    }

    private JournalFile[] prepareJournalForCopy(Journal journal, JournalContent contentType, String nodeID, boolean autoFailBack) throws Exception {
        journal.forceMoveNextFile();
        JournalFile[] datafiles = journal.getDataFiles();
        this.replicator.sendStartSyncMessage(datafiles, contentType, nodeID, autoFailBack);
        return datafiles;
    }

    @Override
    public final void waitOnOperations() throws Exception {
        if (!this.started) {
            HornetQLogger.LOGGER.serverIsStopped();
            throw new IllegalStateException("Server is stopped");
        }
        this.waitOnOperations(0L);
    }

    @Override
    public final boolean waitOnOperations(long timeout) throws Exception {
        if (!this.started) {
            HornetQLogger.LOGGER.serverIsStopped();
            throw new IllegalStateException("Server is stopped");
        }
        return this.getContext().waitCompletion(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pageClosed(SimpleString storeName, int pageNumber) {
        if (this.isReplicated()) {
            this.readLock();
            try {
                if (this.isReplicated()) {
                    this.replicator.pageClosed(storeName, pageNumber);
                }
            }
            finally {
                this.readUnLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pageDeleted(SimpleString storeName, int pageNumber) {
        if (this.isReplicated()) {
            this.readLock();
            try {
                if (this.isReplicated()) {
                    this.replicator.pageDeleted(storeName, pageNumber);
                }
            }
            finally {
                this.readUnLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pageWrite(PagedMessage message, int pageNumber) {
        if (this.isReplicated()) {
            if (!message.getMessage().isDurable()) {
                return;
            }
            this.readLock();
            try {
                if (this.isReplicated()) {
                    this.replicator.pageWrite(message, pageNumber);
                }
            }
            finally {
                this.readUnLock();
            }
        }
    }

    @Override
    public OperationContext getContext() {
        return OperationContextImpl.getContext(this.executorFactory);
    }

    @Override
    public void setContext(OperationContext context) {
        OperationContextImpl.setContext(context);
    }

    public Executor getSingleThreadExecutor() {
        return this.singleThreadExecutor;
    }

    @Override
    public OperationContext newSingleThreadContext() {
        return this.newContext(this.singleThreadExecutor);
    }

    @Override
    public OperationContext newContext(Executor executor) {
        return new OperationContextImpl(executor);
    }

    @Override
    public void afterCompleteOperations(IOAsyncTask run) {
        this.getContext().executeOnCompletion(run);
    }

    @Override
    public long generateUniqueID() {
        return this.idGenerator.generateID();
    }

    @Override
    public long getCurrentUniqueID() {
        return this.idGenerator.getCurrentID();
    }

    @Override
    public LargeServerMessage createLargeMessage() {
        return new LargeServerMessageImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addBytesToLargeMessage(SequentialFile file, long messageId, byte[] bytes) throws Exception {
        this.readLock();
        try {
            file.position(file.size());
            file.writeDirect(ByteBuffer.wrap(bytes), false);
            if (this.isReplicated()) {
                this.replicator.largeMessageWrite(messageId, bytes);
            }
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LargeServerMessage createLargeMessage(long id, MessageInternal message) throws Exception {
        this.readLock();
        try {
            if (this.isReplicated()) {
                this.replicator.largeMessageBegin(id);
            }
            LargeServerMessageImpl largeMessage = (LargeServerMessageImpl)this.createLargeMessage();
            largeMessage.copyHeadersAndProperties(message);
            largeMessage.setMessageID(id);
            if (largeMessage.isDurable()) {
                long pendingRecordID = this.storePendingLargeMessage(id);
                largeMessage.setPendingRecordID(pendingRecordID);
            }
            LargeServerMessageImpl largeServerMessageImpl = largeMessage;
            return largeServerMessageImpl;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long storePendingLargeMessage(long messageID) throws Exception {
        this.readLock();
        try {
            long recordID = this.generateUniqueID();
            this.messageJournal.appendAddRecord(recordID, (byte)29, (EncodingSupport)new PendingLargeMessageEncoding(messageID), true, (IOCompletion)this.getContext(true));
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmPendingLargeMessageTX(Transaction tx, long messageID, long recordID) throws Exception {
        this.readLock();
        try {
            this.installLargeMessageConfirmationOnTX(tx, recordID);
            this.messageJournal.appendDeleteRecordTransactional(tx.getID(), recordID, (EncodingSupport)new DeleteEncoding(29, messageID));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmPendingLargeMessage(long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(recordID, true, (IOCompletion)this.getContext());
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(ServerMessage message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw HornetQMessageBundle.BUNDLE.messageIdNotAssigned();
        }
        this.readLock();
        try {
            if (message.isLargeMessage()) {
                this.messageJournal.appendAddRecord(message.getMessageID(), (byte)30, (EncodingSupport)new LargeMessageEncoding((LargeServerMessage)message), false, (IOCompletion)this.getContext(false));
            } else {
                this.messageJournal.appendAddRecord(message.getMessageID(), (byte)31, (EncodingSupport)message, false, (IOCompletion)this.getContext(false));
            }
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeReference(long queueID, long messageID, boolean last) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(messageID, (byte)32, (EncodingSupport)new RefEncoding(queueID), last && this.syncNonTransactional, (IOCompletion)this.getContext(last && this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    private void readLock() {
        this.storageManagerLock.readLock().lock();
    }

    private void readUnLock() {
        this.storageManagerLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAcknowledge(long queueID, long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(messageID, (byte)33, (EncodingSupport)new RefEncoding(queueID), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCursorAcknowledge(long queueID, PagePosition position) throws Exception {
        this.readLock();
        try {
            long ackID = this.idGenerator.generateID();
            position.setRecordID(ackID);
            this.messageJournal.appendAddRecord(ackID, (byte)39, (EncodingSupport)new CursorAckRecordEncoding(queueID, position), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(messageID, false, (IOCompletion)this.getContext(false));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(ref.getMessage().getMessageID(), (byte)36, (EncodingSupport)encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
        this.readLock();
        try {
            DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
            this.messageJournal.appendAddRecord(recordID, (byte)37, (EncodingSupport)encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDuplicateID(long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(recordID, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessageTransactional(long txID, ServerMessage message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw HornetQMessageBundle.BUNDLE.messageIdNotAssigned();
        }
        this.readLock();
        try {
            if (message.isLargeMessage()) {
                this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)30, (EncodingSupport)new LargeMessageEncoding((LargeServerMessage)message));
            } else {
                this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)31, (EncodingSupport)message);
            }
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
        this.readLock();
        try {
            pageTransaction.setRecordID(this.generateUniqueID());
            this.messageJournal.appendAddRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, (EncodingSupport)pageTransaction);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depages) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, (EncodingSupport)new PageUpdateTXEncoding(pageTransaction.getTransactionID(), depages));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePageTransaction(PageTransactionInfo pageTransaction, int depages) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(pageTransaction.getRecordID(), (byte)35, (EncodingSupport)new PageUpdateTXEncoding(pageTransaction.getTransactionID(), depages), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)32, (EncodingSupport)new RefEncoding(queueID));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAcknowledgeTransactional(long txID, long queueID, long messageID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)33, (EncodingSupport)new RefEncoding(queueID));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) throws Exception {
        this.readLock();
        try {
            long ackID = this.idGenerator.generateID();
            position.setRecordID(ackID);
            this.messageJournal.appendAddRecordTransactional(txID, ackID, (byte)39, (EncodingSupport)new CursorAckRecordEncoding(queueID, position));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void storePageCompleteTransactional(long txID, long queueID, PagePosition position) throws Exception {
        long recordID = this.idGenerator.generateID();
        position.setRecordID(recordID);
        this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)42, (EncodingSupport)new CursorAckRecordEncoding(queueID, position));
    }

    @Override
    public void deletePageComplete(long ackID) throws Exception {
        this.messageJournal.appendDeleteRecord(ackID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, ackID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
        this.readLock();
        try {
            long id = this.generateUniqueID();
            this.messageJournal.appendAddRecord(id, (byte)38, (EncodingSupport)new HeuristicCompletionEncoding(xid, isCommit), true, (IOCompletion)this.getContext(true));
            long l = id;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHeuristicCompletion(long id) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(id, true, (IOCompletion)this.getContext(true));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePageTransactional(long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecord(recordID, false);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, ref.getMessage().getMessageID(), (byte)36, (EncodingSupport)encoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(long txID, Xid xid) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendPrepareRecord(txID, (EncodingSupport)new XidEncoding(xid), this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void commit(long txID) throws Exception {
        this.commit(txID, true);
    }

    @Override
    public void commitBindings(long txID) throws Exception {
        this.bindingsJournal.appendCommitRecord(txID, true);
    }

    @Override
    public void rollbackBindings(long txID) throws Exception {
        this.bindingsJournal.appendRollbackRecord(txID, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(long txID, boolean lineUpContext) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendCommitRecord(txID, this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional), lineUpContext);
            if (!lineUpContext && !this.syncTransactional) {
                this.getContext(true).done();
            }
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(long txID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendRollbackRecord(txID, this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.readLock();
        try {
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)37, (EncodingSupport)encoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecordTransactional(txID, recordID, (byte)37, (EncodingSupport)encoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeliveryCount(MessageReference ref) throws Exception {
        if (ref.getDeliveryCount() == ref.getPersistedCount()) {
            return;
        }
        ref.setPersistedCount(ref.getDeliveryCount());
        DeliveryCountUpdateEncoding updateInfo = new DeliveryCountUpdateEncoding(ref.getQueue().getID(), ref.getDeliveryCount());
        this.readLock();
        try {
            this.messageJournal.appendUpdateRecord(ref.getMessage().getMessageID(), (byte)34, (EncodingSupport)updateInfo, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
        this.deleteAddressSetting(addressSetting.getAddressMatch());
        this.readLock();
        try {
            long id = this.idGenerator.generateID();
            addressSetting.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)25, (EncodingSupport)addressSetting, true);
            this.mapPersistedAddressSettings.put(addressSetting.getAddressMatch(), addressSetting);
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
        ArrayList<PersistedAddressSetting> list = new ArrayList<PersistedAddressSetting>(this.mapPersistedAddressSettings.size());
        list.addAll(this.mapPersistedAddressSettings.values());
        return list;
    }

    @Override
    public List<PersistedRoles> recoverPersistedRoles() throws Exception {
        ArrayList<PersistedRoles> list = new ArrayList<PersistedRoles>(this.mapPersistedRoles.size());
        list.addAll(this.mapPersistedRoles.values());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSecurityRoles(PersistedRoles persistedRoles) throws Exception {
        this.deleteSecurityRoles(persistedRoles.getAddressMatch());
        this.readLock();
        try {
            long id = this.idGenerator.generateID();
            persistedRoles.setStoreId(id);
            this.bindingsJournal.appendAddRecord(id, (byte)26, (EncodingSupport)persistedRoles, true);
            this.mapPersistedRoles.put(persistedRoles.getAddressMatch(), persistedRoles);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void storeID(long journalID, long id) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecord(journalID, (byte)24, BatchingIDGenerator.createIDEncodingSupport(id), true);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
        PersistedAddressSetting oldSetting = this.mapPersistedAddressSettings.remove(addressMatch);
        if (oldSetting != null) {
            this.readLock();
            try {
                this.bindingsJournal.appendDeleteRecord(oldSetting.getStoreId(), false);
            }
            finally {
                this.readUnLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSecurityRoles(SimpleString addressMatch) throws Exception {
        PersistedRoles oldRoles = this.mapPersistedRoles.remove(addressMatch);
        if (oldRoles != null) {
            this.readLock();
            try {
                this.bindingsJournal.appendDeleteRecord(oldRoles.getStoreId(), false);
            }
            finally {
                this.readUnLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, Queue> queues, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Set<Pair<Long, Long>> pendingLargeMessages) throws Exception {
        ArrayList records = new ArrayList();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        HashMap<Long, ServerMessage> messages = new HashMap<Long, ServerMessage>();
        this.readLock();
        try {
            JournalLoadInformation info = this.messageJournal.load(records, preparedTransactions, (TransactionFailureCallback)new LargeMessageTXFailureCallback(messages));
            ArrayList<LargeServerMessage> largeMessages = new ArrayList<LargeServerMessage>();
            HashMap queueMap = new HashMap();
            HashMap<Long, PageSubscription> pageSubscriptions = new HashMap<Long, PageSubscription>();
            int totalSize = records.size();
            for (int reccount = 0; reccount < totalSize; ++reccount) {
                if (reccount > 0 && reccount % 1000000 == 0) {
                    long l = (long)((double)reccount / (double)totalSize * 100.0);
                    HornetQLogger.LOGGER.percentLoaded(l);
                }
                RecordInfo recordInfo = (RecordInfo)records.get(reccount);
                byte[] data = recordInfo.data;
                HornetQBuffer buff = HornetQBuffers.wrappedBuffer((byte[])data);
                byte recordType = recordInfo.getUserRecordType();
                switch (recordType) {
                    case 29: {
                        PendingLargeMessageEncoding pending = new PendingLargeMessageEncoding();
                        pending.decode(buff);
                        if (pendingLargeMessages == null) break;
                        pendingLargeMessages.add((Pair<Long, Long>)new Pair((Object)recordInfo.id, (Object)pending.largeMessageID));
                        break;
                    }
                    case 30: {
                        LargeServerMessage largeMessage = this.parseLargeMessage(messages, buff);
                        messages.put(recordInfo.id, largeMessage);
                        largeMessages.add(largeMessage);
                        break;
                    }
                    case 31: {
                        ServerMessageImpl message = new ServerMessageImpl(recordInfo.id, 50);
                        message.decode(buff);
                        messages.put(recordInfo.id, message);
                        break;
                    }
                    case 32: {
                        ServerMessage message;
                        long messageID = recordInfo.id;
                        Object encoding = new RefEncoding();
                        ((QueueEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (LinkedHashMap<Long, AddMessageRecord>)queueMap.get(((RefEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            queueMessages = new LinkedHashMap<Long, AddMessageRecord>();
                            queueMap.put(((RefEncoding)encoding).queueID, queueMessages);
                        }
                        if ((message = (ServerMessage)messages.get(messageID)) == null) {
                            HornetQLogger.LOGGER.cannotFindMessage(recordInfo.id);
                            break;
                        }
                        queueMessages.put(messageID, new AddMessageRecord(message));
                        break;
                    }
                    case 33: {
                        long messageID = recordInfo.id;
                        Object encoding = new RefEncoding();
                        ((QueueEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((RefEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            HornetQLogger.LOGGER.journalCannotFindQueue(((RefEncoding)encoding).queueID, messageID);
                            break;
                        }
                        AddMessageRecord rec = (AddMessageRecord)queueMessages.remove(messageID);
                        if (rec != null) break;
                        HornetQLogger.LOGGER.cannotFindMessage(messageID);
                        break;
                    }
                    case 34: {
                        long messageID = recordInfo.id;
                        Object encoding = new DeliveryCountUpdateEncoding();
                        ((DeliveryCountUpdateEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((DeliveryCountUpdateEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            HornetQLogger.LOGGER.journalCannotFindQueueDelCount(((DeliveryCountUpdateEncoding)encoding).queueID);
                            break;
                        }
                        AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                        if (rec == null) {
                            HornetQLogger.LOGGER.journalCannotFindMessageDelCount(messageID);
                            break;
                        }
                        rec.deliveryCount = ((DeliveryCountUpdateEncoding)encoding).count;
                        break;
                    }
                    case 35: {
                        if (recordInfo.isUpdate) {
                            PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                            pageUpdate.decode(buff);
                            PageTransactionInfo pageTX = pagingManager.getTransaction(pageUpdate.pageTX);
                            pageTX.onUpdate(pageUpdate.recods, null, null);
                            break;
                        }
                        PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                        pageTransactionInfo.decode(buff);
                        pageTransactionInfo.setRecordID(recordInfo.id);
                        pagingManager.addTransaction(pageTransactionInfo);
                        break;
                    }
                    case 36: {
                        long messageID = recordInfo.id;
                        Object encoding = new ScheduledDeliveryEncoding();
                        ((ScheduledDeliveryEncoding)encoding).decode(buff);
                        LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((ScheduledDeliveryEncoding)encoding).queueID);
                        if (queueMessages == null) {
                            HornetQLogger.LOGGER.journalCannotFindQueueScheduled(((ScheduledDeliveryEncoding)encoding).queueID, messageID);
                            break;
                        }
                        AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                        if (rec == null) {
                            HornetQLogger.LOGGER.cannotFindMessage(messageID);
                            break;
                        }
                        rec.scheduledDeliveryTime = ((ScheduledDeliveryEncoding)encoding).scheduledDeliveryTime;
                        break;
                    }
                    case 37: {
                        DuplicateIDEncoding encoding = new DuplicateIDEncoding();
                        encoding.decode(buff);
                        List<Pair<byte[], Long>> ids = duplicateIDMap.get(encoding.address);
                        if (ids == null) {
                            ids = new ArrayList<Pair<byte[], Long>>();
                            duplicateIDMap.put(encoding.address, ids);
                        }
                        ids.add((Pair<byte[], Long>)new Pair((Object)encoding.duplID, (Object)recordInfo.id));
                        break;
                    }
                    case 38: {
                        HeuristicCompletionEncoding encoding = new HeuristicCompletionEncoding();
                        encoding.decode(buff);
                        resourceManager.putHeuristicCompletion(recordInfo.id, encoding.xid, encoding.isCommit);
                        break;
                    }
                    case 39: {
                        CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                        encoding.decode(buff);
                        encoding.position.setRecordID(recordInfo.id);
                        PageSubscription sub = JournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.reloadACK(encoding.position);
                            break;
                        }
                        HornetQLogger.LOGGER.journalCannotFindQueueReloading(encoding.queueID);
                        this.messageJournal.appendDeleteRecord(recordInfo.id, false);
                        break;
                    }
                    case 40: {
                        PageCountRecord encoding = new PageCountRecord();
                        encoding.decode(buff);
                        PageSubscription sub = JournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().loadValue(recordInfo.id, encoding.value);
                            break;
                        }
                        HornetQLogger.LOGGER.journalCannotFindQueueReloadingPage(encoding.queueID);
                        this.messageJournal.appendDeleteRecord(recordInfo.id, false);
                        break;
                    }
                    case 41: {
                        PageCountRecordInc encoding = new PageCountRecordInc();
                        encoding.decode(buff);
                        PageSubscription sub = JournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().loadInc(recordInfo.id, encoding.value);
                            break;
                        }
                        HornetQLogger.LOGGER.journalCannotFindQueueReloadingPageCursor(encoding.queueID);
                        this.messageJournal.appendDeleteRecord(recordInfo.id, false);
                        break;
                    }
                    case 42: {
                        CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                        encoding.decode(buff);
                        encoding.position.setRecordID(recordInfo.id);
                        PageSubscription sub = JournalStorageManager.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.reloadPageCompletion(encoding.position);
                            break;
                        }
                        HornetQLogger.LOGGER.cantFindQueueOnPageComplete(encoding.queueID);
                        this.messageJournal.appendDeleteRecord(recordInfo.id, false);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid record type " + recordType);
                    }
                }
                records.set(reccount, null);
            }
            records.clear();
            records = null;
            for (Map.Entry entry : queueMap.entrySet()) {
                long queueID = (Long)entry.getKey();
                Map queueRecords = (Map)entry.getValue();
                Queue queue = queues.get(queueID);
                if (queue == null) {
                    if (queueRecords.values().size() == 0) continue;
                    HornetQLogger.LOGGER.journalCannotFindQueueForMessage(queueID);
                    continue;
                }
                queue.pause();
                Collection valueRecords = queueRecords.values();
                long currentTime = System.currentTimeMillis();
                for (AddMessageRecord record : valueRecords) {
                    long scheduledDeliveryTime = record.scheduledDeliveryTime;
                    if (scheduledDeliveryTime != 0L && scheduledDeliveryTime <= currentTime) {
                        scheduledDeliveryTime = 0L;
                        record.message.removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
                    }
                    if (scheduledDeliveryTime != 0L) {
                        record.message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, scheduledDeliveryTime);
                    }
                    MessageReference ref = postOffice.reroute(record.message, queue, null);
                    ref.setDeliveryCount(record.deliveryCount);
                    if (scheduledDeliveryTime == 0L) continue;
                    record.message.removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
                }
            }
            this.loadPreparedTransactions(postOffice, pagingManager, resourceManager, queues, queueInfos, preparedTransactions, duplicateIDMap, pageSubscriptions, pendingLargeMessages);
            for (PageSubscription pageSubscription : pageSubscriptions.values()) {
                pageSubscription.getCounter().processReload();
            }
            for (LargeServerMessage largeServerMessage : largeMessages) {
                if (largeServerMessage.getRefCount() != 0) continue;
                HornetQLogger.LOGGER.largeMessageWithNoRef(largeServerMessage.getMessageID());
                largeServerMessage.decrementDelayDeletionCount();
            }
            for (ServerMessage serverMessage : messages.values()) {
                if (serverMessage.getRefCount() != 0) continue;
                HornetQLogger.LOGGER.journalUnreferencedMessage(serverMessage.getMessageID());
                try {
                    this.deleteMessage(serverMessage.getMessageID());
                }
                catch (Exception ignored) {
                    HornetQLogger.LOGGER.journalErrorDeletingMessage(ignored, serverMessage.getMessageID());
                }
            }
            if (pagingManager != null) {
                pagingManager.processReload();
            }
            if (this.perfBlastPages != -1) {
                this.messageJournal.perfBlast(this.perfBlastPages);
            }
            for (Queue queue : queues.values()) {
                queue.resume();
            }
            if (System.getProperty("org.hornetq.opt.directblast") != null) {
                this.messageJournal.runDirectJournalBlast();
            }
            this.journalLoaded = true;
            JournalLoadInformation journalLoadInformation = info;
            return journalLoadInformation;
        }
        finally {
            this.readUnLock();
        }
    }

    private static PageSubscription locateSubscription(long queueID, Map<Long, PageSubscription> pageSubscriptions, Map<Long, QueueBindingInfo> queueInfos, PagingManager pagingManager) throws Exception {
        QueueBindingInfo queueInfo;
        PageSubscription subs = pageSubscriptions.get(queueID);
        if (subs == null && (queueInfo = queueInfos.get(queueID)) != null) {
            SimpleString address = queueInfo.getAddress();
            PagingStore store = pagingManager.getPageStore(address);
            subs = store.getCursorProvider().getSubscription(queueID);
            pageSubscriptions.put(queueID, subs);
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGrouping(GroupBinding groupBinding) throws Exception {
        GroupingEncoding groupingEncoding = new GroupingEncoding(groupBinding.getId(), groupBinding.getGroupId(), groupBinding.getClusterName());
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecord(groupBinding.getId(), (byte)20, (EncodingSupport)groupingEncoding, true);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteGrouping(GroupBinding groupBinding) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecord(groupBinding.getId(), true);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueueBinding(long tx, Binding binding) throws Exception {
        Queue queue = (Queue)binding.getBindable();
        Filter filter = queue.getFilter();
        SimpleString filterString = filter == null ? null : filter.getFilterString();
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding(queue.getName(), binding.getAddress(), filterString);
        this.readLock();
        try {
            this.bindingsJournal.appendAddRecordTransactional(tx, binding.getID(), (byte)21, (EncodingSupport)bindingEncoding);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueueBinding(long queueBindingID) throws Exception {
        this.readLock();
        try {
            this.bindingsJournal.appendDeleteRecord(queueBindingID, true);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePageCounterInc(long txID, long queueID, int value) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)41, (EncodingSupport)new PageCountRecordInc(queueID, value));
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePageCounterInc(long queueID, int value) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecord(recordID, (byte)41, (EncodingSupport)new PageCountRecordInc(queueID, value), true, (IOCompletion)this.getContext());
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storePageCounter(long txID, long queueID, long value) throws Exception {
        this.readLock();
        try {
            long recordID = this.idGenerator.generateID();
            this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)40, (EncodingSupport)new PageCountRecord(queueID, value));
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIncrementRecord(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePageCounter(long txID, long recordID) throws Exception {
        this.readLock();
        try {
            this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
        }
        finally {
            this.readUnLock();
        }
    }

    static final void describeBindingJournal(String bindingsDir) throws Exception {
        NIOSequentialFileFactory bindingsFF = new NIOSequentialFileFactory(bindingsDir, null);
        JournalImpl bindings = new JournalImpl(0x100000, 2, -1, 0, (SequentialFileFactory)bindingsFF, "hornetq-bindings", "bindings", 1);
        JournalStorageManager.describeJournal((SequentialFileFactory)bindingsFF, bindings, bindingsDir);
    }

    static final void describeMessagesJournal(String messagesDir) throws Exception {
        NIOSequentialFileFactory messagesFF = new NIOSequentialFileFactory(messagesDir, null);
        ConfigurationImpl defaultValues = new ConfigurationImpl();
        JournalImpl messagesJournal = new JournalImpl(defaultValues.getJournalFileSize(), defaultValues.getJournalMinFiles(), 0, 0, (SequentialFileFactory)messagesFF, "hornetq-data", "hq", 1);
        JournalStorageManager.describeJournal((SequentialFileFactory)messagesFF, messagesJournal, messagesDir);
    }

    @Override
    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos) throws Exception {
        ArrayList records = new ArrayList();
        ArrayList preparedTransactions = new ArrayList();
        JournalLoadInformation bindingsInfo = this.bindingsJournal.load(records, preparedTransactions, null);
        for (RecordInfo record : records) {
            long id = record.id;
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((byte[])record.data);
            byte rec = record.getUserRecordType();
            if (rec == 21) {
                PersistentQueueBindingEncoding bindingEncoding = JournalStorageManager.newBindingEncoding(id, buffer);
                queueBindingInfos.add(bindingEncoding);
                continue;
            }
            if (rec == 24) {
                this.idGenerator.loadState(record.id, buffer);
                continue;
            }
            if (rec == 20) {
                GroupingEncoding encoding = JournalStorageManager.newGroupEncoding(id, buffer);
                groupingInfos.add(encoding);
                continue;
            }
            if (rec == 25) {
                PersistedAddressSetting setting = JournalStorageManager.newAddressEncoding(id, buffer);
                this.mapPersistedAddressSettings.put(setting.getAddressMatch(), setting);
                continue;
            }
            if (rec == 26) {
                PersistedRoles roles = JournalStorageManager.newSecurityRecord(id, buffer);
                this.mapPersistedRoles.put(roles.getAddressMatch(), roles);
                continue;
            }
            throw new IllegalStateException("Invalid record type " + rec);
        }
        return bindingsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lineUpContext() {
        this.readLock();
        try {
            this.messageJournal.lineUpContex((IOCompletion)this.getContext());
        }
        finally {
            this.readUnLock();
        }
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.checkAndCreateDir(this.bindingsDir, this.createBindingsDir);
        this.checkAndCreateDir(this.journalDir, this.createJournalDir);
        this.checkAndCreateDir(this.largeMessagesDirectory, this.createJournalDir);
        this.cleanupIncompleteFiles();
        this.singleThreadExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new HornetQThreadFactory("HornetQ-IO-SingleThread", true, JournalStorageManager.getThisClassLoader()));
        this.bindingsJournal.start();
        this.messageJournal.start();
        this.started = true;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    @Override
    public synchronized void stop(boolean ioCriticalError) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError && this.journalLoaded && this.idGenerator != null) {
            this.idGenerator.close();
        }
        if (this.replicator != null) {
            this.replicator.stop();
        }
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.singleThreadExecutor.shutdown();
        this.journalLoaded = false;
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalLoadInformation[] loadInternalOnly() throws Exception {
        this.readLock();
        try {
            JournalLoadInformation[] info = new JournalLoadInformation[]{this.bindingsJournal.loadInternalOnly(), this.messageJournal.loadInternalOnly()};
            JournalLoadInformation[] journalLoadInformationArray = info;
            return journalLoadInformationArray;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void beforePageRead() throws Exception {
        if (this.pageMaxConcurrentIO != null) {
            this.pageMaxConcurrentIO.acquire();
        }
    }

    @Override
    public void afterPageRead() throws Exception {
        if (this.pageMaxConcurrentIO != null) {
            this.pageMaxConcurrentIO.release();
        }
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return this.journalFF.allocateDirectBuffer(size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        this.journalFF.releaseBuffer(buffer);
    }

    @Override
    public Journal getMessageJournal() {
        return this.messageJournal;
    }

    @Override
    public Journal getBindingsJournal() {
        return this.bindingsJournal;
    }

    void deleteLargeMessageFile(final LargeServerMessage largeServerMessageImpl) throws HornetQException {
        final SequentialFile file = largeServerMessageImpl.getFile();
        if (file == null) {
            return;
        }
        Runnable deleteAction = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JournalStorageManager.this.readLock();
                    try {
                        if (JournalStorageManager.this.replicator != null) {
                            JournalStorageManager.this.replicator.largeMessageDelete(largeServerMessageImpl.getMessageID());
                        }
                        file.delete();
                    }
                    finally {
                        JournalStorageManager.this.readUnLock();
                    }
                }
                catch (Exception e) {
                    HornetQLogger.LOGGER.journalErrorDeletingMessage(e, largeServerMessageImpl.getMessageID());
                }
            }
        };
        if (this.executor == null) {
            deleteAction.run();
        } else {
            this.executor.execute(deleteAction);
        }
    }

    SequentialFile createFileForLargeMessage(long messageID, boolean durable) {
        if (durable) {
            return this.createFileForLargeMessage(messageID, ".msg");
        }
        return this.createFileForLargeMessage(messageID, ".tmp");
    }

    @Override
    public SequentialFile createFileForLargeMessage(long messageID, String extension) {
        return this.largeMessagesFactory.createSequentialFile(messageID + extension, -1);
    }

    private void checkAndCreateDir(String dir, boolean create) {
        File f = new File(dir);
        if (!f.exists()) {
            if (create) {
                if (!f.mkdirs()) {
                    throw new IllegalStateException("Failed to create directory " + dir);
                }
            } else {
                throw HornetQMessageBundle.BUNDLE.cannotCreateDir(dir);
            }
        }
    }

    private LargeServerMessage parseLargeMessage(Map<Long, ServerMessage> messages, HornetQBuffer buff) throws Exception {
        LargeServerMessage largeMessage = this.createLargeMessage();
        LargeMessageEncoding messageEncoding = new LargeMessageEncoding(largeMessage);
        messageEncoding.decode(buff);
        if (largeMessage.containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            SequentialFile linkedFile;
            long originalMessageID = largeMessage.getLongProperty(Message.HDR_ORIG_MESSAGE_ID);
            SequentialFile currentFile = this.createFileForLargeMessage(largeMessage.getMessageID(), true);
            if (!currentFile.exists() && (linkedFile = this.createFileForLargeMessage(originalMessageID, true)).exists()) {
                linkedFile.copyTo(currentFile);
                linkedFile.close();
            }
            currentFile.close();
        }
        return largeMessage;
    }

    private void loadPreparedTransactions(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, Queue> queues, Map<Long, QueueBindingInfo> queueInfos, List<PreparedTransactionInfo> preparedTransactions, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Map<Long, PageSubscription> pageSubscriptions, Set<Pair<Long, Long>> pendingLargeMessages) throws Exception {
        for (PreparedTransactionInfo preparedTransaction : preparedTransactions) {
            HornetQBuffer buff;
            byte[] data;
            XidEncoding encodingXid = new XidEncoding(preparedTransaction.extraData);
            Xid xid = encodingXid.xid;
            TransactionImpl tx = new TransactionImpl(preparedTransaction.id, xid, this);
            ArrayList<MessageReference> referencesToAck = new ArrayList<MessageReference>();
            HashMap<Long, ServerMessage> messages = new HashMap<Long, ServerMessage>();
            block16: for (RecordInfo record : preparedTransaction.records) {
                data = record.data;
                buff = HornetQBuffers.wrappedBuffer((byte[])data);
                byte recordType = record.getUserRecordType();
                switch (recordType) {
                    case 30: {
                        messages.put(record.id, this.parseLargeMessage(messages, buff));
                        continue block16;
                    }
                    case 31: {
                        ServerMessageImpl message = new ServerMessageImpl(record.id, 50);
                        message.decode(buff);
                        messages.put(record.id, message);
                        continue block16;
                    }
                    case 32: {
                        long messageID = record.id;
                        RefEncoding encoding = new RefEncoding();
                        encoding.decode(buff);
                        Queue queue = queues.get(encoding.queueID);
                        if (queue == null) {
                            HornetQLogger.LOGGER.journalMessageInPreparedTX(encoding.queueID);
                            continue block16;
                        }
                        ServerMessage message = (ServerMessage)messages.get(messageID);
                        if (message == null) {
                            throw new IllegalStateException("Cannot find message with id " + messageID);
                        }
                        postOffice.reroute(message, queue, tx);
                        continue block16;
                    }
                    case 33: {
                        long messageID = record.id;
                        RefEncoding encoding = new RefEncoding();
                        encoding.decode(buff);
                        Queue queue = queues.get(encoding.queueID);
                        if (queue == null) {
                            throw new IllegalStateException("Cannot find queue with id " + encoding.queueID);
                        }
                        MessageReference removed = queue.removeReferenceWithID(messageID);
                        if (removed == null) {
                            HornetQLogger.LOGGER.journalErrorRemovingRef(messageID);
                            continue block16;
                        }
                        referencesToAck.add(removed);
                        continue block16;
                    }
                    case 35: {
                        PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                        pageTransactionInfo.decode(buff);
                        if (record.isUpdate) {
                            PageTransactionInfo pgTX = pagingManager.getTransaction(pageTransactionInfo.getTransactionID());
                            pgTX.reloadUpdate(this, pagingManager, tx, pageTransactionInfo.getNumberOfMessages());
                            continue block16;
                        }
                        pageTransactionInfo.setCommitted(false);
                        tx.putProperty(5, pageTransactionInfo);
                        pagingManager.addTransaction(pageTransactionInfo);
                        tx.addOperation(new FinishPageMessageOperation());
                        continue block16;
                    }
                    case 36: {
                        continue block16;
                    }
                    case 37: {
                        Object encoding = new DuplicateIDEncoding();
                        ((DuplicateIDEncoding)encoding).decode(buff);
                        DuplicateIDCache cache = postOffice.getDuplicateIDCache(((DuplicateIDEncoding)encoding).address);
                        cache.load(tx, ((DuplicateIDEncoding)encoding).duplID);
                        continue block16;
                    }
                    case 39: {
                        Object encoding = new CursorAckRecordEncoding();
                        ((CursorAckRecordEncoding)encoding).decode(buff);
                        ((CursorAckRecordEncoding)encoding).position.setRecordID(record.id);
                        PageSubscription sub = JournalStorageManager.locateSubscription(((CursorAckRecordEncoding)encoding).queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.reloadPreparedACK(tx, ((CursorAckRecordEncoding)encoding).position);
                            referencesToAck.add(new PagedReferenceImpl(((CursorAckRecordEncoding)encoding).position, null, sub));
                            continue block16;
                        }
                        HornetQLogger.LOGGER.journalCannotFindQueueReloadingACK(((CursorAckRecordEncoding)encoding).queueID);
                        continue block16;
                    }
                    case 40: {
                        HornetQLogger.LOGGER.journalPAGEOnPrepared();
                        continue block16;
                    }
                    case 41: {
                        Object encoding = new PageCountRecordInc();
                        ((PageCountRecordInc)encoding).decode(buff);
                        PageSubscription sub = JournalStorageManager.locateSubscription(((PageCountRecordInc)encoding).queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().applyIncrement(tx, record.id, ((PageCountRecordInc)encoding).value);
                            continue block16;
                        }
                        HornetQLogger.LOGGER.journalCannotFindQueueReloadingACK(((PageCountRecordInc)encoding).queueID);
                        continue block16;
                    }
                }
                HornetQLogger.LOGGER.journalInvalidRecordType(recordType);
            }
            block17: for (RecordInfo recordDeleted : preparedTransaction.recordsToDelete) {
                data = recordDeleted.data;
                if (data.length <= 0) continue;
                buff = HornetQBuffers.wrappedBuffer((byte[])data);
                byte b = buff.readByte();
                switch (b) {
                    case 29: {
                        long messageID = buff.readLong();
                        if (!pendingLargeMessages.remove(new Pair((Object)recordDeleted.id, (Object)messageID))) {
                            HornetQLogger.LOGGER.warn("Large message " + recordDeleted.id + " wasn't found when dealing with add pending large message");
                        }
                        this.installLargeMessageConfirmationOnTX(tx, recordDeleted.id);
                        continue block17;
                    }
                }
                HornetQLogger.LOGGER.journalInvalidRecordTypeOnPreparedTX(b);
            }
            for (MessageReference ack : referencesToAck) {
                ack.getQueue().reacknowledge(tx, ack);
            }
            tx.setState(Transaction.State.PREPARED);
            resourceManager.putTransaction(xid, tx);
        }
    }

    private void cleanupIncompleteFiles() throws Exception {
        if (this.largeMessagesFactory != null) {
            List tmpFiles = this.largeMessagesFactory.listFiles("tmp");
            for (String tmpFile : tmpFiles) {
                SequentialFile file = this.largeMessagesFactory.createSequentialFile(tmpFile, -1);
                file.delete();
            }
        }
    }

    private OperationContext getContext(boolean sync) {
        if (sync) {
            return this.getContext();
        }
        return DummyOperationContext.getInstance();
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return JournalStorageManager.class.getClassLoader();
            }
        });
    }

    private static String describeRecord(RecordInfo info) {
        return "recordID=" + info.id + ";userRecordType=" + info.userRecordType + ";isUpdate=" + info.isUpdate + ";" + JournalStorageManager.newObjectEncoding(info);
    }

    private static String describeRecord(RecordInfo info, Object o) {
        return "recordID=" + info.id + ";userRecordType=" + info.userRecordType + ";isUpdate=" + info.isUpdate + ";" + o;
    }

    public static Object newObjectEncoding(RecordInfo info) {
        return JournalStorageManager.newObjectEncoding(info, null);
    }

    public static Object newObjectEncoding(RecordInfo info, JournalStorageManager storageManager) {
        HornetQBuffer buffer = HornetQBuffers.wrappedBuffer((byte[])info.data);
        long id = info.id;
        byte rec = info.getUserRecordType();
        switch (rec) {
            case 29: {
                PendingLargeMessageEncoding lmEncoding = new PendingLargeMessageEncoding();
                lmEncoding.decode(buffer);
                return lmEncoding;
            }
            case 30: {
                LargeServerMessageImpl largeMessage = new LargeServerMessageImpl(storageManager);
                LargeMessageEncoding messageEncoding = new LargeMessageEncoding(largeMessage);
                messageEncoding.decode(buffer);
                return new MessageDescribe(largeMessage);
            }
            case 31: {
                ServerMessageImpl message = new ServerMessageImpl(rec, 50);
                message.decode(buffer);
                return new MessageDescribe(message);
            }
            case 32: {
                RefEncoding encoding = new RefEncoding();
                encoding.decode(buffer);
                return new ReferenceDescribe(encoding);
            }
            case 33: {
                RefEncoding encoding = new RefEncoding();
                encoding.decode(buffer);
                return new AckDescribe(encoding);
            }
            case 34: {
                DeliveryCountUpdateEncoding updateDeliveryCount = new DeliveryCountUpdateEncoding();
                updateDeliveryCount.decode(buffer);
                return updateDeliveryCount;
            }
            case 35: {
                if (info.isUpdate) {
                    PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                    pageUpdate.decode(buffer);
                    return pageUpdate;
                }
                PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                pageTransactionInfo.decode(buffer);
                pageTransactionInfo.setRecordID(info.id);
                return pageTransactionInfo;
            }
            case 36: {
                ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 37: {
                DuplicateIDEncoding encoding = new DuplicateIDEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 38: {
                HeuristicCompletionEncoding encoding = new HeuristicCompletionEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 39: {
                CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 40: {
                PageCountRecord encoding = new PageCountRecord();
                encoding.decode(buffer);
                return encoding;
            }
            case 42: {
                CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                encoding.decode(buffer);
                return encoding;
            }
            case 41: {
                PageCountRecordInc encoding = new PageCountRecordInc();
                encoding.decode(buffer);
                return encoding;
            }
            case 21: {
                return JournalStorageManager.newBindingEncoding(id, buffer);
            }
            case 24: {
                BatchingIDGenerator.IDCounterEncoding idReturn = new BatchingIDGenerator.IDCounterEncoding();
                idReturn.decode(buffer);
                return idReturn;
            }
            case 20: {
                return JournalStorageManager.newGroupEncoding(id, buffer);
            }
            case 25: {
                return JournalStorageManager.newAddressEncoding(id, buffer);
            }
            case 26: {
                return JournalStorageManager.newSecurityRecord(id, buffer);
            }
        }
        return null;
    }

    private static PersistedRoles newSecurityRecord(long id, HornetQBuffer buffer) {
        PersistedRoles roles = new PersistedRoles();
        roles.decode(buffer);
        roles.setStoreId(id);
        return roles;
    }

    private static PersistedAddressSetting newAddressEncoding(long id, HornetQBuffer buffer) {
        PersistedAddressSetting setting = new PersistedAddressSetting();
        setting.decode(buffer);
        setting.setStoreId(id);
        return setting;
    }

    private static GroupingEncoding newGroupEncoding(long id, HornetQBuffer buffer) {
        GroupingEncoding encoding = new GroupingEncoding();
        encoding.decode(buffer);
        encoding.setId(id);
        return encoding;
    }

    private static PersistentQueueBindingEncoding newBindingEncoding(long id, HornetQBuffer buffer) {
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding();
        bindingEncoding.decode(buffer);
        bindingEncoding.setId(id);
        return bindingEncoding;
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (int)0, (int)data.length, (int)24);
    }

    private static Xid toXid(byte[] data) {
        try {
            return XidCodecSupport.decodeXid(HornetQBuffers.wrappedBuffer((byte[])data));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void describeJournal(SequentialFileFactory fileFactory, JournalImpl journal, String path) throws Exception {
        List files = journal.orderFiles();
        final PrintStream out = System.out;
        out.println("Journal path: " + path);
        for (JournalFile file : files) {
            out.println("#" + file + " (size=" + file.getFile().size() + ")");
            JournalImpl.readJournalFile((SequentialFileFactory)fileFactory, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

                public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@UpdateTX;txID=" + transactionID + "," + JournalStorageManager.describeRecord(recordInfo));
                }

                public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@Update;" + JournalStorageManager.describeRecord(recordInfo));
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                    out.println("operation@Rollback;txID=" + transactionID);
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    out.println("operation@Prepare,txID=" + transactionID + ",numberOfRecords=" + numberOfRecords + ",extraData=" + JournalStorageManager.encode(extraData) + ", xid=" + JournalStorageManager.toXid(extraData));
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@DeleteRecordTX;txID=" + transactionID + "," + JournalStorageManager.describeRecord(recordInfo));
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                    out.println("operation@DeleteRecord;recordID=" + recordID);
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    out.println("operation@Commit;txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecordTX;txID=" + transactionID + "," + JournalStorageManager.describeRecord(recordInfo));
                }

                public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecord;" + JournalStorageManager.describeRecord(recordInfo));
                }

                public void markAsDataFile(JournalFile file) {
                }
            });
        }
        out.println();
        out.println("### Surviving Records Summary ###");
        LinkedList records = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        journal.start();
        final StringBuffer bufferFailingTransactions = new StringBuffer();
        int messageCount = 0;
        HashMap<Long, Integer> messageRefCounts = new HashMap<Long, Integer>();
        int preparedMessageCount = 0;
        HashMap<Long, Integer> preparedMessageRefCount = new HashMap<Long, Integer>();
        journal.load(records, preparedTransactions, new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
                bufferFailingTransactions.append("Transaction " + transactionID + " failed with these records:\n");
                for (RecordInfo info : records) {
                    bufferFailingTransactions.append("- " + JournalStorageManager.describeRecord(info) + "\n");
                }
                for (RecordInfo info : recordsToDelete) {
                    bufferFailingTransactions.append("- " + JournalStorageManager.describeRecord(info) + " <marked to delete>\n");
                }
            }
        }, false);
        for (RecordInfo info : records) {
            Integer count;
            Object ref;
            Object o = JournalStorageManager.newObjectEncoding(info);
            if (info.getUserRecordType() == 31) {
                ++messageCount;
            } else if (info.getUserRecordType() == 32) {
                ref = (ReferenceDescribe)o;
                count = (Integer)messageRefCounts.get(((ReferenceDescribe)ref).refEncoding.queueID);
                if (count == null) {
                    count = 1;
                    messageRefCounts.put(((ReferenceDescribe)ref).refEncoding.queueID, count);
                } else {
                    messageRefCounts.put(((ReferenceDescribe)ref).refEncoding.queueID, count + 1);
                }
            } else if (info.getUserRecordType() == 33) {
                ref = (AckDescribe)o;
                count = (Integer)messageRefCounts.get(((AckDescribe)ref).refEncoding.queueID);
                if (count == null) {
                    messageRefCounts.put(((AckDescribe)ref).refEncoding.queueID, 0);
                } else {
                    messageRefCounts.put(((AckDescribe)ref).refEncoding.queueID, count - 1);
                }
            }
            out.println(JournalStorageManager.describeRecord(info, o));
        }
        out.println();
        out.println("### Prepared TX ###");
        for (PreparedTransactionInfo tx : preparedTransactions) {
            System.out.println(tx.id);
            for (RecordInfo info : tx.records) {
                Object o = JournalStorageManager.newObjectEncoding(info);
                out.println("- " + JournalStorageManager.describeRecord(info, o));
                if (info.getUserRecordType() == 31) {
                    ++preparedMessageCount;
                    continue;
                }
                if (info.getUserRecordType() != 32) continue;
                ReferenceDescribe ref = (ReferenceDescribe)o;
                Integer count = (Integer)preparedMessageRefCount.get(ref.refEncoding.queueID);
                if (count == null) {
                    count = 1;
                    preparedMessageRefCount.put(ref.refEncoding.queueID, count);
                    continue;
                }
                preparedMessageRefCount.put(ref.refEncoding.queueID, count + 1);
            }
            for (RecordInfo info : tx.recordsToDelete) {
                out.println("- " + JournalStorageManager.describeRecord(info) + " <marked to delete>");
            }
        }
        String missingTX = bufferFailingTransactions.toString();
        if (missingTX.length() > 0) {
            out.println();
            out.println("### Failed Transactions (Missing commit/prepare/rollback record) ###");
        }
        out.println(bufferFailingTransactions.toString());
        out.println("### Message Counts ###");
        out.println("message count=" + messageCount);
        out.println("message reference count");
        for (Map.Entry longIntegerEntry : messageRefCounts.entrySet()) {
            System.out.println("queue id " + longIntegerEntry.getKey() + ",count=" + longIntegerEntry.getValue());
        }
        out.println("prepared message count=" + preparedMessageCount);
        for (Map.Entry longIntegerEntry : preparedMessageRefCount.entrySet()) {
            System.out.println("queue id " + longIntegerEntry.getKey() + ",count=" + longIntegerEntry.getValue());
        }
        journal.stop();
    }

    @Override
    public boolean addToPage(PagingStore store, ServerMessage msg, Transaction tx, RouteContextList listCtx) throws Exception {
        return store.page(msg, tx, listCtx, this.storageManagerLock.readLock());
    }

    private void installLargeMessageConfirmationOnTX(Transaction tx, long recordID) {
        TXLargeMessageConfirmationOperation txoper = (TXLargeMessageConfirmationOperation)tx.getProperty(1);
        if (txoper == null) {
            txoper = new TXLargeMessageConfirmationOperation();
            tx.putProperty(1, txoper);
        }
        txoper.confirmedMessages.add(recordID);
    }

    final class TXLargeMessageConfirmationOperation
    implements TransactionOperation {
        public List<Long> confirmedMessages = new LinkedList<Long>();

        TXLargeMessageConfirmationOperation() {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void afterCommit(Transaction tx) {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public void afterRollback(Transaction tx) {
            for (Long msg : this.confirmedMessages) {
                try {
                    JournalStorageManager.this.confirmPendingLargeMessage(msg);
                }
                catch (Throwable e) {
                    HornetQLogger.LOGGER.journalErrorConfirmingLargeMessage(e, msg);
                }
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }

    public static class MessageDescribe {
        Message msg;

        public MessageDescribe(Message msg) {
            this.msg = msg;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.msg.isLargeMessage() ? "LargeMessage(" : "Message(");
            buffer.append("messageID=" + this.msg.getMessageID());
            buffer.append(";properties=[");
            Set<SimpleString> properties = this.msg.getPropertyNames();
            for (SimpleString prop : properties) {
                Object value = this.msg.getObjectProperty(prop);
                if (value instanceof byte[]) {
                    buffer.append(prop + "=" + Arrays.toString((byte[])value) + ",");
                    continue;
                }
                buffer.append(prop + "=" + value + ",");
            }
            buffer.append("#properties = " + properties.size());
            buffer.append("]");
            buffer.append(" - " + this.msg.toString());
            return buffer.toString();
        }
    }

    public static class AckDescribe {
        public RefEncoding refEncoding;

        public AckDescribe(RefEncoding refEncoding) {
            this.refEncoding = refEncoding;
        }

        public String toString() {
            return "ACK;" + this.refEncoding;
        }
    }

    public static class ReferenceDescribe {
        public RefEncoding refEncoding;

        public ReferenceDescribe(RefEncoding refEncoding) {
            this.refEncoding = refEncoding;
        }

        public String toString() {
            return "AddRef;" + this.refEncoding;
        }
    }

    private class LargeMessageTXFailureCallback
    implements TransactionFailureCallback {
        private final Map<Long, ServerMessage> messages;

        public LargeMessageTXFailureCallback(Map<Long, ServerMessage> messages) {
            this.messages = messages;
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            for (RecordInfo record : records) {
                if (record.userRecordType != 30) continue;
                byte[] data = record.data;
                HornetQBuffer buff = HornetQBuffers.wrappedBuffer((byte[])data);
                try {
                    LargeServerMessage serverMessage = JournalStorageManager.this.parseLargeMessage(this.messages, buff);
                    serverMessage.decrementDelayDeletionCount();
                }
                catch (Exception e) {
                    HornetQLogger.LOGGER.journalError(e);
                }
            }
        }
    }

    public static final class CursorAckRecordEncoding
    implements EncodingSupport {
        public long queueID;
        public PagePosition position;

        public CursorAckRecordEncoding(long queueID, PagePosition position) {
            this.queueID = queueID;
            this.position = position;
        }

        public CursorAckRecordEncoding() {
            this.position = new PagePositionImpl();
        }

        public String toString() {
            return "CursorAckRecordEncoding [queueID=" + this.queueID + ", position=" + this.position + "]";
        }

        public int getEncodeSize() {
            return 20;
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeLong(this.position.getPageNr());
            buffer.writeInt(this.position.getMessageNr());
        }

        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            long pageNR = buffer.readLong();
            int messageNR = buffer.readInt();
            this.position = new PagePositionImpl(pageNR, messageNR);
        }
    }

    private static final class AddMessageRecord {
        final ServerMessage message;
        long scheduledDeliveryTime;
        int deliveryCount;

        public AddMessageRecord(ServerMessage message) {
            this.message = message;
        }
    }

    private static final class PageCountRecordInc
    implements EncodingSupport {
        long queueID;
        int value;

        public String toString() {
            return "PageCountRecordInc [queueID=" + this.queueID + ", value=" + this.value + "]";
        }

        PageCountRecordInc() {
        }

        PageCountRecordInc(long queueID, int value) {
            this.queueID = queueID;
            this.value = value;
        }

        public int getEncodeSize() {
            return 12;
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeInt(this.value);
        }

        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            this.value = buffer.readInt();
        }
    }

    private static final class PageCountRecord
    implements EncodingSupport {
        long queueID;
        long value;

        public String toString() {
            return "PageCountRecord [queueID=" + this.queueID + ", value=" + this.value + "]";
        }

        PageCountRecord() {
        }

        PageCountRecord(long queueID, long value) {
            this.queueID = queueID;
            this.value = value;
        }

        public int getEncodeSize() {
            return 16;
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeLong(this.value);
        }

        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            this.value = buffer.readLong();
        }
    }

    private static class FinishPageMessageOperation
    implements TransactionOperation {
        private FinishPageMessageOperation() {
        }

        @Override
        public void afterCommit(Transaction tx) {
            PageTransactionInfo pageTransaction = (PageTransactionInfo)tx.getProperty(5);
            if (pageTransaction != null) {
                pageTransaction.commit();
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
            PageTransactionInfo pageTransaction = (PageTransactionInfo)tx.getProperty(5);
            if (tx.getState() == Transaction.State.PREPARED && pageTransaction != null) {
                pageTransaction.rollback();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }

    public static class DuplicateIDEncoding
    implements EncodingSupport {
        SimpleString address;
        byte[] duplID;

        public DuplicateIDEncoding(SimpleString address, byte[] duplID) {
            this.address = address;
            this.duplID = duplID;
        }

        public DuplicateIDEncoding() {
        }

        public void decode(HornetQBuffer buffer) {
            this.address = buffer.readSimpleString();
            int size = buffer.readInt();
            this.duplID = new byte[size];
            buffer.readBytes(this.duplID);
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeSimpleString(this.address);
            buffer.writeInt(this.duplID.length);
            buffer.writeBytes(this.duplID);
        }

        public int getEncodeSize() {
            return SimpleString.sizeofString((SimpleString)this.address) + 4 + this.duplID.length;
        }

        public String toString() {
            return "DuplicateIDEncoding [address=" + this.address + ", duplID=" + Arrays.toString(this.duplID) + "]";
        }
    }

    private static class ScheduledDeliveryEncoding
    extends QueueEncoding {
        long scheduledDeliveryTime;

        @Override
        public String toString() {
            return "ScheduledDeliveryEncoding [scheduledDeliveryTime=" + this.scheduledDeliveryTime + "]";
        }

        private ScheduledDeliveryEncoding(long scheduledDeliveryTime, long queueID) {
            super(queueID);
            this.scheduledDeliveryTime = scheduledDeliveryTime;
        }

        public ScheduledDeliveryEncoding() {
        }

        @Override
        public int getEncodeSize() {
            return super.getEncodeSize() + 8;
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            super.encode(buffer);
            buffer.writeLong(this.scheduledDeliveryTime);
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            super.decode(buffer);
            this.scheduledDeliveryTime = buffer.readLong();
        }
    }

    public static class PageUpdateTXEncoding
    implements EncodingSupport {
        public long pageTX;
        public int recods;

        public String toString() {
            return "PageUpdateTXEncoding [pageTX=" + this.pageTX + ", recods=" + this.recods + "]";
        }

        public PageUpdateTXEncoding() {
        }

        public PageUpdateTXEncoding(long pageTX, int records) {
            this.pageTX = pageTX;
            this.recods = records;
        }

        public void decode(HornetQBuffer buffer) {
            this.pageTX = buffer.readLong();
            this.recods = buffer.readInt();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.pageTX);
            buffer.writeInt(this.recods);
        }

        public int getEncodeSize() {
            return 12;
        }

        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }

    public static class RefEncoding
    extends QueueEncoding {
        public RefEncoding() {
        }

        public RefEncoding(long queueID) {
            super(queueID);
        }
    }

    private static class DeleteEncoding
    implements EncodingSupport {
        public byte recordType;
        public long id;

        public DeleteEncoding(byte recordType, long id) {
            this.recordType = recordType;
            this.id = id;
        }

        public int getEncodeSize() {
            return 9;
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeByte(this.recordType);
            buffer.writeLong(this.id);
        }

        public void decode(HornetQBuffer buffer) {
            this.recordType = buffer.readByte();
            this.id = buffer.readLong();
        }
    }

    public static class QueueEncoding
    implements EncodingSupport {
        public long queueID;

        public QueueEncoding(long queueID) {
            this.queueID = queueID;
        }

        public QueueEncoding() {
        }

        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
        }

        public int getEncodeSize() {
            return 8;
        }

        public String toString() {
            return "QueueEncoding [queueID=" + this.queueID + "]";
        }
    }

    public static class DeliveryCountUpdateEncoding
    implements EncodingSupport {
        public long queueID;
        public int count;

        public DeliveryCountUpdateEncoding() {
        }

        public DeliveryCountUpdateEncoding(long queueID, int count) {
            this.queueID = queueID;
            this.count = count;
        }

        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            this.count = buffer.readInt();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeInt(this.count);
        }

        public int getEncodeSize() {
            return 12;
        }

        public String toString() {
            return "DeliveryCountUpdateEncoding [queueID=" + this.queueID + ", count=" + this.count + "]";
        }
    }

    public static class PendingLargeMessageEncoding
    implements EncodingSupport {
        public long largeMessageID;

        public PendingLargeMessageEncoding(long pendingLargeMessageID) {
            this.largeMessageID = pendingLargeMessageID;
        }

        public PendingLargeMessageEncoding() {
        }

        public void decode(HornetQBuffer buffer) {
            this.largeMessageID = buffer.readLong();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.largeMessageID);
        }

        public int getEncodeSize() {
            return 8;
        }

        public String toString() {
            return "PendingLargeMessageEncoding::MessageID=" + this.largeMessageID;
        }
    }

    public static class LargeMessageEncoding
    implements EncodingSupport {
        public final LargeServerMessage message;

        public LargeMessageEncoding(LargeServerMessage message) {
            this.message = message;
        }

        public void decode(HornetQBuffer buffer) {
            this.message.decodeHeadersAndProperties(buffer);
        }

        public void encode(HornetQBuffer buffer) {
            this.message.encode(buffer);
        }

        public int getEncodeSize() {
            return this.message.getEncodeSize();
        }
    }

    public static class PersistentQueueBindingEncoding
    implements EncodingSupport,
    QueueBindingInfo {
        public long id;
        public SimpleString name;
        public SimpleString address;
        public SimpleString filterString;

        public PersistentQueueBindingEncoding() {
        }

        public String toString() {
            return "PersistentQueueBindingEncoding [id=" + this.id + ", name=" + this.name + ", address=" + this.address + ", filterString=" + this.filterString + "]";
        }

        public PersistentQueueBindingEncoding(SimpleString name, SimpleString address, SimpleString filterString) {
            this.name = name;
            this.address = address;
            this.filterString = filterString;
        }

        @Override
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Override
        public SimpleString getAddress() {
            return this.address;
        }

        @Override
        public SimpleString getFilterString() {
            return this.filterString;
        }

        @Override
        public SimpleString getQueueName() {
            return this.name;
        }

        public void decode(HornetQBuffer buffer) {
            this.name = buffer.readSimpleString();
            this.address = buffer.readSimpleString();
            this.filterString = buffer.readNullableSimpleString();
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeSimpleString(this.name);
            buffer.writeSimpleString(this.address);
            buffer.writeNullableSimpleString(this.filterString);
        }

        public int getEncodeSize() {
            return SimpleString.sizeofString((SimpleString)this.name) + SimpleString.sizeofString((SimpleString)this.address) + SimpleString.sizeofNullableString((SimpleString)this.filterString);
        }
    }

    private static class GroupingEncoding
    implements EncodingSupport,
    GroupingInfo {
        public long id;
        public SimpleString groupId;
        public SimpleString clusterName;

        public GroupingEncoding(long id, SimpleString groupId, SimpleString clusterName) {
            this.id = id;
            this.groupId = groupId;
            this.clusterName = clusterName;
        }

        public GroupingEncoding() {
        }

        public int getEncodeSize() {
            return SimpleString.sizeofString((SimpleString)this.groupId) + SimpleString.sizeofString((SimpleString)this.clusterName);
        }

        public void encode(HornetQBuffer buffer) {
            buffer.writeSimpleString(this.groupId);
            buffer.writeSimpleString(this.clusterName);
        }

        public void decode(HornetQBuffer buffer) {
            this.groupId = buffer.readSimpleString();
            this.clusterName = buffer.readSimpleString();
        }

        @Override
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Override
        public SimpleString getGroupId() {
            return this.groupId;
        }

        @Override
        public SimpleString getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return "GroupingEncoding [id=" + this.id + ", groupId=" + this.groupId + ", clusterName=" + this.clusterName + "]";
        }
    }

    private static class HeuristicCompletionEncoding
    implements EncodingSupport {
        public Xid xid;
        public boolean isCommit;

        public String toString() {
            return "HeuristicCompletionEncoding [xid=" + this.xid + ", isCommit=" + this.isCommit + "]";
        }

        HeuristicCompletionEncoding(Xid xid, boolean isCommit) {
            this.xid = xid;
            this.isCommit = isCommit;
        }

        HeuristicCompletionEncoding() {
        }

        public void decode(HornetQBuffer buffer) {
            this.xid = XidCodecSupport.decodeXid(buffer);
            this.isCommit = buffer.readBoolean();
        }

        public void encode(HornetQBuffer buffer) {
            XidCodecSupport.encodeXid(this.xid, buffer);
            buffer.writeBoolean(this.isCommit);
        }

        public int getEncodeSize() {
            return XidCodecSupport.getXidEncodeLength(this.xid) + 1;
        }
    }

    public static class XidEncoding
    implements EncodingSupport {
        public final Xid xid;

        XidEncoding(Xid xid) {
            this.xid = xid;
        }

        XidEncoding(byte[] data) {
            this.xid = XidCodecSupport.decodeXid(HornetQBuffers.wrappedBuffer((byte[])data));
        }

        public void decode(HornetQBuffer buffer) {
            throw new IllegalStateException("Non Supported Operation");
        }

        public void encode(HornetQBuffer buffer) {
            XidCodecSupport.encodeXid(this.xid, buffer);
        }

        public int getEncodeSize() {
            return XidCodecSupport.getXidEncodeLength(this.xid);
        }
    }

    private static final class DummyOperationContext
    implements OperationContext {
        private static DummyOperationContext instance = new DummyOperationContext();

        private DummyOperationContext() {
        }

        public static OperationContext getInstance() {
            return instance;
        }

        @Override
        public void executeOnCompletion(IOAsyncTask runnable) {
            runnable.done();
        }

        @Override
        public void replicationDone() {
        }

        @Override
        public void replicationLineUp() {
        }

        public void storeLineUp() {
        }

        public void done() {
        }

        public void onError(int errorCode, String errorMessage) {
        }

        @Override
        public void waitCompletion() {
        }

        @Override
        public boolean waitCompletion(long timeout) {
            return true;
        }

        @Override
        public void pageSyncLineUp() {
        }

        @Override
        public void pageSyncDone() {
        }
    }

    public static enum JournalContent {
        BINDINGS(0),
        MESSAGES(1);

        public final byte typeByte;

        private JournalContent(byte b) {
            this.typeByte = b;
        }

        public static JournalContent getType(byte type) {
            if (JournalContent.MESSAGES.typeByte == type) {
                return MESSAGES;
            }
            if (JournalContent.BINDINGS.typeByte == type) {
                return BINDINGS;
            }
            throw new InvalidParameterException("invalid byte: " + type);
        }
    }
}

