/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.nullpm;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.nullpm.NullStorageLargeServerMessage;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RouteContextList;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.utils.Pair;

public class NullStorageManager
implements StorageManager {
    private final AtomicLong idSequence = new AtomicLong(0L);
    private volatile boolean started;
    private static final OperationContext dummyContext = new OperationContext(){

        public void onError(int errorCode, String errorMessage) {
        }

        public void done() {
        }

        public void storeLineUp() {
        }

        @Override
        public boolean waitCompletion(long timeout) throws Exception {
            return true;
        }

        @Override
        public void waitCompletion() throws Exception {
        }

        @Override
        public void replicationLineUp() {
        }

        @Override
        public void replicationDone() {
        }

        @Override
        public void pageSyncLineUp() {
        }

        @Override
        public void pageSyncDone() {
        }

        @Override
        public void executeOnCompletion(IOAsyncTask runnable) {
            runnable.done();
        }
    };

    @Override
    public void deleteQueueBinding(long queueBindingID) throws Exception {
    }

    @Override
    public void commit(long txID) throws Exception {
    }

    @Override
    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos) throws Exception {
        return new JournalLoadInformation();
    }

    @Override
    public void prepare(long txID, Xid xid) throws Exception {
    }

    @Override
    public void rollback(long txID) throws Exception {
    }

    @Override
    public void rollbackBindings(long txID) throws Exception {
    }

    @Override
    public void commitBindings(long txID) throws Exception {
    }

    @Override
    public void storeReference(long queueID, long messageID, boolean last) throws Exception {
    }

    @Override
    public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
    }

    @Override
    public void storeAcknowledge(long queueID, long messageID) throws Exception {
    }

    @Override
    public void storeAcknowledgeTransactional(long txID, long queueID, long messageiD) throws Exception {
    }

    @Override
    public void deleteMessage(long messageID) throws Exception {
    }

    @Override
    public void storeMessage(ServerMessage message) throws Exception {
    }

    @Override
    public void storeMessageTransactional(long txID, ServerMessage message) throws Exception {
    }

    @Override
    public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
    }

    @Override
    public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
    }

    @Override
    public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
    }

    @Override
    public void updateDeliveryCount(MessageReference ref) throws Exception {
    }

    @Override
    public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    @Override
    public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    @Override
    public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
    }

    @Override
    public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
        return this.generateUniqueID();
    }

    @Override
    public void deleteHeuristicCompletion(long txID) throws Exception {
    }

    @Override
    public void addQueueBinding(long tx, Binding binding) throws Exception {
    }

    @Override
    public LargeServerMessage createLargeMessage() {
        return new NullStorageLargeServerMessage();
    }

    @Override
    public LargeServerMessage createLargeMessage(long id, MessageInternal message) {
        NullStorageLargeServerMessage largeMessage = new NullStorageLargeServerMessage();
        largeMessage.copyHeadersAndProperties(message);
        largeMessage.setMessageID(id);
        return largeMessage;
    }

    @Override
    public long generateUniqueID() {
        long id = this.idSequence.getAndIncrement();
        return id;
    }

    @Override
    public long getCurrentUniqueID() {
        return this.idSequence.get();
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        this.idSequence.set(0L);
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, Queue> queues, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Set<Pair<Long, Long>> pendingLargeMessages) throws Exception {
        return new JournalLoadInformation();
    }

    @Override
    public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
    }

    @Override
    public void deleteDuplicateID(long recordID) throws Exception {
    }

    @Override
    public void pageClosed(SimpleString storeName, int pageNumber) {
    }

    @Override
    public void pageDeleted(SimpleString storeName, int pageNumber) {
    }

    @Override
    public void pageWrite(PagedMessage message, int pageNumber) {
    }

    @Override
    public void addGrouping(GroupBinding groupBinding) throws Exception {
    }

    @Override
    public void deleteGrouping(GroupBinding groupBinding) throws Exception {
    }

    @Override
    public boolean waitOnOperations(long timeout) throws Exception {
        return true;
    }

    @Override
    public void afterCompleteOperations(IOAsyncTask run) {
        run.done();
    }

    @Override
    public void waitOnOperations() throws Exception {
    }

    @Override
    public OperationContext getContext() {
        return dummyContext;
    }

    @Override
    public OperationContext newContext(Executor executor) {
        return dummyContext;
    }

    @Override
    public OperationContext newSingleThreadContext() {
        return dummyContext;
    }

    @Override
    public void setContext(OperationContext context) {
    }

    @Override
    public void clearContext() {
    }

    @Override
    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
        return Collections.emptyList();
    }

    @Override
    public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
    }

    @Override
    public List<PersistedRoles> recoverPersistedRoles() throws Exception {
        return Collections.emptyList();
    }

    @Override
    public void storeSecurityRoles(PersistedRoles persistedRoles) throws Exception {
    }

    @Override
    public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
    }

    @Override
    public void deleteSecurityRoles(SimpleString addressMatch) throws Exception {
    }

    @Override
    public void deletePageTransactional(long recordID) throws Exception {
    }

    @Override
    public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depage) throws Exception {
    }

    @Override
    public void storeCursorAcknowledge(long queueID, PagePosition position) {
    }

    @Override
    public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) {
    }

    @Override
    public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
    }

    @Override
    public void storePageCompleteTransactional(long txID, long queueID, PagePosition position) throws Exception {
    }

    @Override
    public void deletePageComplete(long ackID) throws Exception {
    }

    @Override
    public void updatePageTransaction(PageTransactionInfo pageTransaction, int depage) throws Exception {
    }

    @Override
    public long storePageCounter(long txID, long queueID, long value) throws Exception {
        return 0L;
    }

    @Override
    public void deleteIncrementRecord(long txID, long recordID) throws Exception {
    }

    @Override
    public void deletePageCounter(long txID, long recordID) throws Exception {
    }

    @Override
    public long storePageCounterInc(long txID, long queueID, int add) throws Exception {
        return 0L;
    }

    @Override
    public long storePageCounterInc(long queueID, int add) throws Exception {
        return 0L;
    }

    @Override
    public void commit(long txID, boolean lineUpContext) throws Exception {
    }

    @Override
    public void lineUpContext() {
    }

    @Override
    public void confirmPendingLargeMessageTX(Transaction transaction, long messageID, long recordID) throws Exception {
    }

    @Override
    public void confirmPendingLargeMessage(long recordID) throws Exception {
    }

    @Override
    public void stop(boolean ioCriticalError) throws Exception {
    }

    @Override
    public Journal getBindingsJournal() {
        return null;
    }

    @Override
    public Journal getMessageJournal() {
        return null;
    }

    @Override
    public void startReplication(ReplicationManager replicationManager, PagingManager pagingManager, String nodeID, boolean autoFailBack) throws Exception {
    }

    @Override
    public boolean addToPage(PagingStore s, ServerMessage msg, Transaction tx, RouteContextList listCtx) throws Exception {
        return false;
    }

    @Override
    public void stopReplication() {
    }

    @Override
    public SequentialFile createFileForLargeMessage(long messageID, String extension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBytesToLargeMessage(SequentialFile appendFile, long messageID, byte[] bytes) throws Exception {
    }

    @Override
    public void beforePageRead() throws Exception {
    }

    @Override
    public void afterPageRead() throws Exception {
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
    }

    @Override
    public void storeID(long journalID, long id) throws Exception {
    }
}

