/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.utils.Pair;

public class DuplicateIDCacheImpl
implements DuplicateIDCache {
    private final Map<ByteArrayHolder, Integer> cache = new ConcurrentHashMap<ByteArrayHolder, Integer>();
    private final SimpleString address;
    private final ArrayList<Pair<ByteArrayHolder, Long>> ids;
    private int pos;
    private final int cacheSize;
    private final StorageManager storageManager;
    private final boolean persist;

    public DuplicateIDCacheImpl(SimpleString address, int size, StorageManager storageManager, boolean persist) {
        this.address = address;
        this.cacheSize = size;
        this.ids = new ArrayList(size);
        this.storageManager = storageManager;
        this.persist = persist;
    }

    @Override
    public void load(List<Pair<byte[], Long>> theIds) throws Exception {
        int count = 0;
        long txID = -1L;
        for (Pair<byte[], Long> id : theIds) {
            if (count < this.cacheSize) {
                ByteArrayHolder bah = new ByteArrayHolder((byte[])id.getA());
                Pair pair = new Pair((Object)bah, id.getB());
                this.cache.put(bah, this.ids.size());
                this.ids.add((Pair<ByteArrayHolder, Long>)pair);
            } else {
                if (txID == -1L) {
                    txID = this.storageManager.generateUniqueID();
                }
                this.storageManager.deleteDuplicateIDTransactional(txID, (Long)id.getB());
            }
            ++count;
        }
        if (txID != -1L) {
            this.storageManager.commit(txID);
        }
        this.pos = this.ids.size();
        if (this.pos == this.cacheSize) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromCache(byte[] duplicateID) throws Exception {
        ByteArrayHolder bah = new ByteArrayHolder(duplicateID);
        Integer posUsed = this.cache.remove(bah);
        if (posUsed != null) {
            DuplicateIDCacheImpl duplicateIDCacheImpl = this;
            synchronized (duplicateIDCacheImpl) {
                Pair<ByteArrayHolder, Long> id = this.ids.get(posUsed);
                if (((ByteArrayHolder)id.getA()).equals(bah)) {
                    id.setA(null);
                    this.storageManager.deleteDuplicateID((Long)id.getB());
                    id.setB(null);
                }
            }
        }
    }

    @Override
    public boolean contains(byte[] duplID) {
        return this.cache.get(new ByteArrayHolder(duplID)) != null;
    }

    @Override
    public synchronized void addToCache(byte[] duplID, Transaction tx) throws Exception {
        long recordID = -1L;
        if (tx == null) {
            if (this.persist) {
                recordID = this.storageManager.generateUniqueID();
                this.storageManager.storeDuplicateID(this.address, duplID, recordID);
            }
            this.addToCacheInMemory(duplID, recordID);
        } else {
            if (this.persist) {
                recordID = this.storageManager.generateUniqueID();
                this.storageManager.storeDuplicateIDTransactional(tx.getID(), this.address, duplID, recordID);
                tx.setContainsPersistent();
            }
            tx.addOperation(new AddDuplicateIDOperation(duplID, recordID));
        }
    }

    @Override
    public void load(Transaction tx, byte[] duplID) {
        tx.addOperation(new AddDuplicateIDOperation(duplID, tx.getID()));
    }

    private synchronized void addToCacheInMemory(byte[] duplID, long recordID) {
        ByteArrayHolder holder = new ByteArrayHolder(duplID);
        this.cache.put(holder, this.pos);
        if (this.pos < this.ids.size()) {
            Pair<ByteArrayHolder, Long> id = this.ids.get(this.pos);
            if (id.getA() != null) {
                this.cache.remove(id.getA());
                if (id.getB() != null) {
                    try {
                        this.storageManager.deleteDuplicateID((Long)id.getB());
                    }
                    catch (Exception e) {
                        HornetQLogger.LOGGER.errorDeletingDuplicateCache(e);
                    }
                }
            }
            id.setA((Object)holder);
            id.setB((Object)(recordID >= 0L ? Long.valueOf(recordID) : null));
            holder.pos = this.pos;
        } else {
            Pair id = new Pair((Object)holder, (Object)(recordID >= 0L ? Long.valueOf(recordID) : null));
            this.ids.add((Pair<ByteArrayHolder, Long>)id);
            holder.pos = this.pos;
        }
        if (this.pos++ == this.cacheSize - 1) {
            this.pos = 0;
        }
    }

    private static final class ByteArrayHolder {
        final byte[] bytes;
        int hash;
        int pos;

        ByteArrayHolder(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayHolder) {
                ByteArrayHolder s = (ByteArrayHolder)other;
                if (this.bytes.length != s.bytes.length) {
                    return false;
                }
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == s.bytes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (byte b : this.bytes) {
                    this.hash = 31 * this.hash + b;
                }
            }
            return this.hash;
        }
    }

    private class AddDuplicateIDOperation
    implements TransactionOperation {
        final byte[] duplID;
        final long recordID;
        volatile boolean done;

        AddDuplicateIDOperation(byte[] duplID, long recordID) {
            this.duplID = duplID;
            this.recordID = recordID;
        }

        private void process() {
            if (!this.done) {
                DuplicateIDCacheImpl.this.addToCacheInMemory(this.duplID, this.recordID);
                this.done = true;
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public void afterCommit(Transaction tx) {
            this.process();
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }
}

