/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.hornetq.api.core.HornetQAlreadyReplicatingException;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.ServerSessionPacketHandler;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.protocol.core.impl.HornetQPacketHandler;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.utils.Pair;

class CoreProtocolManager
implements ProtocolManager {
    private static final boolean isTrace = HornetQLogger.LOGGER.isTraceEnabled();
    private final HornetQServer server;
    private final List<Interceptor> interceptors;
    private final Map<String, ServerSessionPacketHandler> sessionHandlers = new ConcurrentHashMap<String, ServerSessionPacketHandler>();

    CoreProtocolManager(HornetQServer server, List<Interceptor> interceptors) {
        this.server = server;
        this.interceptors = interceptors;
    }

    @Override
    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        Configuration config = this.server.getConfiguration();
        Executor connectionExecutor = this.server.getExecutorFactory().getExecutor();
        RemotingConnectionImpl rc = new RemotingConnectionImpl(connection, this.interceptors, config.isAsyncConnectionExecutionEnabled() ? connectionExecutor : null, this.server.getNodeID());
        Channel channel1 = rc.getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
        HornetQPacketHandler handler = new HornetQPacketHandler(this, this.server, channel1, rc);
        channel1.setHandler(handler);
        long ttl = 60000L;
        if (config.getConnectionTTLOverride() != -1L) {
            ttl = config.getConnectionTTLOverride();
        }
        ConnectionEntry entry = new ConnectionEntry(rc, connectionExecutor, System.currentTimeMillis(), ttl);
        Channel channel0 = rc.getChannel(0L, -1);
        channel0.setHandler(new LocalChannelHandler(config, entry, channel0, acceptorUsed, rc));
        return entry;
    }

    ServerSessionPacketHandler getSessionHandler(String sessionName) {
        return this.sessionHandlers.get(sessionName);
    }

    void addSessionHandler(String name, ServerSessionPacketHandler handler) {
        this.sessionHandlers.put(name, handler);
    }

    @Override
    public void removeHandler(String name) {
        this.sessionHandlers.remove(name);
    }

    @Override
    public void handleBuffer(RemotingConnection connection, HornetQBuffer buffer) {
    }

    @Override
    public int isReadyToHandle(HornetQBuffer buffer) {
        return -1;
    }

    public String toString() {
        return "CoreProtocolManager(server=" + this.server + ")";
    }

    private class LocalChannelHandler
    implements ChannelHandler {
        private final Configuration config;
        private final ConnectionEntry entry;
        private final Channel channel0;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection rc;

        public LocalChannelHandler(Configuration config, ConnectionEntry entry, Channel channel0, Acceptor acceptorUsed, CoreRemotingConnection rc) {
            this.config = config;
            this.entry = entry;
            this.channel0 = channel0;
            this.acceptorUsed = acceptorUsed;
            this.rc = rc;
        }

        @Override
        public void handlePacket(Packet packet) {
            if (packet.getType() == 10) {
                Ping ping = (Ping)packet;
                if (this.config.getConnectionTTLOverride() == -1L) {
                    this.entry.ttl = ping.getConnectionTTL();
                }
                this.channel0.send(packet);
            } else if (packet.getType() == 112 || packet.getType() == 113) {
                SubscribeClusterTopologyUpdatesMessage msg = (SubscribeClusterTopologyUpdatesMessage)packet;
                if (packet.getType() == 113) {
                    this.channel0.getConnection().setClientVersion(((SubscribeClusterTopologyUpdatesMessageV2)msg).getClientVersion());
                }
                final ClusterTopologyListener listener = new ClusterTopologyListener(){

                    @Override
                    public void nodeUP(final TopologyMember topologyMember, final boolean last) {
                        try {
                            final Pair connectorPair = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
                            final String nodeID = topologyMember.getNodeId();
                            ((LocalChannelHandler)LocalChannelHandler.this).entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                        LocalChannelHandler.this.channel0.send(new ClusterTopologyChangeMessage_V2(topologyMember.getUniqueEventID(), nodeID, topologyMember.getBackupGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)connectorPair, last));
                                    } else {
                                        LocalChannelHandler.this.channel0.send(new ClusterTopologyChangeMessage(nodeID, (Pair<TransportConfiguration, TransportConfiguration>)connectorPair, last));
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void nodeDown(final long uniqueEventID, final String nodeID) {
                        try {
                            ((LocalChannelHandler)LocalChannelHandler.this).entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                        LocalChannelHandler.this.channel0.send(new ClusterTopologyChangeMessage_V2(uniqueEventID, nodeID));
                                    } else {
                                        LocalChannelHandler.this.channel0.send(new ClusterTopologyChangeMessage(nodeID));
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException ignored) {
                            // empty catch block
                        }
                    }

                    public String toString() {
                        return "Remote Proxy on channel " + Integer.toHexString(System.identityHashCode(this));
                    }
                };
                if (this.acceptorUsed.getClusterConnection() != null) {
                    this.acceptorUsed.getClusterConnection().addClusterTopologyListener(listener);
                    this.rc.addCloseListener(new CloseListener(){

                        @Override
                        public void connectionClosed() {
                            LocalChannelHandler.this.acceptorUsed.getClusterConnection().removeClusterTopologyListener(listener);
                        }
                    });
                } else {
                    this.entry.connectionExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            String nodeId = CoreProtocolManager.this.server.getNodeID().toString();
                            Pair emptyConfig = new Pair(null, null);
                            if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                LocalChannelHandler.this.channel0.send(new ClusterTopologyChangeMessage_V2(System.currentTimeMillis(), nodeId, CoreProtocolManager.this.server.getConfiguration().getName(), (Pair<TransportConfiguration, TransportConfiguration>)emptyConfig, true));
                            } else {
                                LocalChannelHandler.this.channel0.send(new ClusterTopologyChangeMessage(nodeId, (Pair<TransportConfiguration, TransportConfiguration>)emptyConfig, true));
                            }
                        }
                    });
                }
            } else if (packet.getType() == 111) {
                NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                Pair pair = msg.isBackup() ? new Pair(null, (Object)msg.getConnector()) : new Pair((Object)msg.getConnector(), (Object)msg.getBackupConnector());
                if (isTrace) {
                    HornetQLogger.LOGGER.trace("Server " + CoreProtocolManager.this.server + " receiving nodeUp from NodeID=" + msg.getNodeID() + ", pair=" + pair);
                }
                if (this.acceptorUsed != null) {
                    ClusterConnection clusterConn = this.acceptorUsed.getClusterConnection();
                    if (clusterConn != null) {
                        clusterConn.nodeAnnounced(msg.getCurrentEventID(), msg.getNodeID(), msg.getNodeName(), (Pair<TransportConfiguration, TransportConfiguration>)pair, msg.isBackup());
                    } else {
                        HornetQLogger.LOGGER.debug("Cluster connection is null on acceptor = " + this.acceptorUsed);
                    }
                } else {
                    HornetQLogger.LOGGER.debug("there is no acceptor used configured at the CoreProtocolManager " + this);
                }
            } else if (packet.getType() == 115) {
                BackupRegistrationMessage msg = (BackupRegistrationMessage)packet;
                ClusterConnection clusterConnection = this.acceptorUsed.getClusterConnection();
                if (clusterConnection.verify(msg.getClusterUser(), msg.getClusterPassword())) {
                    try {
                        CoreProtocolManager.this.server.startReplication(this.rc, clusterConnection, this.getPair(msg.getConnector(), true), msg.isFailBackRequest());
                    }
                    catch (HornetQAlreadyReplicatingException are) {
                        this.channel0.send(new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.ALREADY_REPLICATING));
                    }
                    catch (HornetQException e) {
                        this.channel0.send(new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.EXCEPTION));
                    }
                } else {
                    this.channel0.send(new BackupReplicationStartFailedMessage(BackupReplicationStartFailedMessage.BackupRegistrationProblem.AUTHENTICATION));
                }
            }
        }

        private Pair<TransportConfiguration, TransportConfiguration> getPair(TransportConfiguration conn, boolean isBackup) {
            if (isBackup) {
                return new Pair(null, (Object)conn);
            }
            return new Pair((Object)conn, null);
        }
    }
}

