/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class ReplicationCommitMessage
extends PacketImpl {
    private byte journalID;
    private boolean rollback;
    private long txId;
    private boolean sync;

    public ReplicationCommitMessage() {
        super((byte)96);
    }

    public ReplicationCommitMessage(byte journalID, boolean rollback, long txId, boolean sync) {
        this();
        this.journalID = journalID;
        this.rollback = rollback;
        this.txId = txId;
        this.sync = sync;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.rollback);
        buffer.writeLong(this.txId);
        buffer.writeBoolean(this.sync);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.rollback = buffer.readBoolean();
        this.txId = buffer.readLong();
        this.sync = buffer.readBoolean();
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public long getTxId() {
        return this.txId;
    }

    public boolean getSync() {
        return this.sync;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.journalID;
        result = 31 * result + (this.rollback ? 1231 : 1237);
        result = 31 * result + (this.sync ? 1231 : 1237);
        result = 31 * result + (int)(this.txId ^ this.txId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationCommitMessage)) {
            return false;
        }
        ReplicationCommitMessage other = (ReplicationCommitMessage)obj;
        if (this.journalID != other.journalID) {
            return false;
        }
        if (this.rollback != other.rollback) {
            return false;
        }
        if (this.sync != other.sync) {
            return false;
        }
        return this.txId == other.txId;
    }

    @Override
    public String toString() {
        String txOperation = this.rollback ? "rollback" : "commmit";
        return ReplicationCommitMessage.class.getSimpleName() + "[type=" + this.getType() + ", channel=" + this.getChannelID() + ", journalID=" + this.journalID + ", txAction='" + txOperation + "']";
    }
}

