/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public final class ReplicationSyncFileMessage
extends PacketImpl {
    private JournalStorageManager.JournalContent journalType;
    private long fileId;
    private int dataSize;
    private ByteBuffer byteBuffer;
    private byte[] byteArray;
    private SimpleString pageStoreName;
    private FileType fileType;

    public ReplicationSyncFileMessage() {
        super((byte)103);
    }

    public ReplicationSyncFileMessage(JournalStorageManager.JournalContent content, SimpleString storeName, long id, int size, ByteBuffer buffer) {
        this();
        this.byteBuffer = buffer;
        this.pageStoreName = storeName;
        this.dataSize = size;
        this.fileId = id;
        this.journalType = content;
        this.determineType();
    }

    private void determineType() {
        this.fileType = this.journalType != null ? FileType.JOURNAL : (this.pageStoreName != null ? FileType.PAGE : FileType.LARGE_MESSAGE);
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.fileId);
        if (this.fileId == -1L) {
            return;
        }
        buffer.writeByte(this.fileType.code);
        switch (this.fileType) {
            case JOURNAL: {
                buffer.writeByte(this.journalType.typeByte);
                break;
            }
            case PAGE: {
                buffer.writeSimpleString(this.pageStoreName);
                break;
            }
        }
        buffer.writeInt(this.dataSize);
        if (this.dataSize > 0) {
            buffer.writeBytes(this.byteBuffer);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.fileId = buffer.readLong();
        switch (FileType.getFileType(buffer.readByte())) {
            case JOURNAL: {
                this.journalType = JournalStorageManager.JournalContent.getType(buffer.readByte());
                this.fileType = FileType.JOURNAL;
                break;
            }
            case PAGE: {
                this.pageStoreName = buffer.readSimpleString();
                this.fileType = FileType.PAGE;
                break;
            }
            case LARGE_MESSAGE: {
                this.fileType = FileType.LARGE_MESSAGE;
            }
        }
        int size = buffer.readInt();
        if (size > 0) {
            this.byteArray = new byte[size];
            buffer.readBytes(this.byteArray);
        }
    }

    public long getId() {
        return this.fileId;
    }

    public JournalStorageManager.JournalContent getJournalContent() {
        return this.journalType;
    }

    public byte[] getData() {
        return this.byteArray;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public SimpleString getPageStore() {
        return this.pageStoreName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.byteArray);
        result = 31 * result + (this.byteBuffer == null ? 0 : this.byteBuffer.hashCode());
        result = 31 * result + this.dataSize;
        result = 31 * result + (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + (this.fileType == null ? 0 : this.fileType.hashCode());
        result = 31 * result + (this.journalType == null ? 0 : this.journalType.hashCode());
        result = 31 * result + (this.pageStoreName == null ? 0 : this.pageStoreName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationSyncFileMessage)) {
            return false;
        }
        ReplicationSyncFileMessage other = (ReplicationSyncFileMessage)obj;
        if (!Arrays.equals(this.byteArray, other.byteArray)) {
            return false;
        }
        if (this.byteBuffer == null ? other.byteBuffer != null : !this.byteBuffer.equals(other.byteBuffer)) {
            return false;
        }
        if (this.dataSize != other.dataSize) {
            return false;
        }
        if (this.fileId != other.fileId) {
            return false;
        }
        if (this.fileType != other.fileType) {
            return false;
        }
        if (this.journalType != other.journalType) {
            return false;
        }
        return !(this.pageStoreName == null ? other.pageStoreName != null : !this.pageStoreName.equals((Object)other.pageStoreName));
    }

    @Override
    public String toString() {
        return ReplicationSyncFileMessage.class.getSimpleName() + "(" + (Object)((Object)this.fileType) + (this.journalType != null ? ", " + (Object)((Object)this.journalType) : "") + ", id=" + this.fileId + ")";
    }

    public static enum FileType {
        JOURNAL(0),
        PAGE(1),
        LARGE_MESSAGE(2);

        private byte code;
        private static final Set<FileType> ALL_OF;

        private FileType(int code) {
            this.code = (byte)code;
        }

        public static FileType getFileType(byte readByte) {
            for (FileType type : ALL_OF) {
                if (type.code != readByte) continue;
                return type;
            }
            throw new InternalError("Unsupported byte value for " + FileType.class);
        }

        static {
            ALL_OF = EnumSet.allOf(FileType.class);
        }
    }
}

