/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.impl.wireformat.MessagePacket;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;

public class SessionSendMessage
extends MessagePacket {
    private boolean requiresResponse;

    public SessionSendMessage(MessageInternal message, boolean requiresResponse) {
        super((byte)71, message);
        this.requiresResponse = requiresResponse;
    }

    public SessionSendMessage() {
        super((byte)71, new ServerMessageImpl());
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    @Override
    public HornetQBuffer encode(RemotingConnection connection) {
        HornetQBuffer buffer = this.message.getEncodedBuffer();
        if (buffer.writerIndex() != this.message.getEndOfMessagePosition()) {
            throw new IllegalStateException("Wrong encode position");
        }
        buffer.writeBoolean(this.requiresResponse);
        this.size = buffer.writerIndex();
        int len = this.size - 4;
        buffer.setInt(0, len);
        buffer.setByte(4, this.getType());
        buffer.setLong(5, this.channelID);
        buffer.readerIndex(0);
        this.message.resetCopied();
        return buffer;
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.message.decodeFromBuffer(buffer);
        int ri = buffer.readerIndex();
        this.requiresResponse = buffer.readBoolean();
        buffer.readerIndex(ri);
    }
}

