/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import java.io.IOException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.utils.UUID;

public abstract class NodeManager
implements HornetQComponent {
    private boolean isStarted = false;
    private final Object nodeIDGuard = new Object();
    private SimpleString nodeID;
    private UUID uuid;
    private String nodeGroupName;

    public abstract void awaitLiveNode() throws Exception;

    public abstract void startBackup() throws Exception;

    public abstract void startLiveNode() throws Exception;

    public abstract void pauseLiveServer() throws Exception;

    public abstract void crashLiveServer() throws Exception;

    public abstract void stopBackup() throws Exception;

    public abstract void releaseBackup() throws Exception;

    public void start() throws Exception {
        this.isStarted = true;
    }

    public void stop() throws Exception {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleString getNodeId() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.nodeID;
        }
    }

    public abstract SimpleString readNodeId() throws HornetQIllegalStateException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID() {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            return this.uuid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeID(String nodeID) {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.nodeID = new SimpleString(nodeID);
            this.uuid = new UUID(1, UUID.stringToBytes((String)nodeID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUUID(UUID generateUUID) {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            this.uuid = generateUUID;
            this.nodeID = new SimpleString(this.uuid.toString());
        }
    }

    public void setNodeGroupName(String nodeGroupName) {
        this.nodeGroupName = nodeGroupName;
    }

    public String getNodeGroupName() {
        return this.nodeGroupName;
    }

    public abstract boolean isAwaitingFailback() throws Exception;

    public abstract boolean isBackupLive() throws Exception;

    public abstract void interrupt();
}

