/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.core.server.impl.QuorumManager;
import org.hornetq.utils.Pair;

public class AnyLiveNodeLocator
extends LiveNodeLocator {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> untriedConnectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    Map<String, Pair<TransportConfiguration, TransportConfiguration>> triedConnectors = new HashMap<String, Pair<TransportConfiguration, TransportConfiguration>>();
    private String nodeID;

    public AnyLiveNodeLocator(QuorumManager quorumManager) {
        super(quorumManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateNode() throws HornetQException {
        try {
            this.lock.lock();
            if (this.untriedConnectors.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        try {
            this.lock.lock();
            Pair connector = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
            this.untriedConnectors.put(topologyMember.getNodeId(), (Pair<TransportConfiguration, TransportConfiguration>)connector);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDown(long eventUID, String nodeID) {
        try {
            this.lock.lock();
            this.untriedConnectors.putAll(this.triedConnectors);
            this.triedConnectors.clear();
            if (this.untriedConnectors.size() > 0) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<TransportConfiguration, TransportConfiguration> getLiveConfiguration() {
        try {
            this.lock.lock();
            Iterator<String> iterator = this.untriedConnectors.keySet().iterator();
            if (iterator.hasNext()) {
                this.nodeID = iterator.next();
            }
            Pair<TransportConfiguration, TransportConfiguration> pair = this.untriedConnectors.get(this.nodeID);
            return pair;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyRegistrationFailed(boolean alreadyReplicating) {
        try {
            this.lock.lock();
            Pair<TransportConfiguration, TransportConfiguration> tc = this.untriedConnectors.remove(this.nodeID);
            if (tc != null) {
                this.triedConnectors.put(this.nodeID, tc);
            }
        }
        finally {
            this.lock.unlock();
        }
        super.notifyRegistrationFailed(alreadyReplicating);
    }
}

