/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;

public class FileLockNodeManager
extends NodeManager {
    private static final String SERVER_LOCK_NAME = "server.lock";
    private static final String ACCESS_MODE = "rw";
    private static final int LIVE_LOCK_POS = 1;
    private static final int BACKUP_LOCK_POS = 2;
    private static final int LOCK_LENGTH = 1;
    private static final byte LIVE = 76;
    private static final byte FAILINGBACK = 70;
    private static final byte PAUSED = 80;
    private static final byte NOT_STARTED = 78;
    private static final byte FIRST_TIME_START = 48;
    private FileChannel channel;
    private FileLock liveLock;
    private FileLock backupLock;
    private final String directory;
    protected boolean interrupted = false;

    public FileLockNodeManager(String directory) {
        this.directory = directory;
    }

    @Override
    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        File file = this.newFile(SERVER_LOCK_NAME);
        boolean fileCreated = false;
        if (!file.exists()) {
            try {
                fileCreated = file.createNewFile();
            }
            catch (Exception e) {
                HornetQLogger.LOGGER.nodeManagerCantOpenFile(e, file);
                throw e;
            }
            if (!fileCreated) {
                throw new IllegalStateException("Unable to create server lock file");
            }
        }
        RandomAccessFile raFile = new RandomAccessFile(file, ACCESS_MODE);
        this.channel = raFile.getChannel();
        if (fileCreated) {
            ByteBuffer id = ByteBuffer.allocateDirect(3);
            byte[] bytes = new byte[]{48, 48, 48};
            id.put(bytes, 0, 3);
            id.position(0);
            this.channel.write(id, 0L);
            this.channel.force(true);
        }
        this.createNodeId();
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.channel.close();
        super.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws Exception {
        return this.getState() == 70;
    }

    @Override
    public boolean isBackupLive() throws Exception {
        FileLock liveAttemptLock = this.tryLock(1);
        if (liveAttemptLock == null) {
            return true;
        }
        liveAttemptLock.release();
        return false;
    }

    public boolean isLiveLocked() {
        return this.liveLock != null;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public void releaseBackup() throws Exception {
        this.releaseBackupLock();
    }

    @Override
    public void awaitLiveNode() throws Exception {
        byte state;
        while (true) {
            state = this.getState();
            while (state == 78 || state == 48) {
                HornetQLogger.LOGGER.debug("awaiting live node startup state='" + state + "'");
                Thread.sleep(2000L);
                state = this.getState();
            }
            this.liveLock = this.lock(1);
            state = this.getState();
            if (state == 80) {
                this.liveLock.release();
                HornetQLogger.LOGGER.debug("awaiting live node restarting");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 70) {
                this.liveLock.release();
                HornetQLogger.LOGGER.debug("awaiting live node failing back");
                Thread.sleep(2000L);
                continue;
            }
            if (state == 76) break;
        }
        HornetQLogger.LOGGER.debug("acquired live node lock state = " + (char)state);
    }

    @Override
    public void startBackup() throws Exception {
        HornetQLogger.LOGGER.waitingToBecomeBackup();
        this.backupLock = this.lock(2);
        HornetQLogger.LOGGER.gotBackupLock();
        if (this.getUUID() == null) {
            this.readNodeId();
        }
    }

    @Override
    public void startLiveNode() throws Exception {
        this.setFailingBack();
        HornetQLogger.LOGGER.waitingToObtainLiveLock();
        this.liveLock = this.lock(1);
        HornetQLogger.LOGGER.obtainedLiveLock();
        this.setLive();
    }

    @Override
    public void pauseLiveServer() throws Exception {
        this.setPaused();
        if (this.liveLock != null) {
            this.liveLock.release();
        }
    }

    @Override
    public void crashLiveServer() throws Exception {
        if (this.liveLock != null) {
            this.liveLock.release();
            this.liveLock = null;
        }
    }

    @Override
    public void stopBackup() throws Exception {
        if (this.backupLock != null) {
            this.backupLock.release();
            this.backupLock = null;
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    private void setLive() throws Exception {
        this.writeFileLockStatus((byte)76);
    }

    private void setFailingBack() throws Exception {
        this.writeFileLockStatus((byte)70);
    }

    private void setPaused() throws Exception {
        this.writeFileLockStatus((byte)80);
    }

    private void writeFileLockStatus(byte status) throws IOException {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put(status);
        bb.position(0);
        this.channel.write(bb, 0L);
        this.channel.force(true);
    }

    private byte getState() throws Exception {
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        int read = this.channel.read(bb, 0L);
        if (read <= 0) {
            return 78;
        }
        return bb.get(0);
    }

    private void releaseBackupLock() throws Exception {
        if (this.backupLock != null) {
            this.backupLock.release();
            this.backupLock = null;
        }
    }

    private void createNodeId() throws Exception {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            this.setUUID(UUIDGenerator.getInstance().generateUUID());
            id.put(this.getUUID().asBytes(), 0, 16);
            id.position(0);
            this.channel.write(id, 3L);
            this.channel.force(true);
        } else {
            byte[] bytes = new byte[16];
            id.position(0);
            id.get(bytes);
            this.setUUID(new UUID(1, bytes));
        }
    }

    @Override
    public final SimpleString readNodeId() throws HornetQIllegalStateException, IOException {
        ByteBuffer id = ByteBuffer.allocateDirect(16);
        int read = this.channel.read(id, 3L);
        if (read != 16) {
            throw new HornetQIllegalStateException("live server did not write id to file");
        }
        byte[] bytes = new byte[16];
        id.position(0);
        id.get(bytes);
        this.setUUID(new UUID(1, bytes));
        return this.getNodeId();
    }

    protected File newFile(String fileName) {
        File file = new File(this.directory, fileName);
        return file;
    }

    protected FileLock tryLock(int lockPos) throws Exception {
        return this.channel.tryLock(lockPos, 1L, false);
    }

    protected FileLock lock(int liveLockPos) throws IOException {
        FileLock lock;
        while (!this.interrupted) {
            lock = null;
            try {
                lock = this.channel.tryLock(liveLockPos, 1L, false);
            }
            catch (OverlappingFileLockException ex) {
                // empty catch block
            }
            if (lock == null) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            return lock;
        }
        do {
            if ((lock = this.channel.tryLock(liveLockPos, 1L, false)) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.interrupted) continue;
            this.interrupted = false;
            throw new IOException("Lock was interrupted");
        } while (lock == null);
        return lock;
    }
}

