/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ScheduledDeliveryHandler;

public class ScheduledDeliveryHandlerImpl
implements ScheduledDeliveryHandler {
    private static final boolean trace = HornetQLogger.LOGGER.isTraceEnabled();
    private final ScheduledExecutorService scheduledExecutor;
    private final Object lockDelivery = new Object();
    private final LinkedList<MessageReference> scheduledReferences = new LinkedList();

    public ScheduledDeliveryHandlerImpl(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndSchedule(MessageReference ref, boolean tail) {
        long deliveryTime = ref.getScheduledDeliveryTime();
        if (deliveryTime > 0L && this.scheduledExecutor != null) {
            if (trace) {
                HornetQLogger.LOGGER.trace("Scheduling delivery for " + ref + " to occur at " + deliveryTime);
            }
            ScheduledDeliveryRunnable runnable = new ScheduledDeliveryRunnable(ref.getScheduledDeliveryTime());
            LinkedList<MessageReference> linkedList = this.scheduledReferences;
            synchronized (linkedList) {
                if (tail) {
                    this.scheduledReferences.addFirst(ref);
                } else {
                    this.scheduledReferences.add(ref);
                }
            }
            this.scheduleDelivery(runnable, deliveryTime);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScheduledCount() {
        LinkedList<MessageReference> linkedList = this.scheduledReferences;
        synchronized (linkedList) {
            return this.scheduledReferences.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getScheduledReferences() {
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        LinkedList<MessageReference> linkedList = this.scheduledReferences;
        synchronized (linkedList) {
            refs.addAll(this.scheduledReferences);
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> cancel(Filter filter) {
        ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        LinkedList<MessageReference> linkedList = this.scheduledReferences;
        synchronized (linkedList) {
            Iterator iter = this.scheduledReferences.iterator();
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                iter.remove();
                refs.add(ref);
            }
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageReference removeReferenceWithID(long id) {
        LinkedList<MessageReference> linkedList = this.scheduledReferences;
        synchronized (linkedList) {
            Iterator iter = this.scheduledReferences.iterator();
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != id) continue;
                iter.remove();
                return ref;
            }
        }
        return null;
    }

    private void scheduleDelivery(ScheduledDeliveryRunnable runnable, long deliveryTime) {
        long now = System.currentTimeMillis();
        long delay = deliveryTime - now;
        if (delay < 0L) {
            delay = 0L;
        }
        this.scheduledExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    private class ScheduledDeliveryRunnable
    implements Runnable {
        private final long scheduledTime;

        public ScheduledDeliveryRunnable(long scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap<Queue, LinkedList<MessageReference>> refs = new HashMap<Queue, LinkedList<MessageReference>>();
            Object object = ScheduledDeliveryHandlerImpl.this.lockDelivery;
            synchronized (object) {
                LinkedList linkedList = ScheduledDeliveryHandlerImpl.this.scheduledReferences;
                synchronized (linkedList) {
                    Iterator iter = ScheduledDeliveryHandlerImpl.this.scheduledReferences.iterator();
                    while (iter.hasNext()) {
                        MessageReference reference = (MessageReference)iter.next();
                        if (reference.getScheduledDeliveryTime() > this.scheduledTime) continue;
                        iter.remove();
                        reference.setScheduledDeliveryTime(0L);
                        LinkedList<MessageReference> references = (LinkedList<MessageReference>)refs.get(reference.getQueue());
                        if (references == null) {
                            references = new LinkedList<MessageReference>();
                            refs.put(reference.getQueue(), references);
                        }
                        references.add(reference);
                    }
                }
                for (Map.Entry entry : refs.entrySet()) {
                    ((Queue)entry.getKey()).addHead((List)entry.getValue());
                }
                refs.clear();
            }
        }
    }
}

