/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.hornetq.core.server.HornetQLogger;
import org.hornetq.utils.ExecutorFactory;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    private final Executor parent;

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    @Override
    public Executor getExecutor() {
        return new OrderedExecutor(this.parent);
    }

    private static final class OrderedExecutor
    implements Executor {
        private final LinkedList<Runnable> tasks = new LinkedList();
        private boolean running;
        private final Executor parent;
        private final Runnable runner;

        public OrderedExecutor(Executor parent) {
            this.parent = parent;
            this.runner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Runnable task;
                        LinkedList linkedList = OrderedExecutor.this.tasks;
                        synchronized (linkedList) {
                            task = (Runnable)OrderedExecutor.this.tasks.poll();
                            if (task == null) {
                                OrderedExecutor.this.running = false;
                                return;
                            }
                        }
                        try {
                            task.run();
                            continue;
                        }
                        catch (Throwable t) {
                            HornetQLogger.LOGGER.caughtunexpectedThrowable(t);
                            continue;
                        }
                        break;
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.add(command);
                if (!this.running) {
                    this.running = true;
                    this.parent.execute(this.runner);
                }
            }
        }

        public String toString() {
            return "OrderedExecutor(running=" + this.running + ", tasks=" + this.tasks + ")";
        }
    }
}

